/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dataone.cn.indexer.D1IndexerSolrClient;
import org.dataone.cn.indexer.parser.IDocumentDeleteSubprocessor;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseDocumentDeleteSubprocessor
implements IDocumentDeleteSubprocessor {
    private static Logger log = Logger.getLogger(BaseDocumentDeleteSubprocessor.class);
    private String instanceLabel;
    @Autowired
    private D1IndexerSolrClient d1IndexerSolrClient;
    @Autowired
    private String solrQueryUri;
    private String relationSourceFormatId;
    private String relationSourceField;
    private List<String> biDirectionalRelationFields;
    private List<String> uniDirectionalRelationFields;
    boolean usingAtomicUpdates = false;

    @Override
    public Map<String, SolrDoc> processDocForDelete(String identifier, Map<String, SolrDoc> docMap) throws Exception {
        SolrDoc indexedDoc = this.d1IndexerSolrClient.retrieveDocumentFromSolrServer(identifier, this.solrQueryUri);
        if (indexedDoc != null) {
            if (this.hasRelationsBySource(indexedDoc)) {
                docMap.putAll(this.removeBiDirectionalRelationsForDoc(identifier, indexedDoc, docMap));
            }
            if (this.isRelationshipSource(indexedDoc)) {
                docMap.putAll(this.removeRelationsBySourceDoc(identifier, indexedDoc, docMap));
            }
        }
        if (log.isDebugEnabled()) {
            if (docMap != null) {
                log.debug("... docs returned for [" + StringUtils.join(docMap.keySet(), ", ") + "]");
            } else {
                log.debug("... docs returned for [null]");
            }
        }
        return docMap;
    }

    private boolean isRelationshipSource(SolrDoc indexedDoc) throws Exception {
        String formatId = indexedDoc.getFirstFieldValue("formatId");
        return this.relationSourceFormatId.equals(formatId);
    }

    private Map<String, SolrDoc> removeRelationsBySourceDoc(String relationSourceId, SolrDoc indexedDoc, Map<String, SolrDoc> docs) throws Exception {
        List<SolrDoc> relatedDocs = this.d1IndexerSolrClient.getDocumentsByField(this.solrQueryUri, Collections.singletonList(relationSourceId), this.relationSourceField, true);
        HashSet<String> otherSourceDocs = new HashSet<String>();
        for (SolrDoc relatedDoc : relatedDocs) {
            otherSourceDocs.addAll(relatedDoc.getAllFieldValues(this.relationSourceField));
            String relatedDocId = relatedDoc.getFirstFieldValue("id");
            if (docs.get(relatedDocId) != null) {
                relatedDoc = docs.get(relatedDocId);
            }
            if (this.usingAtomicUpdates) {
                SolrElementField s;
                log.debug("...processing using atomic updates");
                ArrayList<SolrElementField> fields = new ArrayList<SolrElementField>();
                fields.add(relatedDoc.getField("id"));
                SolrElementField sef = new SolrElementField(this.relationSourceField, null);
                sef.setModifier(SolrElementField.Modifier.SET);
                fields.add(sef);
                for (String relationField : this.getBiDirectionalRelationFields()) {
                    s = new SolrElementField(relationField, null);
                    s.setModifier(SolrElementField.Modifier.SET);
                    fields.add(s);
                }
                for (String relationField : this.getUniDirectionalRelationFields()) {
                    s = new SolrElementField(relationField, null);
                    s.setModifier(SolrElementField.Modifier.SET);
                    fields.add(s);
                }
                SolrDoc sd = new SolrDoc(fields);
                docs.put(relatedDocId, sd);
                continue;
            }
            log.debug("...processing using non-atomic updates");
            relatedDoc.removeAllFields(this.relationSourceField);
            for (String relationField : this.getBiDirectionalRelationFields()) {
                relatedDoc.removeAllFields(relationField);
            }
            for (String relationField : this.getUniDirectionalRelationFields()) {
                relatedDoc.removeAllFields(relationField);
            }
            docs.put(relatedDocId, relatedDoc);
            log.debug("... ... putting doc in map " + relatedDocId);
        }
        for (String otherRelatedDoc : otherSourceDocs) {
            if (otherRelatedDoc.equals(relationSourceId)) continue;
            docs.put(otherRelatedDoc, null);
        }
        return docs;
    }

    private boolean hasRelationsBySource(SolrDoc indexedDoc) throws XPathExpressionException, IOException, EncoderException {
        String relationSourceId = indexedDoc.getFirstFieldValue(this.relationSourceField);
        return StringUtils.isNotEmpty(relationSourceId);
    }

    private Map<String, SolrDoc> removeBiDirectionalRelationsForDoc(String identifier, SolrDoc indexedDoc, Map<String, SolrDoc> docMap) throws Exception {
        for (String relationField : this.getBiDirectionalRelationFields()) {
            List<SolrDoc> relatedDocs = this.d1IndexerSolrClient.getDocumentsByField(this.solrQueryUri, Collections.singletonList(identifier), relationField, true);
            for (SolrDoc retrievedRelatedDoc : relatedDocs) {
                SolrDoc chosenRelatedDoc;
                String relatedDocId = retrievedRelatedDoc.getFirstFieldValue("id");
                SolrDoc solrDoc = chosenRelatedDoc = docMap.get(relatedDocId) != null ? docMap.get(relatedDocId) : retrievedRelatedDoc;
                if (this.usingAtomicUpdates) {
                    log.debug("...processing using atomic updates");
                    ArrayList<SolrElementField> fields = new ArrayList<SolrElementField>();
                    fields.add(chosenRelatedDoc.getField("id"));
                    SolrElementField sef = new SolrElementField(relationField, identifier);
                    sef.setModifier(SolrElementField.Modifier.REMOVE);
                    fields.add(sef);
                    SolrDoc sd = new SolrDoc(fields);
                    docMap.put(relatedDocId, sd);
                    log.debug("... ... putting doc in map " + relatedDocId);
                    continue;
                }
                log.debug("...processing using non-atomic updates");
                chosenRelatedDoc.removeFieldsWithValue(relationField, identifier);
                docMap.put(relatedDocId, chosenRelatedDoc);
                log.debug("... ... putting doc in map " + relatedDocId);
            }
        }
        return docMap;
    }

    private List<String> getBiDirectionalRelationFields() {
        if (this.biDirectionalRelationFields == null) {
            this.biDirectionalRelationFields = new ArrayList<String>();
        }
        return this.biDirectionalRelationFields;
    }

    private List<String> getUniDirectionalRelationFields() {
        if (this.uniDirectionalRelationFields == null) {
            this.uniDirectionalRelationFields = new ArrayList<String>();
        }
        return this.uniDirectionalRelationFields;
    }

    public String getRelationSourceFormatId() {
        return this.relationSourceFormatId;
    }

    public void setRelationSourceFormatId(String relationSourceFormatId) {
        this.relationSourceFormatId = relationSourceFormatId;
    }

    public String getRelationSourceField() {
        return this.relationSourceField;
    }

    public void setRelationSourceField(String relationSourceField) {
        this.relationSourceField = relationSourceField;
    }

    public void setBiDirectionalRelationFields(List<String> biDirectionalRelationFields) {
        this.biDirectionalRelationFields = biDirectionalRelationFields;
    }

    public void setUniDirectionalRelationFields(List<String> uniDirectionalRelationFields) {
        this.uniDirectionalRelationFields = uniDirectionalRelationFields;
    }

    public void setInstanceLabel(String instanceLabel) {
        this.instanceLabel = instanceLabel;
    }

    @Override
    public String getInstanceLabel() {
        return this.instanceLabel;
    }
}

