/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.cn.indexer.AbstractStubMergingSubprocessor;
import org.dataone.cn.indexer.parser.IDocumentSubprocessorV2;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.dataone.ore.ResourceMapFactory;
import org.dataone.service.types.v1.Identifier;
import org.dspace.foresite.OREParserException;

public class ResourceMapSubprocessorV2
extends AbstractStubMergingSubprocessor
implements IDocumentSubprocessorV2 {
    private static Logger logger = Logger.getLogger(ResourceMapSubprocessorV2.class.getName());
    private PerformanceLogger perfLog = PerformanceLogger.getInstance();
    private List<String> matchDocuments = null;
    private List<String> fieldsToMerge = new ArrayList<String>();

    @Override
    protected Map<String, SolrDoc> parseDocument(String identifier, InputStream resourceMapStream) throws Exception {
        long buildResMapStart = System.currentTimeMillis();
        Map<Identifier, Map<Identifier, List<Identifier>>> tmpResourceMap = null;
        try {
            tmpResourceMap = ResourceMapFactory.getInstance().parseResourceMap(resourceMapStream);
        }
        catch (Throwable e2) {
            logger.error("Unable to parse ORE document:", e2);
            throw new OREParserException(e2);
        }
        this.perfLog.log("ResourceMapFactory.buildResourceMap() create ResourceMap from InputStream", System.currentTimeMillis() - buildResMapStart);
        Map.Entry<Identifier, Map<Identifier, List<Identifier>>> resMapHierarchy = tmpResourceMap.entrySet().iterator().next();
        String resourceMapId = resMapHierarchy.getKey().getValue();
        Map<Identifier, List<Identifier>> metadataMap = resMapHierarchy.getValue();
        HashMap<String, SolrDoc> memberDocs = new HashMap<String, SolrDoc>();
        for (Identifier mId : metadataMap.keySet()) {
            String mdId = mId.getValue();
            if (!memberDocs.containsKey(mdId)) {
                memberDocs.put(mdId, new SolrDoc());
                ((SolrDoc)memberDocs.get(mdId)).addField(new SolrElementField("id", mdId));
                ((SolrDoc)memberDocs.get(mdId)).addField(new SolrElementField("resourceMap", resourceMapId));
            }
            for (Identifier dId : metadataMap.get(mId)) {
                String dataId = dId.getValue();
                if (!memberDocs.containsKey(dataId)) {
                    memberDocs.put(dataId, new SolrDoc());
                    ((SolrDoc)memberDocs.get(dataId)).addField(new SolrElementField("id", dataId));
                    ((SolrDoc)memberDocs.get(dataId)).addField(new SolrElementField("resourceMap", resourceMapId));
                }
                ((SolrDoc)memberDocs.get(dataId)).addField(new SolrElementField("isDocumentedBy", mdId));
                ((SolrDoc)memberDocs.get(mdId)).addField(new SolrElementField("documents", dataId));
            }
        }
        return memberDocs;
    }

    public List<String> getMatchDocuments() {
        return this.matchDocuments;
    }

    public void setMatchDocuments(List<String> matchDocuments) {
        this.matchDocuments = matchDocuments;
    }

    @Override
    public boolean canProcess(String formatId) {
        return this.matchDocuments.contains(formatId);
    }

    public List<String> getFieldsToMerge() {
        return this.fieldsToMerge;
    }

    public void setFieldsToMerge(List<String> fieldsToMerge) {
        this.fieldsToMerge = fieldsToMerge;
    }
}

