/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.io.Serializable;
import java.util.Date;
import org.quartz.SchedulerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulerMetaData
implements Serializable {
    private String schedName;
    private String schedInst;
    private Class<?> schedClass;
    private boolean isRemote;
    private boolean started;
    private boolean isInStandbyMode;
    private boolean shutdown;
    private Date startTime;
    private int numJobsExec;
    private Class<?> jsClass;
    private boolean jsPersistent;
    private boolean jsClustered;
    private Class<?> tpClass;
    private int tpSize;
    private String version;

    public SchedulerMetaData(String schedName, String schedInst, Class<?> schedClass, boolean isRemote, boolean started, boolean isInStandbyMode, boolean shutdown, Date startTime, int numJobsExec, Class<?> jsClass, boolean jsPersistent, boolean jsClustered, Class<?> tpClass, int tpSize, String version2) {
        this.schedName = schedName;
        this.schedInst = schedInst;
        this.schedClass = schedClass;
        this.isRemote = isRemote;
        this.started = started;
        this.isInStandbyMode = isInStandbyMode;
        this.shutdown = shutdown;
        this.startTime = startTime;
        this.numJobsExec = numJobsExec;
        this.jsClass = jsClass;
        this.jsPersistent = jsPersistent;
        this.jsClustered = jsClustered;
        this.tpClass = tpClass;
        this.tpSize = tpSize;
        this.version = version2;
    }

    public String getSchedulerName() {
        return this.schedName;
    }

    public String getSchedulerInstanceId() {
        return this.schedInst;
    }

    public Class<?> getSchedulerClass() {
        return this.schedClass;
    }

    public Date getRunningSince() {
        return this.startTime;
    }

    public int getNumberOfJobsExecuted() {
        return this.numJobsExec;
    }

    public boolean isSchedulerRemote() {
        return this.isRemote;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isInStandbyMode() {
        return this.isInStandbyMode;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public Class<?> getJobStoreClass() {
        return this.jsClass;
    }

    public boolean jobStoreSupportsPersistence() {
        return this.isJobStoreSupportsPersistence();
    }

    public boolean isJobStoreSupportsPersistence() {
        return this.jsPersistent;
    }

    public boolean isJobStoreClustered() {
        return this.jsClustered;
    }

    public Class<?> getThreadPoolClass() {
        return this.tpClass;
    }

    public int getThreadPoolSize() {
        return this.tpSize;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        try {
            return this.getSummary();
        }
        catch (SchedulerException se) {
            return "SchedulerMetaData: undeterminable.";
        }
    }

    public String getSummary() throws SchedulerException {
        StringBuffer str2 = new StringBuffer("Quartz Scheduler (v");
        str2.append(this.getVersion());
        str2.append(") '");
        str2.append(this.getSchedulerName());
        str2.append("' with instanceId '");
        str2.append(this.getSchedulerInstanceId());
        str2.append("'\n");
        str2.append("  Scheduler class: '");
        str2.append(this.getSchedulerClass().getName());
        str2.append("'");
        if (this.isSchedulerRemote()) {
            str2.append(" - access via RMI.");
        } else {
            str2.append(" - running locally.");
        }
        str2.append("\n");
        if (!this.isShutdown()) {
            if (this.getRunningSince() != null) {
                str2.append("  Running since: ");
                str2.append(this.getRunningSince());
            } else {
                str2.append("  NOT STARTED.");
            }
            str2.append("\n");
            if (this.isInStandbyMode()) {
                str2.append("  Currently in standby mode.");
            } else {
                str2.append("  Not currently in standby mode.");
            }
        } else {
            str2.append("  Scheduler has been SHUTDOWN.");
        }
        str2.append("\n");
        str2.append("  Number of jobs executed: ");
        str2.append(this.getNumberOfJobsExecuted());
        str2.append("\n");
        str2.append("  Using thread pool '");
        str2.append(this.getThreadPoolClass().getName());
        str2.append("' - with ");
        str2.append(this.getThreadPoolSize());
        str2.append(" threads.");
        str2.append("\n");
        str2.append("  Using job-store '");
        str2.append(this.getJobStoreClass().getName());
        str2.append("' - which ");
        if (this.isJobStoreSupportsPersistence()) {
            str2.append("supports persistence.");
        } else {
            str2.append("does not support persistence.");
        }
        if (this.isJobStoreClustered()) {
            str2.append(" and is clustered.");
        } else {
            str2.append(" and is not clustered.");
        }
        str2.append("\n");
        return str2.toString();
    }
}

