/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.AbstractRepositoryMetadata;
import org.springframework.util.Assert;

public class DefaultRepositoryMetadata
extends AbstractRepositoryMetadata {
    private static final String MUST_BE_A_REPOSITORY = String.format("Given type must be assignable to %s!", Repository.class);
    private final Class<? extends Serializable> idType;
    private final Class<?> domainType;

    public DefaultRepositoryMetadata(Class<?> repositoryInterface) {
        super(repositoryInterface);
        Assert.isTrue(Repository.class.isAssignableFrom(repositoryInterface), MUST_BE_A_REPOSITORY);
        this.idType = this.resolveIdType(repositoryInterface);
        this.domainType = this.resolveDomainType(repositoryInterface);
    }

    @Override
    public Class<?> getDomainType() {
        return this.domainType;
    }

    @Override
    public Class<? extends Serializable> getIdType() {
        return this.idType;
    }

    private Class<? extends Serializable> resolveIdType(Class<?> repositoryInterface) {
        Class[] arguments = GenericTypeResolver.resolveTypeArguments(repositoryInterface, Repository.class);
        if (arguments == null || arguments[1] == null) {
            throw new IllegalArgumentException(String.format("Could not resolve id type of %s!", repositoryInterface));
        }
        return arguments[1];
    }

    private Class<?> resolveDomainType(Class<?> repositoryInterface) {
        Class[] arguments = GenericTypeResolver.resolveTypeArguments(repositoryInterface, Repository.class);
        if (arguments == null || arguments[0] == null) {
            throw new IllegalArgumentException(String.format("Could not resolve domain type of %s!", repositoryInterface));
        }
        return arguments[0];
    }
}

