/*
 * Decompiled with CFR 0.152.
 */
package arq.examples;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.vocabulary.DC;

public class Ex1 {
    public static final String NL = System.getProperty("line.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Model model = Ex1.createModel();
        String prolog = "PREFIX dc: <" + DC.getURI() + ">";
        String queryString = prolog + NL + "SELECT ?title WHERE {?x dc:title ?title}";
        Query query2 = QueryFactory.create(queryString);
        query2.serialize(new IndentedWriter(System.out, true));
        System.out.println();
        QueryExecution qexec = QueryExecutionFactory.create(query2, model);
        System.out.println("Titles: ");
        try {
            ResultSet rs = qexec.execSelect();
            while (rs.hasNext()) {
                QuerySolution rb = rs.nextSolution();
                RDFNode x = rb.get("title");
                if (x.isLiteral()) {
                    Literal titleStr = (Literal)x;
                    System.out.println("    " + titleStr);
                    continue;
                }
                System.out.println("Strange - not a literal: " + x);
            }
        }
        finally {
            qexec.close();
        }
    }

    public static Model createModel() {
        Model m = ModelFactory.createDefaultModel();
        Resource r1 = m.createResource("http://example.org/book#1");
        Resource r2 = m.createResource("http://example.org/book#2");
        r1.addProperty(DC.title, "SPARQL - the book").addProperty(DC.description, "A book about SPARQL");
        r2.addProperty(DC.title, "Advanced techniques for SPARQL");
        return m;
    }
}

