/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.memcache;

import com.hazelcast.impl.ascii.AbstractTextCommandProcessor;
import com.hazelcast.impl.ascii.TextCommandService;
import com.hazelcast.impl.ascii.memcache.DeleteCommand;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteCommandProcessor
extends AbstractTextCommandProcessor<DeleteCommand> {
    public DeleteCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
    }

    @Override
    public void handle(DeleteCommand command) {
        String key;
        try {
            key = URLDecoder.decode(command.getKey(), "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(String.format("failed to decode key [%s] using UTF-8", command.getKey()));
        }
        String mapName = "default";
        int index = key.indexOf(58);
        if (index != -1) {
            mapName = key.substring(0, index);
            key = key.substring(index + 1);
        }
        command.setResponse(DELETED);
        if (command.shouldReply()) {
            this.textCommandService.sendResponse(command);
        }
        this.textCommandService.incrementDeleteCount();
        this.textCommandService.delete(mapName, key);
    }

    @Override
    public void handleRejection(DeleteCommand command) {
        this.handle(command);
    }
}

