/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.util.Clock;
import com.hazelcast.util.Prioritized;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final Object lock = new Object();
    private final LinkedList<E> items = new LinkedList();
    private final LinkedList<E> prioritizedItems;

    public SimpleBlockingQueue() {
        this(false);
    }

    public SimpleBlockingQueue(boolean priorityAware) {
        this.prioritizedItems = priorityAware ? new LinkedList() : null;
    }

    @Override
    public boolean offer(E e2) {
        this.put(e2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.prioritizedItems != null && e2 instanceof Prioritized) {
                this.prioritizedItems.add(e2);
            } else {
                this.items.add(e2);
            }
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object obj) {
        Object object = this.lock;
        synchronized (object) {
            boolean removed = this.items.remove(obj);
            if (!removed && this.prioritizedItems != null) {
                removed = this.prioritizedItems.remove(obj);
            }
            return removed;
        }
    }

    @Override
    public E take() throws InterruptedException {
        return this.poll(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        Object object = this.lock;
        synchronized (object) {
            return this.removeFirst();
        }
    }

    private E removeFirst() {
        E e2 = null;
        if (this.prioritizedItems != null && this.prioritizedItems.size() > 0) {
            e2 = this.prioritizedItems.removeFirst();
        } else if (this.items.size() > 0) {
            e2 = this.items.removeFirst();
        }
        return e2;
    }

    private int totalSize() {
        return this.items.size() + (this.prioritizedItems == null ? 0 : this.prioritizedItems.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long start = Clock.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            long now2;
            E e2 = this.removeFirst();
            for (long timeLeft = unit.toMillis(timeout); e2 == null && timeLeft > 0L; timeLeft -= now2 - start) {
                this.lock.wait(timeLeft);
                e2 = this.removeFirst();
                now2 = Clock.currentTimeMillis();
                start = now2;
            }
            return e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.items.clear();
            if (this.prioritizedItems != null) {
                this.prioritizedItems.clear();
            }
        }
    }

    @Override
    public boolean add(E e2) {
        this.put(e2);
        return true;
    }

    @Override
    public boolean offer(E e2, long timeout, TimeUnit unit) throws InterruptedException {
        this.put(e2);
        return true;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        Object object = this.lock;
        synchronized (object) {
            int count = 0;
            E removed = this.removeFirst();
            while (removed != null && count > maxElements) {
                c.add(removed);
                removed = this.removeFirst();
            }
            return count;
        }
    }

    @Override
    public E peek() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.totalSize();
        }
    }
}

