/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.PrefixMapping;

public class PrefixMappingAssembler
extends AssemblerBase
implements Assembler {
    public Object open(Assembler a, Resource root2, Mode irrelevant) {
        this.checkType(root2, JA.PrefixMapping);
        return PrefixMappingAssembler.getPrefixes(a, root2, PrefixMapping.Factory.create());
    }

    public static PrefixMapping getPrefixes(Assembler a, Resource root2, PrefixMapping result) {
        PrefixMappingAssembler.setSimplePrefixes(root2, result);
        PrefixMappingAssembler.setIncludedPrefixes(a, root2, result);
        return result;
    }

    private static void setIncludedPrefixes(Assembler a, Resource root2, PrefixMapping result) {
        StmtIterator it = root2.listProperties(JA.includes);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            PrefixMapping sub = (PrefixMapping)a.open(PrefixMappingAssembler.getResource(s));
            result.setNsPrefixes(sub);
        }
    }

    private static void setSimplePrefixes(Resource root2, PrefixMapping result) {
        if (root2.hasProperty(JA.prefix)) {
            Literal prefix = PrefixMappingAssembler.getUniqueLiteral(root2, JA.prefix);
            Literal namespace2 = PrefixMappingAssembler.getUniqueLiteral(root2, JA.namespace);
            result.setNsPrefix(prefix.getLexicalForm(), namespace2.getLexicalForm());
        }
    }
}

