/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.assemblers.AssemblerGroup;
import com.hp.hpl.jena.assembler.assemblers.ConnectionAssembler;
import com.hp.hpl.jena.assembler.assemblers.InfModelAssembler;
import com.hp.hpl.jena.assembler.exceptions.NoSpecificTypeException;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.mem.GraphMemBase;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.RDFS;
import junit.framework.Assert;

public class TestAssemblerGroup
extends AssemblerTestBase {
    public static boolean loaded = false;
    private static Assembler mockAssembler = new AssemblerBase(){

        public Object open(Assembler a, Resource root2, Mode mode) {
            return null;
        }
    };

    public TestAssemblerGroup(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return AssemblerGroup.class;
    }

    public void testEmptyAssemblerGroup() {
        AssemblerGroup a = AssemblerGroup.create();
        TestAssemblerGroup.assertInstanceOf(AssemblerGroup.class, a);
        TestAssemblerGroup.assertEquals(null, (Object)a.assemblerFor(TestAssemblerGroup.resource("ja:Anything")));
        this.checkFailsType(a, "rdf:Resource");
    }

    protected void checkFailsType(Assembler a, String type) {
        try {
            a.open(this.resourceInModel("x rdf:type " + type));
            TestAssemblerGroup.fail((String)"should trap missing implementation");
        }
        catch (NoSpecificTypeException e2) {
            TestAssemblerGroup.assertEquals((Object)TestAssemblerGroup.resource("x"), (Object)e2.getRoot());
        }
    }

    public void testLoadsClasses() {
        AssemblerGroup a = AssemblerGroup.create();
        a.implementWith(TestAssemblerGroup.resource("T"), new MockAssembler());
        Resource root2 = this.resourceInModel("x rdf:type T; _c ja:loadClass '" + TestAssemblerGroup.class.getName() + "$Trivial'");
        TestAssemblerGroup.assertFalse((String)"something has pre-loaded Trivial, so we can't test if it gets loaded", (boolean)loaded);
        TestAssemblerGroup.assertEquals((Object)"mockmockmock", (Object)a.open(root2));
        TestAssemblerGroup.assertTrue((String)"the assembler group did not obey the ja:loadClass directive", (boolean)loaded);
    }

    public void testSingletonAssemblerGroup() {
        AssemblerGroup a = AssemblerGroup.create();
        TestAssemblerGroup.assertSame((Object)a, (Object)a.implementWith(JA.InfModel, Assembler.infModel));
        a.openModel(this.resourceInModel("x rdf:type ja:InfModel"));
        this.checkFailsType(a, "js:DefaultModel");
    }

    public void testMultipleAssemblerGroup() {
        AssemblerGroup a = AssemblerGroup.create();
        TestAssemblerGroup.assertSame((Object)a, (Object)a.implementWith(JA.InfModel, Assembler.infModel));
        TestAssemblerGroup.assertSame((Object)a, (Object)a.implementWith(JA.MemoryModel, Assembler.memoryModel));
        TestAssemblerGroup.assertInstanceOf(InfModel.class, a.openModel(this.resourceInModel("x rdf:type ja:InfModel")));
        TestAssemblerGroup.assertFalse((boolean)(a.openModel(this.resourceInModel("y rdf:type ja:MemoryModel")) instanceof InfModel));
        this.checkFailsType(a, "js:DefaultModel");
    }

    public void testImpliedType() {
        AssemblerGroup a = AssemblerGroup.create();
        Resource root2 = this.resourceInModel("x ja:reasoner y");
        Object expected = new Object();
        a.implementWith(JA.InfModel, new AssemblerTestBase.NamedObjectAssembler(TestAssemblerGroup.resource("x"), expected));
        TestAssemblerGroup.assertSame((Object)expected, (Object)a.open(root2));
    }

    public void testBuiltinGroup() {
        AssemblerGroup g = Assembler.general;
        TestAssemblerGroup.assertInstanceOf(Model.class, g.open(this.resourceInModel("x rdf:type ja:DefaultModel")));
        TestAssemblerGroup.assertInstanceOf(InfModel.class, g.open(this.resourceInModel("x rdf:type ja:InfModel")));
        this.assertMemoryModel(g.open(this.resourceInModel("x rdf:type ja:MemoryModel")));
    }

    public void testAddingImplAddsSubclass() {
        final Model[] fullModel = new Model[1];
        AssemblerGroup.ExpandingAssemblerGroup g = new AssemblerGroup.ExpandingAssemblerGroup(){

            public void loadClasses(Model full) {
                fullModel[0] = full;
            }
        };
        Resource root2 = this.resourceInModel("root rdf:type typeA");
        Resource typeA = TestAssemblerGroup.resource("typeA");
        Resource typeB = TestAssemblerGroup.resource("typeB");
        ((AssemblerGroup)g).implementWith(typeA, mockAssembler);
        ((AssemblerGroup)g).implementWith(typeB, mockAssembler);
        g.open(root2);
        TestAssemblerGroup.assertTrue((boolean)fullModel[0].contains(typeA, RDFS.subClassOf, JA.Object));
        TestAssemblerGroup.assertTrue((boolean)fullModel[0].contains(typeB, RDFS.subClassOf, JA.Object));
    }

    public void testClassesLoadedBeforeAddingTypes() {
        String className = ImplementsSPOO.class.getName();
        Resource root2 = this.resourceInModel("_root rdf:type ja:MemoryModel; _x ja:loadClass '" + className + "'");
        AssemblerGroup.ExpandingAssemblerGroup g = new AssemblerGroup.ExpandingAssemblerGroup();
        g.implementWith(TestAssemblerGroup.resource("ja:MemoryModel"), mockAssembler);
        g.open(root2);
        TestAssemblerGroup.assertEquals((Object)TestAssemblerGroup.resourceSet("SPOO ja:MemoryModel"), (Object)g.implementsTypes());
    }

    protected void assertMemoryModel(Object object) {
        if (object instanceof Model) {
            Graph g = ((Model)object).getGraph();
            TestAssemblerGroup.assertInstanceOf(GraphMemBase.class, g);
        } else {
            TestAssemblerGroup.fail((String)("expected a Model, but got a " + object.getClass()));
        }
    }

    public void testPassesSelfIn() {
        final AssemblerGroup group = AssemblerGroup.create();
        final Object result = new Object();
        AssemblerBase fake = new AssemblerBase(){

            public Object open(Assembler a, Resource root2, Mode irrelevant) {
                Assert.assertSame((String)"nested call should pass in assembler group:", (Object)group, (Object)a);
                return result;
            }
        };
        group.implementWith(JA.Object, fake);
        TestAssemblerGroup.assertSame((Object)result, (Object)group.open(this.resourceInModel("x rdf:type ja:Object")));
    }

    public void testCopyPreservesMapping() {
        AssemblerGroup initial = AssemblerGroup.create().implementWith(JA.InfModel, new InfModelAssembler());
        AssemblerGroup copy = initial.copy();
        TestAssemblerGroup.assertSame((Object)initial.assemblerFor(JA.InfModel), (Object)copy.assemblerFor(JA.InfModel));
        TestAssemblerGroup.assertNull((Object)copy.assemblerFor(JA.Connection));
    }

    public void testCopyHasOwnMapping() {
        AssemblerGroup initial = AssemblerGroup.create().implementWith(JA.InfModel, new InfModelAssembler());
        AssemblerGroup copy = initial.copy();
        copy.implementWith(JA.Connection, new ConnectionAssembler());
        TestAssemblerGroup.assertNull((Object)initial.assemblerFor(JA.Connection));
    }

    public static class ImplementsSPOO {
        public static void whenRequiredByAssembler(AssemblerGroup g) {
            g.implementWith(ModelTestBase.resource("SPOO"), mockAssembler);
        }
    }

    static class MockAssembler
    extends AssemblerBase {
        MockAssembler() {
        }

        public Object open(Assembler a, Resource root2, Mode mode) {
            return "mockmockmock";
        }
    }

    public static class Trivial {
        static {
            loaded = true;
        }
    }
}

