/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.test;

import com.hp.hpl.jena.n3.IRIResolver;
import com.hp.hpl.jena.n3.JenaURIException;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestResolver
extends TestCase {
    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestResolver.class);
        ts.setName("TestURI");
        return ts;
    }

    public void testBase1() {
        IRIResolver resolver = new IRIResolver();
        TestResolver.assertNotNull((Object)resolver.getBaseIRI());
        String base = resolver.getBaseIRI();
        TestResolver.assertTrue((base.indexOf(58) > 0 ? (byte)1 : 0) != 0);
    }

    public void testBase2() {
        IRIResolver resolver = new IRIResolver("x");
        TestResolver.assertNotNull((Object)resolver.getBaseIRI());
    }

    public void testBase3() {
        String b = IRIResolver.resolveGlobal("x");
        IRIResolver resolver = new IRIResolver(b);
        TestResolver.assertNotNull((Object)resolver.getBaseIRI());
        String base = resolver.getBaseIRI();
        TestResolver.assertTrue((base.indexOf(58) > 0 ? (byte)1 : 0) != 0);
    }

    public void testBadBase1() {
        this.execException("%G", JenaURIException.class);
    }

    public void testBadBase2() {
        this.execException("/%G", JenaURIException.class);
    }

    public void testBadBase3() {
        this.execException("file:/%/", JenaURIException.class);
    }

    public void testBadBase4() {
        this.execException("http://example.org/%", JenaURIException.class);
    }

    public void testBadChoice1() {
        this.chooseException("%G", JenaURIException.class);
    }

    public void testBadChoice2() {
        this.chooseException("/%G", JenaURIException.class);
    }

    public void testBadChoice3() {
        this.chooseException("file:/%/", JenaURIException.class);
    }

    public void testChoice1() {
        this.choose("file:a");
    }

    public void testChoice2() {
        this.choose("file:a");
    }

    public void testURI_1() {
        this.execTest("", "http://example.org/", "http://example.org/");
    }

    public void testURI_2() {
        this.execTest("", "http://example.org/xyz_2007", "http://example.org/xyz_2007");
    }

    public void testURI_3() {
        this.execTest("", "http://example.org/xyz 2007", "http://example.org/xyz 2007");
    }

    public void testURI_4() {
        this.execTest("", "http://example.org/xyz__2007", "http://example.org/xyz__2007");
    }

    public void testURI_5() {
        this.execTest("", "http://example.org/xyz__abc", "http://example.org/xyz__abc");
    }

    public void testURI_relX_1() {
        this.execTest("x", "http://example.org/ns", "http://example.org/x");
    }

    public void testURI_relX_2() {
        this.execTest("x", "http://example.org/", "http://example.org/x");
    }

    public void testURI2_relHashX_1() {
        this.execTest("#x", "http://example.org/ns", "http://example.org/ns#x");
    }

    public void testURI2_relHashX_2() {
        this.execTest("#x", "http://example.org/ns/", "http://example.org/ns/#x");
    }

    public void testURI_blank_1() {
        this.execTest("", "http://example.org/ns", "http://example.org/ns");
    }

    public void testURI_blank_2() {
        this.execTest("", "http://example.org/ns/", "http://example.org/ns/");
    }

    public void testURI_hash_1() {
        this.execTest("#", "http://example.org/ns", "http://example.org/ns#");
    }

    public void testURI_hash_2() {
        this.execTest("#", "http://example.org/ns/", "http://example.org/ns/#");
    }

    public void testBaseHash_1() {
        this.execTest("x", "http://example.org/ns#", "http://example.org/x");
    }

    public void testBaseHash_2() {
        this.execTest("x", "http://example.org#", "http://example.org/x");
    }

    public void testBaseHash_3() {
        this.execTest("#", "base:x", "base:x#");
    }

    public void testScheme_1() {
        this.execTest("x", "base:", "base:x");
    }

    public void testScheme_2() {
        this.execTest("/x", "base:", "base:/x");
    }

    public void testScheme_3() {
        this.execTestMatch("x", "file:", "^file:///.*/x$");
    }

    public void testScheme_4() {
        this.execTestMatch("file:x", null, "^file:///.*/x$");
    }

    public void testURI_file_2() {
        this.execTest("x", "file:///A/B/C", "file:///A/B/x");
    }

    public void testURI_file_3() {
        this.execTest("x", "file:///A/B/", "file:///A/B/x");
    }

    public void testURI_abs_1() {
        this.execTest("http://host/x", "http://example.org/ns", "http://host/x");
    }

    public void testURI_abs_2() {
        this.execTest("file:///x", "http://example.org/ns", "file:///x");
    }

    public void testURI_abs_3() {
        this.execTest("tag:foo", "http://example.org/ns", "tag:foo");
    }

    public void testURI_abs_4() {
        this.execTest("tag:/foo", "http://example.org/ns", "tag:/foo");
    }

    public void testURI_abs_5() {
        this.execTest("tag:/foo/", "http://example.org/ns", "tag:/foo/");
    }

    public void testURI_abs_6() {
        this.execTest("scheme99:/foo/", "http://example.org/ns", "scheme99:/foo/");
    }

    public void testURI_nullBase_1() {
        this.execTest("scheme99:/foo/", null, "scheme99:/foo/");
    }

    public void testURI_nullBase_2() {
        this.execTestMatch("foo", null, ".*/foo");
    }

    public void testHierURI_1() {
        this.execTest("../foo", "file:///dir/file", "file:///foo");
    }

    public void testHierURI_2() {
        this.execTest("../foo", "http://host/dir/file.html", "http://host/foo");
    }

    public void testHierURI_3() {
        this.execTest("../foo", "http://host/dir/", "http://host/foo");
    }

    public void testHierURI_4() {
        this.execTest("../foo", "http://host/", "http://host/foo");
    }

    public void testHierURI_5() {
        this.execTest("../foo", "http://host/xyz", "http://host/foo");
    }

    public void testHierURI_6() {
        this.execTest(".", "http://host/xyz", "http://host/");
    }

    public void testHierURI_7() {
        this.execTest(".", "http://host/xyz/", "http://host/xyz/");
    }

    public void testHierURI_8() {
        this.execTest(".", "http://host/", "http://host/");
    }

    public void testHierURI_9() {
        this.execTest(".", "file:///dir/file", "file:///dir/");
    }

    public void testFileURI_1() {
        this.execFileTest("file:///foo", "file:///foo");
    }

    public void testFileURI_2() {
        this.execFileTest("file://foo", "file://foo");
    }

    public void testFileURI_3() {
        this.execFileTest("file:/foo", "file:///foo");
    }

    public void testBad_1() {
        this.execException("%G", "http://example.org/", JenaURIException.class);
    }

    public void testBad_2() {
        this.execException("foo", "http://example.org/%HH", JenaURIException.class);
    }

    public void testBad_3() {
        this.execException("bar", "http://example.org/%3", JenaURIException.class);
    }

    public void testBaseEmpty() {
        this.execTestMatch("x", "", "^file:///.*/x$");
    }

    public void testBaseNull() {
        this.execTestMatch("x", null, ".*/x");
    }

    public void testRelBase_1() {
        this.execTestMatch("x", "ns", ".*/x");
    }

    public void testRelBase_2() {
        this.execTestMatch("x", "/ns", ".*/x");
    }

    public void testURI_opaque_1() {
        this.execTest("#x", "tag:A", "tag:A#x");
    }

    public void testURI_opaque_2() {
        this.execTest("#x", "urn:x-jena:A", "urn:x-jena:A#x");
    }

    public void testURI_file_4() {
        this.execTestMatch("x", "file:A", "^file:///.*/x");
    }

    public void testURI_file_5() {
        this.execTestMatch("#x", "file:A", "^file:///.*/A#x");
    }

    public void testURI_file_7() {
        this.execTestMatch("file:foo", "file:xyz", "^file:///.*foo$");
    }

    public void testURI_file_8() {
        this.execTestMatch("file:foo", "file:a b", "^file:///.*foo$");
    }

    public void testFileURI_rel_1() {
        this.execTestFileRelURI("file:foo");
    }

    public void testFileURI_rel_2() {
        this.execTestFileRelURI("file:foo/bar");
    }

    public void testFileURI_rel_3() {
        this.execTestFileRelURI("file:foo/");
    }

    public void testFileURI_rel_4() {
        this.execTestFileRelURI("file:foo/bar/");
    }

    private void execTest(String u, String base, String result) {
        IRIResolver resolver = new IRIResolver(base);
        String res = resolver.resolve(u);
        if (result == null) {
            TestResolver.assertNull((String)("(" + u + "," + base + ") => <null> :: Got: " + res), (Object)res);
            return;
        }
        TestResolver.assertNotNull((String)("(" + u + "," + base + ") => " + result + " :: Got: <null>"), (Object)res);
        TestResolver.assertTrue((String)("(" + u + "," + base + ") => " + result + " :: Got: " + res), (boolean)res.equals(result));
    }

    private void execTestMatch(String u, String base, String resultPattern) {
        IRIResolver resolver = new IRIResolver(base);
        String res = resolver.resolve(u);
        if (resultPattern == null) {
            TestResolver.assertNull((String)("(" + u + "," + base + ") => <null> :: Got: " + res), (Object)res);
            return;
        }
        boolean r = res.matches(resultPattern);
        TestResolver.assertTrue((String)("Does not match: " + res + " -- " + resultPattern), (boolean)r);
    }

    private void execFileTest(String fn1, String fn2) {
        String s = IRIResolver.resolveFileURL(fn1);
        TestResolver.assertEquals((String)s, (String)fn2);
    }

    private void execTestFileRelURI(String fn) {
        String relName = fn.substring("file:".length());
        String s = IRIResolver.resolveFileURL(fn);
        TestResolver.assertTrue((String)("Lost relative name: (" + fn + "=>" + s + ")"), (boolean)s.endsWith(relName));
        TestResolver.assertTrue((String)("Not absolute: (" + fn + "=>" + s + ")"), (boolean)s.startsWith("file:///"));
    }

    private void execException(String u, String base, Class ex) {
        String s = ex.getName();
        int i = s.lastIndexOf(46);
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        try {
            IRIResolver resolver = new IRIResolver(base);
            String res = resolver.resolve(u);
            if (res == null) {
                TestResolver.fail((String)("(" + u + "," + base + ") => <null> :: Expected exception: " + s));
            } else {
                TestResolver.fail((String)("(" + u + "," + base + ") => " + res + " :: Expected exception: " + s));
            }
        }
        catch (Exception ex2) {
            TestResolver.assertEquals((Object)ex, ex2.getClass());
        }
    }

    private void execException(String base, Class ex) {
        String s = ex.getName();
        int i = s.lastIndexOf(46);
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        try {
            new IRIResolver(base);
            TestResolver.fail((String)("(" + base + ") => OK :: Expected exception: " + s));
        }
        catch (Exception ex2) {
            TestResolver.assertEquals((Object)ex, ex2.getClass());
        }
    }

    private void choose(String base) {
        IRIResolver.chooseBaseURI(base);
    }

    private void chooseException(String base, Class ex) {
        String s = ex.getName();
        int i = s.lastIndexOf(46);
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        try {
            IRIResolver.chooseBaseURI(base);
            TestResolver.fail((String)("(" + base + ") => OK :: Expected exception: " + s));
        }
        catch (Exception ex2) {
            TestResolver.assertEquals((Object)ex, ex2.getClass());
        }
    }
}

