/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.PropertyFunctionGenerator;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.TransformSimplify;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroupAgg;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementOptional;
import com.hp.hpl.jena.sparql.syntax.ElementService;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class AlgebraGenerator {
    boolean fixedFilterPosition = false;
    private Context context;
    boolean simplifyEarly = false;
    static Transform simplify = new TransformSimplify();
    public static boolean AlgebraStaging = true;

    public AlgebraGenerator(Context context) {
        if (context == null) {
            context = ARQ.getContext().copy();
        }
        this.context = context;
    }

    public AlgebraGenerator() {
        this(null);
    }

    public Op compile(Query query2) {
        Op pattern = this.compile(query2.getQueryPattern());
        Op op = this.compileModifiers(query2, pattern);
        return op;
    }

    public Op compile(Element elt) {
        Op op = this.compileElement(elt);
        if (!this.simplifyEarly && simplify != null) {
            op = Transformer.transform(simplify, op);
        }
        return op;
    }

    protected Op compileElement(Element elt) {
        if (elt instanceof ElementUnion) {
            return this.compileElementUnion((ElementUnion)elt);
        }
        if (elt instanceof ElementGroup) {
            return this.compileElementGroup((ElementGroup)elt);
        }
        if (elt instanceof ElementNamedGraph) {
            return this.compileElementGraph((ElementNamedGraph)elt);
        }
        if (elt instanceof ElementService) {
            return this.compileElementService((ElementService)elt);
        }
        if (elt instanceof ElementTriplesBlock) {
            return this.compileBasicPattern(((ElementTriplesBlock)elt).getTriples());
        }
        if (elt == null) {
            return new OpNull();
        }
        this.broken("compile(Element)/Not a structural element: " + Utils.className(elt));
        return null;
    }

    protected Op compileElementUnion(ElementUnion el) {
        if (el.getElements().size() == 1) {
            Element subElt = (Element)el.getElements().get(0);
            ElementGroup elg = (ElementGroup)subElt;
            return this.compileElement(elg);
        }
        Op current = null;
        ListIterator iter = el.getElements().listIterator();
        while (iter.hasNext()) {
            Element subElt = (Element)iter.next();
            ElementGroup elg = (ElementGroup)subElt;
            Op op = this.compileElement(elg);
            if (current == null) {
                current = op;
                continue;
            }
            current = new OpUnion(current, op);
        }
        return current;
    }

    protected Op compileElementGroup(ElementGroup groupElt) {
        Op current = OpTable.unit();
        ExprList exprList = new ExprList();
        ListIterator iter = groupElt.getElements().listIterator();
        while (iter.hasNext()) {
            Element elt = (Element)iter.next();
            current = this.compileOneInGroup(elt, current, exprList);
        }
        if (!exprList.isEmpty()) {
            current = OpFilter.filter(exprList, current);
        }
        return current;
    }

    private Op compileOneInGroup(Element elt, Op current, ExprList exprList) {
        if (elt instanceof ElementTriplesBlock) {
            ElementTriplesBlock etb = (ElementTriplesBlock)elt;
            Op op = this.compileBasicPattern(etb.getTriples());
            return this.join(current, op);
        }
        if (elt instanceof ElementFilter) {
            ElementFilter f = (ElementFilter)elt;
            if (this.fixedFilterPosition) {
                return OpFilter.filter(f.getExpr(), current);
            }
            exprList.add(f.getExpr());
            return current;
        }
        if (elt instanceof ElementOptional) {
            ElementOptional eltOpt = (ElementOptional)elt;
            return this.compileElementOptional(eltOpt, current);
        }
        if (elt instanceof ElementGroup || elt instanceof ElementNamedGraph || elt instanceof ElementService || elt instanceof ElementUnion) {
            Op op = this.compileElement(elt);
            return this.join(current, op);
        }
        this.broken("compileDirect/Element not recognized: " + Utils.className(elt));
        return null;
    }

    protected Op compileElementOptional(ElementOptional eltOpt, Op current) {
        Element subElt = eltOpt.getOptionalElement();
        Op op = this.compileElement(subElt);
        ExprList exprs = null;
        if (op instanceof OpFilter) {
            OpFilter f = (OpFilter)op;
            Op sub = f.getSubOp();
            if (sub instanceof OpFilter) {
                this.broken("compile/Optional/nested filters - unfinished");
            }
            exprs = f.getExprs();
            op = sub;
        }
        current = OpLeftJoin.create(current, op, exprs);
        return current;
    }

    protected Op compileBasicPattern(BasicPattern pattern) {
        if (AlgebraStaging) {
            Op op = PropertyFunctionGenerator.compile(pattern, this.context);
            return op;
        }
        return new OpBGP(pattern);
    }

    protected Op compileElementGraph(ElementNamedGraph eltGraph) {
        Node graphNode = eltGraph.getGraphNameNode();
        Op sub = this.compileElement(eltGraph.getElement());
        return new OpGraph(graphNode, sub);
    }

    protected Op compileElementService(ElementService eltService) {
        Node serviceNode = eltService.getServiceNode();
        Op sub = this.compileElement(eltService.getElement());
        return new OpService(serviceNode, sub);
    }

    public Op compileModifiers(Query query2, Op pattern) {
        VarExprList projectVars;
        Op op = pattern;
        if (this.context.isTrue(ARQ.generateToList)) {
            op = new OpList(op);
        }
        if (query2.hasGroupBy()) {
            op = new OpGroupAgg(op, query2.getGroupBy(), query2.getAggregators());
        } else if (query2.getAggregators().size() > 0) {
            op = new OpGroupAgg(op, query2.getGroupBy(), query2.getAggregators());
        }
        if (query2.hasHaving()) {
            Iterator iter = query2.getHavingExprs().iterator();
            while (iter.hasNext()) {
                Expr expr = (Expr)iter.next();
                op = OpFilter.filter(expr, op);
            }
        }
        if (query2.getOrderBy() != null) {
            op = new OpOrder(op, query2.getOrderBy());
        }
        if (!(projectVars = query2.getProject()).isEmpty() && !query2.isQueryResultStar()) {
            if (projectVars.size() == 0 && query2.isSelectType()) {
                ALog.warn(this, "No project variables");
            }
            VarExprList exprs = new VarExprList();
            ArrayList<Var> vars = new ArrayList<Var>();
            Iterator iter = query2.getProject().getVars().iterator();
            while (iter.hasNext()) {
                Var v = (Var)iter.next();
                Expr e2 = query2.getProject().getExpr(v);
                if (e2 != null) {
                    exprs.add(v, e2);
                }
                vars.add(v);
            }
            if (!exprs.isEmpty()) {
                op = new OpAssign(op, exprs);
            }
            if (vars.size() > 0) {
                op = new OpProject(op, vars);
            }
        }
        if (query2.isDistinct()) {
            op = new OpDistinct(op);
        }
        if (query2.isReduced()) {
            op = new OpReduced(op);
        }
        if (query2.hasLimit() || query2.hasOffset()) {
            op = new OpSlice(op, query2.getOffset(), query2.getLimit());
        }
        return op;
    }

    protected Op join(Op current, Op newOp) {
        if (this.simplifyEarly) {
            if (OpJoin.isJoinIdentify(current)) {
                return newOp;
            }
            if (OpJoin.isJoinIdentify(newOp)) {
                return current;
            }
        }
        return OpJoin.create(current, newOp);
    }

    private void broken(String msg) {
        System.err.println("AlgebraCompiler: " + msg);
        throw new ARQInternalErrorException(msg);
    }
}

