/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ResourceUtils {
    public static List maximalLowerElements(Collection resources, Property rel, boolean inverse) {
        return ResourceUtils.maximalLowerElements(resources.iterator(), rel, inverse);
    }

    public static List maximalLowerElements(Iterator resources, Property rel, boolean inverse) {
        ArrayList in = new ArrayList();
        ArrayList out = new ArrayList();
        ArrayList<Resource> drop = new ArrayList<Resource>();
        while (resources.hasNext()) {
            in.add(resources.next());
        }
        while (!in.isEmpty()) {
            Resource r = (Resource)in.remove(0);
            boolean rCovered = ResourceUtils.testResourceCovered(in, rel, inverse, r) || ResourceUtils.testResourceCovered(out, rel, inverse, r) || ResourceUtils.testResourceCovered(drop, rel, inverse, r);
            (rCovered ? drop : out).add(r);
        }
        return out;
    }

    private static boolean testResourceCovered(List l, Property rel, boolean inverse, Resource r) {
        boolean rCovered = false;
        Iterator i = l.iterator();
        while (!rCovered && i.hasNext()) {
            Resource next = (Resource)i.next();
            rCovered = inverse ? r.hasProperty(rel, next) : next.hasProperty(rel, r);
        }
        return rCovered;
    }

    public static List removeEquiv(List l, Property p, Resource ref) {
        ArrayList<Resource> equiv = new ArrayList<Resource>();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Resource r = (Resource)i.next();
            if (!r.hasProperty(p, ref) || !ref.hasProperty(p, r)) continue;
            equiv.add(r);
        }
        l.removeAll(equiv);
        return equiv;
    }

    public static List partition(List l, Property p) {
        ArrayList source = new ArrayList();
        source.addAll(l);
        ArrayList<List> parts = new ArrayList<List>();
        while (!source.isEmpty()) {
            Resource seed = (Resource)source.remove(0);
            List part = ResourceUtils.removeEquiv(source, p, seed);
            part.add(seed);
            parts.add(part);
        }
        return parts;
    }

    public static Resource renameResource(Resource old, String uri) {
        Model m = old.getModel();
        ArrayList stmts = new ArrayList();
        StmtIterator i = old.listProperties();
        while (i.hasNext()) {
            stmts.add(i.next());
        }
        i = m.listStatements(null, null, old);
        while (i.hasNext()) {
            stmts.add(i.next());
        }
        Resource res = uri == null ? m.createResource() : m.createResource(uri);
        Iterator i2 = stmts.iterator();
        while (i2.hasNext()) {
            Statement s = (Statement)i2.next();
            s.remove();
            Resource subj = ((Object)s.getSubject()).equals(old) ? res : s.getSubject();
            RDFNode obj = s.getObject().equals(old) ? res : s.getObject();
            m.add(subj, s.getPredicate(), obj);
        }
        return res;
    }

    public static Model reachableClosure(Resource root2) {
        Model m = ModelFactory.createDefaultModel();
        Set seen = CollectionFactory.createHashedSet();
        LinkedList<RDFNode> queue = new LinkedList<RDFNode>();
        queue.add(root2);
        while (!queue.isEmpty()) {
            Resource r = (Resource)queue.remove(0);
            if (seen.contains(r)) continue;
            seen.add(r);
            StmtIterator i = r.listProperties();
            while (i.hasNext()) {
                Statement s = i.nextStatement();
                m.add(s);
                if (!(s.getObject() instanceof Resource)) continue;
                queue.add(s.getObject());
            }
        }
        return m;
    }
}

