/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsWriter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Payload;
import org.apache.lucene.index.Posting;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosWriter;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.index.TermVectorsWriter;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;

final class DocumentWriter {
    private Analyzer analyzer;
    private Directory directory;
    private Similarity similarity;
    private FieldInfos fieldInfos;
    private int maxFieldLength;
    private int termIndexInterval = 128;
    private PrintStream infoStream;
    private final Hashtable postingTable = new Hashtable();
    private int[] fieldLengths;
    private int[] fieldPositions;
    private int[] fieldOffsets;
    private float[] fieldBoosts;
    private BitSet fieldStoresPayloads;
    private List openTokenStreams = new LinkedList();
    private final Term termBuffer = new Term("", "");

    DocumentWriter(Directory directory, Analyzer analyzer, Similarity similarity, int maxFieldLength) {
        this.directory = directory;
        this.analyzer = analyzer;
        this.similarity = similarity;
        this.maxFieldLength = maxFieldLength;
    }

    DocumentWriter(Directory directory, Analyzer analyzer, IndexWriter writer) {
        this.directory = directory;
        this.analyzer = analyzer;
        this.similarity = writer.getSimilarity();
        this.maxFieldLength = writer.getMaxFieldLength();
        this.termIndexInterval = writer.getTermIndexInterval();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addDocument(String segment, Document doc) throws CorruptIndexException, IOException {
        this.fieldInfos = new FieldInfos();
        this.fieldInfos.add(doc);
        this.postingTable.clear();
        this.fieldLengths = new int[this.fieldInfos.size()];
        this.fieldPositions = new int[this.fieldInfos.size()];
        this.fieldOffsets = new int[this.fieldInfos.size()];
        this.fieldStoresPayloads = new BitSet(this.fieldInfos.size());
        this.fieldBoosts = new float[this.fieldInfos.size()];
        Arrays.fill(this.fieldBoosts, doc.getBoost());
        try {
            this.invertDocument(doc);
            Posting[] postings = this.sortPostingTable();
            this.fieldInfos.write(this.directory, segment + ".fnm");
            FieldsWriter fieldsWriter = new FieldsWriter(this.directory, segment, this.fieldInfos);
            try {
                fieldsWriter.addDocument(doc);
            }
            finally {
                fieldsWriter.close();
            }
            this.writePostings(postings, segment);
            this.writeNorms(segment);
        }
        finally {
            IOException ex = null;
            Iterator it = this.openTokenStreams.iterator();
            while (it.hasNext()) {
                try {
                    ((TokenStream)it.next()).close();
                }
                catch (IOException e2) {
                    if (ex == null) continue;
                    ex = e2;
                }
            }
            this.openTokenStreams.clear();
            if (ex != null) {
                throw ex;
            }
        }
    }

    private final void invertDocument(Document doc) throws IOException {
        Iterator fieldIterator = doc.getFields().iterator();
        while (fieldIterator.hasNext()) {
            Fieldable field = (Fieldable)fieldIterator.next();
            String fieldName = field.name();
            int fieldNumber = this.fieldInfos.fieldNumber(fieldName);
            int length = this.fieldLengths[fieldNumber];
            int position = this.fieldPositions[fieldNumber];
            if (length > 0) {
                position += this.analyzer.getPositionIncrementGap(fieldName);
            }
            int offset = this.fieldOffsets[fieldNumber];
            if (!field.isIndexed()) continue;
            if (!field.isTokenized()) {
                String stringValue = field.stringValue();
                if (field.isStoreOffsetWithTermVector()) {
                    this.addPosition(fieldName, stringValue, position++, null, new TermVectorOffsetInfo(offset, offset + stringValue.length()));
                } else {
                    this.addPosition(fieldName, stringValue, position++, null, null);
                }
                offset += stringValue.length();
            } else {
                TokenStream stream = field.tokenStreamValue();
                if (stream == null) {
                    Reader reader;
                    if (field.readerValue() != null) {
                        reader = field.readerValue();
                    } else if (field.stringValue() != null) {
                        reader = new StringReader(field.stringValue());
                    } else {
                        throw new IllegalArgumentException("field must have either String or Reader value");
                    }
                    stream = this.analyzer.tokenStream(fieldName, reader);
                }
                this.openTokenStreams.add(stream);
                stream.reset();
                Token lastToken = null;
                Token t = stream.next();
                while (t != null) {
                    position += t.getPositionIncrement() - 1;
                    Payload payload = t.getPayload();
                    if (payload != null) {
                        this.fieldStoresPayloads.set(fieldNumber);
                    }
                    TermVectorOffsetInfo termVectorOffsetInfo = field.isStoreOffsetWithTermVector() ? new TermVectorOffsetInfo(offset + t.startOffset(), offset + t.endOffset()) : null;
                    this.addPosition(fieldName, t.termText(), position++, payload, termVectorOffsetInfo);
                    lastToken = t;
                    if (++length >= this.maxFieldLength) {
                        if (this.infoStream == null) break;
                        this.infoStream.println("maxFieldLength " + this.maxFieldLength + " reached, ignoring following tokens");
                        break;
                    }
                    t = stream.next();
                }
                if (lastToken != null) {
                    offset += lastToken.endOffset() + 1;
                }
            }
            this.fieldLengths[fieldNumber] = ++length;
            this.fieldPositions[fieldNumber] = position;
            int n = fieldNumber;
            this.fieldBoosts[n] = this.fieldBoosts[n] * field.getBoost();
            this.fieldOffsets[fieldNumber] = offset;
        }
        int i = this.fieldStoresPayloads.nextSetBit(0);
        while (i >= 0) {
            this.fieldInfos.fieldInfo((int)i).storePayloads = true;
            i = this.fieldStoresPayloads.nextSetBit(i + 1);
        }
    }

    private final void addPosition(String field, String text, int position, Payload payload, TermVectorOffsetInfo offset) {
        this.termBuffer.set(field, text);
        Posting ti = (Posting)this.postingTable.get(this.termBuffer);
        if (ti != null) {
            int freq = ti.freq;
            if (ti.positions.length == freq) {
                int[] newPositions = new int[freq * 2];
                int[] positions = ti.positions;
                System.arraycopy(positions, 0, newPositions, 0, freq);
                ti.positions = newPositions;
                if (ti.payloads != null) {
                    Payload[] newPayloads = new Payload[freq * 2];
                    Payload[] payloads = ti.payloads;
                    System.arraycopy(payloads, 0, newPayloads, 0, payloads.length);
                    ti.payloads = newPayloads;
                }
            }
            ti.positions[freq] = position;
            if (payload != null) {
                if (ti.payloads == null) {
                    ti.payloads = new Payload[ti.positions.length];
                }
                ti.payloads[freq] = payload;
            }
            if (offset != null) {
                if (ti.offsets.length == freq) {
                    TermVectorOffsetInfo[] newOffsets = new TermVectorOffsetInfo[freq * 2];
                    TermVectorOffsetInfo[] offsets = ti.offsets;
                    System.arraycopy(offsets, 0, newOffsets, 0, freq);
                    ti.offsets = newOffsets;
                }
                ti.offsets[freq] = offset;
            }
            ti.freq = freq + 1;
        } else {
            Term term = new Term(field, text, false);
            this.postingTable.put(term, new Posting(term, position, payload, offset));
        }
    }

    private final Posting[] sortPostingTable() {
        Posting[] array = new Posting[this.postingTable.size()];
        Enumeration postings = this.postingTable.elements();
        int i = 0;
        while (postings.hasMoreElements()) {
            array[i] = (Posting)postings.nextElement();
            ++i;
        }
        DocumentWriter.quickSort(array, 0, array.length - 1);
        return array;
    }

    private static final void quickSort(Posting[] postings, int lo, int hi) {
        int right;
        int left;
        Posting tmp;
        if (lo >= hi) {
            return;
        }
        int mid = (lo + hi) / 2;
        if (postings[lo].term.compareTo(postings[mid].term) > 0) {
            tmp = postings[lo];
            postings[lo] = postings[mid];
            postings[mid] = tmp;
        }
        if (postings[mid].term.compareTo(postings[hi].term) > 0) {
            tmp = postings[mid];
            postings[mid] = postings[hi];
            postings[hi] = tmp;
            if (postings[lo].term.compareTo(postings[mid].term) > 0) {
                Posting tmp2 = postings[lo];
                postings[lo] = postings[mid];
                postings[mid] = tmp2;
            }
        }
        if ((left = lo + 1) >= (right = hi - 1)) {
            return;
        }
        Term partition = postings[mid].term;
        while (true) {
            if (postings[right].term.compareTo(partition) > 0) {
                --right;
                continue;
            }
            while (left < right && postings[left].term.compareTo(partition) <= 0) {
                ++left;
            }
            if (left >= right) break;
            Posting tmp2 = postings[left];
            postings[left] = postings[right];
            postings[right] = tmp2;
            --right;
        }
        DocumentWriter.quickSort(postings, lo, left);
        DocumentWriter.quickSort(postings, left + 1, hi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writePostings(Posting[] postings, String segment) throws CorruptIndexException, IOException {
        IOException keep2;
        block42: {
            IOException e222;
            TermVectorsWriter termVectorWriter;
            block41: {
                TermInfosWriter tis;
                block40: {
                    IndexOutput prox;
                    block39: {
                        IndexOutput freq = null;
                        prox = null;
                        tis = null;
                        termVectorWriter = null;
                        try {
                            freq = this.directory.createOutput(segment + ".frq");
                            prox = this.directory.createOutput(segment + ".prx");
                            tis = new TermInfosWriter(this.directory, segment, this.fieldInfos, this.termIndexInterval);
                            TermInfo ti = new TermInfo();
                            String currentField = null;
                            boolean currentFieldHasPayloads = false;
                            for (int i = 0; i < postings.length; ++i) {
                                Posting posting = postings[i];
                                String termField = posting.term.field();
                                if (currentField != termField) {
                                    currentField = termField;
                                    FieldInfo fi = this.fieldInfos.fieldInfo(currentField);
                                    currentFieldHasPayloads = fi.storePayloads;
                                    if (fi.storeTermVector) {
                                        if (termVectorWriter == null) {
                                            termVectorWriter = new TermVectorsWriter(this.directory, segment, this.fieldInfos);
                                            termVectorWriter.openDocument();
                                        }
                                        termVectorWriter.openField(currentField);
                                    } else if (termVectorWriter != null) {
                                        termVectorWriter.closeField();
                                    }
                                }
                                ti.set(1, freq.getFilePointer(), prox.getFilePointer(), -1);
                                tis.add(posting.term, ti);
                                int postingFreq = posting.freq;
                                if (postingFreq == 1) {
                                    freq.writeVInt(1);
                                } else {
                                    freq.writeVInt(0);
                                    freq.writeVInt(postingFreq);
                                }
                                int lastPosition = 0;
                                int[] positions = posting.positions;
                                Payload[] payloads = posting.payloads;
                                int lastPayloadLength = -1;
                                for (int j = 0; j < postingFreq; ++j) {
                                    int position = positions[j];
                                    int delta = position - lastPosition;
                                    if (currentFieldHasPayloads) {
                                        int payloadLength = 0;
                                        Payload payload = null;
                                        if (payloads != null && (payload = payloads[j]) != null) {
                                            payloadLength = payload.length;
                                        }
                                        if (payloadLength == lastPayloadLength) {
                                            prox.writeVInt(delta * 2);
                                        } else {
                                            prox.writeVInt(delta * 2 + 1);
                                            prox.writeVInt(payloadLength);
                                            lastPayloadLength = payloadLength;
                                        }
                                        if (payloadLength > 0) {
                                            prox.writeBytes(payload.data, payload.offset, payload.length);
                                        }
                                    } else {
                                        prox.writeVInt(delta);
                                    }
                                    lastPosition = position;
                                }
                                if (termVectorWriter == null || !termVectorWriter.isFieldOpen()) continue;
                                termVectorWriter.addTerm(posting.term.text(), postingFreq, posting.positions, posting.offsets);
                            }
                            if (termVectorWriter != null) {
                                termVectorWriter.closeDocument();
                            }
                            Object var24_24 = null;
                            keep2 = null;
                            if (freq == null) break block39;
                        }
                        catch (Throwable throwable) {
                            IOException keep2;
                            block46: {
                                IOException e222;
                                block45: {
                                    block44: {
                                        block43: {
                                            Object var24_25 = null;
                                            keep2 = null;
                                            if (freq != null) {
                                                try {
                                                    freq.close();
                                                }
                                                catch (IOException e222) {
                                                    if (keep2 != null) break block43;
                                                    keep2 = e222;
                                                }
                                            }
                                        }
                                        if (prox != null) {
                                            try {
                                                prox.close();
                                            }
                                            catch (IOException e222) {
                                                if (keep2 != null) break block44;
                                                keep2 = e222;
                                            }
                                        }
                                    }
                                    if (tis != null) {
                                        try {
                                            tis.close();
                                        }
                                        catch (IOException e222) {
                                            if (keep2 != null) break block45;
                                            keep2 = e222;
                                        }
                                    }
                                }
                                if (termVectorWriter != null) {
                                    try {
                                        termVectorWriter.close();
                                    }
                                    catch (IOException e222) {
                                        if (keep2 != null) break block46;
                                        keep2 = e222;
                                    }
                                }
                            }
                            if (keep2 != null) {
                                throw (IOException)keep2.fillInStackTrace();
                            }
                            throw throwable;
                        }
                        try {
                            freq.close();
                        }
                        catch (IOException e222) {
                            if (keep2 != null) break block39;
                            keep2 = e222;
                        }
                    }
                    if (prox != null) {
                        try {
                            prox.close();
                        }
                        catch (IOException e222) {
                            if (keep2 != null) break block40;
                            keep2 = e222;
                        }
                    }
                }
                if (tis != null) {
                    try {
                        tis.close();
                    }
                    catch (IOException e222) {
                        if (keep2 != null) break block41;
                        keep2 = e222;
                    }
                }
            }
            if (termVectorWriter != null) {
                try {
                    termVectorWriter.close();
                }
                catch (IOException e222) {
                    if (keep2 != null) break block42;
                    keep2 = e222;
                }
            }
        }
        if (keep2 != null) {
            throw (IOException)keep2.fillInStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeNorms(String segment) throws IOException {
        for (int n = 0; n < this.fieldInfos.size(); ++n) {
            FieldInfo fi = this.fieldInfos.fieldInfo(n);
            if (!fi.isIndexed || fi.omitNorms) continue;
            float norm = this.fieldBoosts[n] * this.similarity.lengthNorm(fi.name, this.fieldLengths[n]);
            IndexOutput norms = this.directory.createOutput(segment + ".f" + n);
            try {
                norms.writeByte(Similarity.encodeNorm(norm));
                continue;
            }
            finally {
                norms.close();
            }
        }
    }

    void setInfoStream(PrintStream infoStream) {
        this.infoStream = infoStream;
    }

    int getNumFields() {
        return this.fieldInfos.size();
    }
}

