/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

final class SegmentInfos
extends Vector {
    public static final int FORMAT = -1;
    public static final int FORMAT_LOCKLESS = -2;
    public static final int FORMAT_SINGLE_NORM_FILE = -3;
    private static final int CURRENT_FORMAT = -3;
    public int counter = 0;
    private long version = System.currentTimeMillis();
    private long generation = 0L;
    private long lastGeneration = 0L;
    private static PrintStream infoStream;
    private static int defaultGenFileRetryCount;
    private static int defaultGenFileRetryPauseMsec;
    private static int defaultGenLookaheadCount;

    SegmentInfos() {
    }

    public final SegmentInfo info(int i) {
        return (SegmentInfo)this.elementAt(i);
    }

    public static long getCurrentSegmentGeneration(String[] files) {
        if (files == null) {
            return -1L;
        }
        long max2 = -1L;
        for (int i = 0; i < files.length; ++i) {
            long gen;
            String file = files[i];
            if (!file.startsWith("segments") || file.equals("segments.gen") || (gen = SegmentInfos.generationFromSegmentsFileName(file)) <= max2) continue;
            max2 = gen;
        }
        return max2;
    }

    public static long getCurrentSegmentGeneration(Directory directory) throws IOException {
        String[] files = directory.list();
        if (files == null) {
            throw new IOException("cannot read directory " + directory + ": list() returned null");
        }
        return SegmentInfos.getCurrentSegmentGeneration(files);
    }

    public static String getCurrentSegmentFileName(String[] files) throws IOException {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getCurrentSegmentGeneration(files));
    }

    public static String getCurrentSegmentFileName(Directory directory) throws IOException {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getCurrentSegmentGeneration(directory));
    }

    public String getCurrentSegmentFileName() {
        return IndexFileNames.fileNameFromGeneration("segments", "", this.lastGeneration);
    }

    public static long generationFromSegmentsFileName(String fileName) {
        if (fileName.equals("segments")) {
            return 0L;
        }
        if (fileName.startsWith("segments")) {
            return Long.parseLong(fileName.substring(1 + "segments".length()), 36);
        }
        throw new IllegalArgumentException("fileName \"" + fileName + "\" is not a segments file");
    }

    public String getNextSegmentFileName() {
        long nextGeneration = this.generation == -1L ? 1L : this.generation + 1L;
        return IndexFileNames.fileNameFromGeneration("segments", "", nextGeneration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void read(Directory directory, String segmentFileName) throws CorruptIndexException, IOException {
        boolean success = false;
        IndexInput input = directory.openInput(segmentFileName);
        this.lastGeneration = this.generation = SegmentInfos.generationFromSegmentsFileName(segmentFileName);
        try {
            int format = input.readInt();
            if (format < 0) {
                if (format < -3) {
                    throw new CorruptIndexException("Unknown format version: " + format);
                }
                this.version = input.readLong();
                this.counter = input.readInt();
            } else {
                this.counter = format;
            }
            for (int i = input.readInt(); i > 0; --i) {
                this.addElement(new SegmentInfo(directory, format, input));
            }
            if (format >= 0) {
                this.version = input.getFilePointer() >= input.length() ? System.currentTimeMillis() : input.readLong();
            }
            success = true;
        }
        finally {
            input.close();
            if (!success) {
                this.clear();
            }
        }
    }

    public final void read(Directory directory) throws CorruptIndexException, IOException {
        this.lastGeneration = -1L;
        this.generation = -1L;
        new FindSegmentsFile(directory){

            protected Object doBody(String segmentFileName) throws CorruptIndexException, IOException {
                SegmentInfos.this.read(this.directory, segmentFileName);
                return null;
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Directory directory) throws IOException {
        String segmentFileName = this.getNextSegmentFileName();
        this.generation = this.generation == -1L ? 1L : ++this.generation;
        IndexOutput output = directory.createOutput(segmentFileName);
        boolean success = false;
        try {
            output.writeInt(-3);
            output.writeLong(++this.version);
            output.writeInt(this.counter);
            output.writeInt(this.size());
            for (int i = 0; i < this.size(); ++i) {
                this.info(i).write(output);
            }
        }
        finally {
            try {
                output.close();
                success = true;
            }
            finally {
                if (!success) {
                    directory.deleteFile(segmentFileName);
                }
            }
        }
        try {
            output = directory.createOutput("segments.gen");
            try {
                output.writeInt(-2);
                output.writeLong(this.generation);
                output.writeLong(this.generation);
            }
            finally {
                output.close();
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        this.lastGeneration = this.generation;
    }

    public Object clone() {
        SegmentInfos sis = (SegmentInfos)super.clone();
        for (int i = 0; i < sis.size(); ++i) {
            sis.setElementAt(((SegmentInfo)sis.elementAt(i)).clone(), i);
        }
        return sis;
    }

    public long getVersion() {
        return this.version;
    }

    public long getGeneration() {
        return this.generation;
    }

    public static long readCurrentVersion(Directory directory) throws CorruptIndexException, IOException {
        return (Long)new FindSegmentsFile(directory){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doBody(String segmentFileName) throws CorruptIndexException, IOException {
                IndexInput input = this.directory.openInput(segmentFileName);
                int format = 0;
                long version2 = 0L;
                try {
                    format = input.readInt();
                    if (format < 0) {
                        if (format < -3) {
                            throw new CorruptIndexException("Unknown format version: " + format);
                        }
                        version2 = input.readLong();
                    }
                }
                finally {
                    input.close();
                }
                if (format < 0) {
                    return new Long(version2);
                }
                SegmentInfos sis = new SegmentInfos();
                sis.read(this.directory, segmentFileName);
                return new Long(sis.getVersion());
            }
        }.run();
    }

    public static void setInfoStream(PrintStream infoStream) {
        SegmentInfos.infoStream = infoStream;
    }

    public static void setDefaultGenFileRetryCount(int count) {
        defaultGenFileRetryCount = count;
    }

    public static int getDefaultGenFileRetryCount() {
        return defaultGenFileRetryCount;
    }

    public static void setDefaultGenFileRetryPauseMsec(int msec) {
        defaultGenFileRetryPauseMsec = msec;
    }

    public static int getDefaultGenFileRetryPauseMsec() {
        return defaultGenFileRetryPauseMsec;
    }

    public static void setDefaultGenLookaheadCount(int count) {
        defaultGenLookaheadCount = count;
    }

    public static int getDefaultGenLookahedCount() {
        return defaultGenLookaheadCount;
    }

    public static PrintStream getInfoStream() {
        return infoStream;
    }

    private static void message(String message) {
        if (infoStream != null) {
            infoStream.println(Thread.currentThread().getName() + ": " + message);
        }
    }

    static {
        defaultGenFileRetryCount = 10;
        defaultGenFileRetryPauseMsec = 50;
        defaultGenLookaheadCount = 10;
    }

    public static abstract class FindSegmentsFile {
        File fileDirectory;
        Directory directory;

        public FindSegmentsFile(File directory) {
            this.fileDirectory = directory;
        }

        public FindSegmentsFile(Directory directory) {
            this.directory = directory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() throws CorruptIndexException, IOException {
            String segmentFileName = null;
            long lastGen = -1L;
            long gen = 0L;
            int genLookaheadCount = 0;
            IOException exc = null;
            boolean retry = false;
            int method = 0;
            while (true) {
                String[] files = null;
                if (0 == method) {
                    if (this.directory != null) {
                        files = this.directory.list();
                        if (files == null) {
                            throw new FileNotFoundException("cannot read directory " + this.directory + ": list() returned null");
                        }
                    } else {
                        files = this.fileDirectory.list();
                        if (files == null) {
                            throw new FileNotFoundException("cannot read directory " + this.fileDirectory + ": list() returned null");
                        }
                    }
                    if ((gen = SegmentInfos.getCurrentSegmentGeneration(files)) == -1L) {
                        String s = "";
                        for (int i = 0; i < files.length; ++i) {
                            s = s + " " + files[i];
                        }
                        throw new FileNotFoundException("no segments* file found in " + this.directory + ": files:" + s);
                    }
                }
                if (1 == method || 0 == method && lastGen == gen && retry) {
                    method = 1;
                    for (int i = 0; i < defaultGenFileRetryCount; ++i) {
                        IndexInput genInput = null;
                        try {
                            genInput = this.directory.openInput("segments.gen");
                        }
                        catch (IOException e2) {
                            SegmentInfos.message("segments.gen open: IOException " + e2);
                        }
                        if (genInput != null) {
                            try {
                                int version2 = genInput.readInt();
                                if (version2 == -2) {
                                    long gen0 = genInput.readLong();
                                    long gen1 = genInput.readLong();
                                    SegmentInfos.message("fallback check: " + gen0 + "; " + gen1);
                                    if (gen0 == gen1) {
                                        if (gen0 <= gen) break;
                                        SegmentInfos.message("fallback to 'segments.gen' check: now try generation " + gen0 + " > " + gen);
                                        gen = gen0;
                                        break;
                                    }
                                }
                            }
                            catch (IOException err2) {
                            }
                            finally {
                                genInput.close();
                            }
                        }
                        try {
                            Thread.sleep(defaultGenFileRetryPauseMsec);
                            continue;
                        }
                        catch (InterruptedException e3) {
                            // empty catch block
                        }
                    }
                }
                if (2 == method || 1 == method && lastGen == gen && retry) {
                    method = 2;
                    if (genLookaheadCount < defaultGenLookaheadCount) {
                        ++genLookaheadCount;
                        SegmentInfos.message("look ahead increment gen to " + ++gen);
                    }
                }
                if (lastGen == gen) {
                    if (retry) {
                        throw exc;
                    }
                    retry = true;
                } else {
                    retry = false;
                }
                lastGen = gen;
                segmentFileName = IndexFileNames.fileNameFromGeneration("segments", "", gen);
                try {
                    Object v = this.doBody(segmentFileName);
                    if (exc != null) {
                        SegmentInfos.message("success on " + segmentFileName);
                    }
                    return v;
                }
                catch (IOException err) {
                    String prevSegmentFileName;
                    if (exc == null) {
                        exc = err;
                    }
                    SegmentInfos.message("primary Exception on '" + segmentFileName + "': " + err + "'; will retry: retry=" + retry + "; gen = " + gen);
                    if (retry || gen <= 1L || !this.directory.fileExists(prevSegmentFileName = IndexFileNames.fileNameFromGeneration("segments", "", gen - 1L))) continue;
                    SegmentInfos.message("fallback to prior segment file '" + prevSegmentFileName + "'");
                    try {
                        Object v = this.doBody(prevSegmentFileName);
                        if (exc != null) {
                            SegmentInfos.message("success on fallback " + prevSegmentFileName);
                        }
                        return v;
                    }
                    catch (IOException err2) {
                        SegmentInfos.message("secondary Exception on '" + prevSegmentFileName + "': " + err2 + "'; will retry");
                        continue;
                    }
                }
                break;
            }
        }

        protected abstract Object doBody(String var1) throws CorruptIndexException, IOException;
    }
}

