/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.util.EnumeratedAttribute;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipEntry;
import org.codehaus.plexus.archiver.zip.ZipFile;
import org.codehaus.plexus.archiver.zip.ZipOutputStream;

public class JarArchiver
extends ZipArchiver {
    private static final String META_INF_NAME = "META-INF";
    private static final String INDEX_NAME = "META-INF/INDEX.LIST";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private Manifest configuredManifest;
    private Manifest savedConfiguredManifest;
    private Manifest filesetManifest;
    private Manifest originalManifest;
    private FilesetManifestConfig filesetManifestConfig;
    private boolean mergeManifestsMain = true;
    private Manifest manifest;
    private String manifestEncoding;
    private File manifestFile;
    private boolean index = false;
    private boolean createEmpty = false;
    private Vector rootEntries;
    private ArrayList indexJars;

    public JarArchiver() {
        this.archiveType = "jar";
        this.setEncoding("UTF8");
        this.rootEntries = new Vector();
    }

    public void setIndex(boolean flag) {
        this.index = flag;
    }

    public void setManifestEncoding(String manifestEncoding) {
        this.manifestEncoding = manifestEncoding;
    }

    public void addConfiguredManifest(Manifest newManifest) throws ManifestException {
        if (this.configuredManifest == null) {
            this.configuredManifest = newManifest;
        } else {
            this.configuredManifest.merge(newManifest);
        }
        this.savedConfiguredManifest = this.configuredManifest;
    }

    public void setManifest(File manifestFile) throws ArchiverException {
        if (!manifestFile.exists()) {
            throw new ArchiverException("Manifest file: " + manifestFile + " does not exist.");
        }
        this.manifestFile = manifestFile;
    }

    private Manifest getManifest(File manifestFile) throws ArchiverException {
        Manifest newManifest = null;
        InputStreamReader isr = null;
        try {
            FileInputStream fis = new FileInputStream(manifestFile);
            isr = this.manifestEncoding == null ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, this.manifestEncoding);
            newManifest = this.getManifest(isr);
        }
        catch (UnsupportedEncodingException e2) {
            throw new ArchiverException("Unsupported encoding while reading manifest: " + e2.getMessage(), e2);
        }
        catch (IOException e3) {
            throw new ArchiverException("Unable to read manifest file: " + manifestFile + " (" + e3.getMessage() + ")", e3);
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e4) {}
            }
        }
        return newManifest;
    }

    private Manifest getManifest(Reader r) throws ArchiverException {
        Manifest newManifest;
        try {
            newManifest = new Manifest(r);
        }
        catch (ManifestException e2) {
            this.getLogger().error("Manifest is invalid: " + e2.getMessage());
            throw new ArchiverException("Invalid Manifest: " + this.manifestFile, e2);
        }
        catch (IOException e3) {
            throw new ArchiverException("Unable to read manifest file (" + e3.getMessage() + ")", e3);
        }
        return newManifest;
    }

    public void setFilesetmanifest(FilesetManifestConfig config) {
        this.filesetManifestConfig = config;
        this.mergeManifestsMain = "merge".equals(config.getValue());
        if (this.filesetManifestConfig != null && !this.filesetManifestConfig.getValue().equals("skip")) {
            this.doubleFilePass = true;
        }
    }

    public void addConfiguredIndexJars(File indexJar) {
        if (this.indexJars == null) {
            this.indexJars = new ArrayList();
        }
        this.indexJars.add(indexJar.getAbsolutePath());
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, ArchiverException {
        if (!this.skipWriting) {
            Manifest jarManifest = this.createManifest();
            this.writeManifest(zOut, jarManifest);
        }
    }

    protected boolean hasVirtualFiles() {
        this.getLogger().debug("\n\n\nChecking for jar manifest virtual files...\n\n\n");
        System.out.flush();
        return this.configuredManifest != null || this.manifest != null || this.manifestFile != null || super.hasVirtualFiles();
    }

    private Manifest createManifest() throws ArchiverException {
        try {
            Manifest finalManifest = Manifest.getDefaultManifest();
            if (this.manifest == null && this.manifestFile != null) {
                this.manifest = this.getManifest(this.manifestFile);
            }
            if (this.isInUpdateMode()) {
                finalManifest.merge(this.originalManifest);
            }
            finalManifest.merge(this.filesetManifest);
            finalManifest.merge(this.configuredManifest);
            finalManifest.merge(this.manifest, !this.mergeManifestsMain);
            return finalManifest;
        }
        catch (ManifestException e2) {
            this.getLogger().error("Manifest is invalid: " + e2.getMessage());
            throw new ArchiverException("Invalid Manifest", e2);
        }
    }

    private void writeManifest(ZipOutputStream zOut, Manifest manifest) throws IOException, ArchiverException {
        Enumeration e2 = manifest.getWarnings();
        while (e2.hasMoreElements()) {
            this.getLogger().warn("Manifest warning: " + e2.nextElement());
        }
        this.zipDir(null, zOut, "META-INF/", 16877);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        PrintWriter writer = new PrintWriter(osw);
        manifest.write(writer);
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        super.zipFile(bais, zOut, MANIFEST_NAME, System.currentTimeMillis(), null, 33188);
        super.initZipOutputStream(zOut);
    }

    protected void finalizeZipOutputStream(ZipOutputStream zOut) throws IOException, ArchiverException {
        if (this.index) {
            this.createIndexList(zOut);
        }
    }

    private void createIndexList(ZipOutputStream zOut) throws IOException, ArchiverException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF8"));
        writer.println("JarIndex-Version: 1.0");
        writer.println();
        writer.println(this.getDestFile().getName());
        HashSet filteredDirs = new HashSet(this.addedDirs.keySet());
        if (filteredDirs.contains("META-INF/")) {
            boolean add = false;
            Iterator i = this.entries.keySet().iterator();
            while (i.hasNext()) {
                String entry = (String)i.next();
                if (!entry.startsWith("META-INF/") || entry.equals(INDEX_NAME) || entry.equals(MANIFEST_NAME)) continue;
                add = true;
                break;
            }
            if (!add) {
                filteredDirs.remove("META-INF/");
            }
        }
        this.writeIndexLikeList(new ArrayList(filteredDirs), this.rootEntries, writer);
        writer.println();
        if (this.indexJars != null) {
            Manifest mf = this.createManifest();
            Manifest.Attribute classpath = mf.getMainSection().getAttribute("Class-Path");
            String[] cpEntries = null;
            if (classpath != null) {
                StringTokenizer tok = new StringTokenizer(classpath.getValue(), " ");
                cpEntries = new String[tok.countTokens()];
                int c = 0;
                while (tok.hasMoreTokens()) {
                    cpEntries[c++] = tok.nextToken();
                }
            }
            Iterator i = this.indexJars.iterator();
            while (i.hasNext()) {
                String indexJar = (String)i.next();
                String name = JarArchiver.findJarName(indexJar, cpEntries);
                if (name == null) continue;
                ArrayList dirs = new ArrayList();
                ArrayList files = new ArrayList();
                JarArchiver.grabFilesAndDirs(indexJar, dirs, files);
                if (dirs.size() + files.size() <= 0) continue;
                writer.println(name);
                this.writeIndexLikeList(dirs, files, writer);
                writer.println();
            }
        }
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        super.zipFile(bais, zOut, INDEX_NAME, System.currentTimeMillis(), null, 33188);
    }

    protected void zipFile(InputStream is, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode) throws IOException, ArchiverException {
        if (MANIFEST_NAME.equalsIgnoreCase(vPath)) {
            if (!this.doubleFilePass || this.skipWriting) {
                this.filesetManifest(fromArchive, is);
            }
        } else if (INDEX_NAME.equalsIgnoreCase(vPath) && this.index) {
            this.getLogger().warn("Warning: selected " + this.archiveType + " files include a META-INF/INDEX.LIST which will" + " be replaced by a newly generated one.");
        } else {
            if (this.index && vPath.indexOf("/") == -1) {
                this.rootEntries.addElement(vPath);
            }
            super.zipFile(is, zOut, vPath, lastModified, fromArchive, mode);
        }
    }

    private void filesetManifest(File file, InputStream is) throws ArchiverException {
        if (this.manifestFile != null && this.manifestFile.equals(file)) {
            this.getLogger().debug("Found manifest " + file);
            try {
                if (is != null) {
                    InputStreamReader isr = this.manifestEncoding == null ? new InputStreamReader(is) : new InputStreamReader(is, this.manifestEncoding);
                    this.manifest = this.getManifest(isr);
                }
                this.manifest = this.getManifest(file);
            }
            catch (UnsupportedEncodingException e2) {
                throw new ArchiverException("Unsupported encoding while reading manifest: " + e2.getMessage(), e2);
            }
        } else if (this.filesetManifestConfig != null && !this.filesetManifestConfig.getValue().equals("skip")) {
            this.getLogger().debug("Found manifest to merge in file " + file);
            try {
                Manifest newManifest;
                if (is != null) {
                    InputStreamReader isr = this.manifestEncoding == null ? new InputStreamReader(is) : new InputStreamReader(is, this.manifestEncoding);
                    newManifest = this.getManifest(isr);
                } else {
                    newManifest = this.getManifest(file);
                }
                if (this.filesetManifest == null) {
                    this.filesetManifest = newManifest;
                } else {
                    this.filesetManifest.merge(newManifest);
                }
            }
            catch (UnsupportedEncodingException e3) {
                throw new ArchiverException("Unsupported encoding while reading manifest: " + e3.getMessage(), e3);
            }
            catch (ManifestException e4) {
                this.getLogger().error("Manifest in file " + file + " is invalid: " + e4.getMessage());
                throw new ArchiverException("Invalid Manifest", e4);
            }
        }
    }

    protected boolean createEmptyZip(File zipFile) throws ArchiverException {
        if (!this.createEmpty) {
            return true;
        }
        ZipOutputStream zOut = null;
        try {
            this.getLogger().debug("Building MANIFEST-only jar: " + this.getDestFile().getAbsolutePath());
            zOut = new ZipOutputStream(new FileOutputStream(this.getDestFile()));
            zOut.setEncoding(this.getEncoding());
            if (this.isCompress()) {
                zOut.setMethod(8);
            } else {
                zOut.setMethod(0);
            }
            this.initZipOutputStream(zOut);
            this.finalizeZipOutputStream(zOut);
        }
        catch (IOException ioe) {
            throw new ArchiverException("Could not create almost empty JAR archive (" + ioe.getMessage() + ")", ioe);
        }
        finally {
            try {
                if (zOut != null) {
                    zOut.close();
                }
            }
            catch (IOException ex) {}
            this.createEmpty = false;
        }
        return true;
    }

    protected void cleanUp() {
        super.cleanUp();
        if (!this.doubleFilePass || !this.skipWriting) {
            this.manifest = null;
            this.configuredManifest = this.savedConfiguredManifest;
            this.filesetManifest = null;
            this.originalManifest = null;
        }
        this.rootEntries.removeAllElements();
    }

    public void reset() {
        super.reset();
        this.configuredManifest = null;
        this.filesetManifestConfig = null;
        this.mergeManifestsMain = false;
        this.manifestFile = null;
        this.index = false;
    }

    protected final void writeIndexLikeList(List dirs, List files, PrintWriter writer) {
        Collections.sort(dirs);
        Collections.sort(files);
        Iterator iter = dirs.iterator();
        while (iter.hasNext()) {
            String dir = (String)iter.next();
            if ((dir = dir.replace('\\', '/')).startsWith("./")) {
                dir = dir.substring(2);
            }
            while (dir.startsWith("/")) {
                dir = dir.substring(1);
            }
            int pos = dir.lastIndexOf(47);
            if (pos != -1) {
                dir = dir.substring(0, pos);
            }
            writer.println(dir);
        }
        iter = files.iterator();
        while (iter.hasNext()) {
            writer.println(iter.next());
        }
    }

    protected static final String findJarName(String fileName, String[] classpath) {
        if (classpath == null) {
            return new File(fileName).getName();
        }
        fileName = fileName.replace(File.separatorChar, '/');
        TreeMap<String, String> matches2 = new TreeMap<String, String>(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    return ((String)o2).length() - ((String)o1).length();
                }
                return 0;
            }
        });
        block0: for (int i = 0; i < classpath.length; ++i) {
            if (fileName.endsWith(classpath[i])) {
                matches2.put(classpath[i], classpath[i]);
                continue;
            }
            int slash = classpath[i].indexOf("/");
            String candidate = classpath[i];
            while (slash > -1) {
                if (fileName.endsWith(candidate = candidate.substring(slash + 1))) {
                    matches2.put(candidate, classpath[i]);
                    continue block0;
                }
                slash = candidate.indexOf("/");
            }
        }
        return matches2.size() == 0 ? null : (String)matches2.get(matches2.firstKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void grabFilesAndDirs(String file, List dirs, List files) throws IOException {
        ZipFile zf = null;
        try {
            zf = new ZipFile(file, "utf-8");
            Enumeration entries = zf.getEntries();
            HashSet<String> dirSet = new HashSet<String>();
            while (entries.hasMoreElements()) {
                ZipEntry ze = (ZipEntry)entries.nextElement();
                String name = ze.getName();
                if (name.equals(META_INF_NAME) || name.equals("META-INF/") || name.equals(INDEX_NAME) || name.equals(MANIFEST_NAME)) continue;
                if (ze.isDirectory()) {
                    dirSet.add(name);
                    continue;
                }
                if (name.indexOf("/") == -1) {
                    files.add(name);
                    continue;
                }
                dirSet.add(name.substring(0, name.lastIndexOf("/") + 1));
            }
            dirs.addAll(dirSet);
        }
        finally {
            if (zf != null) {
                zf.close();
            }
        }
    }

    public static class FilesetManifestConfig
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"skip", "merge", "mergewithoutmain"};
        }
    }
}

