/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.log4j.Logger;
import org.apache.solr.common.util.IOUtils;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.index.task.IndexTask;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.cn.indexer.D1IndexerSolrClient;
import org.dataone.cn.indexer.parser.IDocumentDeleteSubprocessor;
import org.dataone.cn.indexer.parser.IDocumentSubprocessorV2;
import org.dataone.cn.indexer.parser.UpdateAssembler;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrJClient;
import org.dataone.cn.indexer.solrhttp.SolrSchema;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.SAXException;

public class SolrIndexServiceV2 {
    private static Logger log = Logger.getLogger(SolrIndexServiceV2.class);
    private static final String OUTPUT_ENCODING = "UTF-8";
    private List<IDocumentSubprocessorV2> subprocessors = null;
    private List<IDocumentDeleteSubprocessor> deleteSubprocessors = null;
    private IDocumentSubprocessorV2 systemMetadataProcessor = null;
    @Autowired
    private D1IndexerSolrClient d1IndexerSolrClient = null;
    @Autowired
    private String solrIndexUri = null;
    @Autowired
    private String solrQueryUri = null;
    @Autowired
    private SolrSchema solrSchema = null;
    private boolean usePartialUpdate = Settings.getConfiguration().getBoolean("dataone.indexing.usePartialUpdate", false);
    private PerformanceLogger perfLog = PerformanceLogger.getInstance();

    public void removeFromIndex(String identifier) throws Exception {
        HashMap<String, SolrDoc> docs = new HashMap<String, SolrDoc>();
        for (IDocumentDeleteSubprocessor deleteSubprocessor : this.getDeleteSubprocessors()) {
            if (log.isDebugEnabled()) {
                log.debug("... invoking processDocForDelete for identifier " + identifier + "[" + deleteSubprocessor.getClass().getSimpleName() + "/" + deleteSubprocessor.getInstanceLabel() + "]");
            }
            docs.putAll(deleteSubprocessor.processDocForDelete(identifier, docs));
        }
        ArrayList<SolrDoc> docsToUpdate = new ArrayList<SolrDoc>();
        ArrayList<String> idsToIndex = new ArrayList<String>();
        for (String idToUpdate : docs.keySet()) {
            if (docs.get(idToUpdate) != null) {
                docsToUpdate.add((SolrDoc)docs.get(idToUpdate));
                log.debug("...updating doc with id " + idToUpdate);
                continue;
            }
            idsToIndex.add(idToUpdate);
        }
        this.getD1IndexerSolrClient().sendUpdate(this.getSolrindexUri(), docsToUpdate, OUTPUT_ENCODING, this.usePartialUpdate);
        this.deleteDocFromIndex(identifier);
        for (String idToIndex : idsToIndex) {
            Identifier pid = new Identifier();
            pid.setValue(idToIndex);
            SystemMetadata sysMeta = HazelcastClientFactory.getSystemMetadataMap().get(pid);
            if (!SolrDoc.visibleInIndex(sysMeta)) continue;
            String objectPath = HazelcastClientFactory.getObjectPathMap().get(pid);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            TypeMarshaller.marshalTypeToOutputStream(sysMeta, os);
            this.insertIntoIndex(idToIndex, new ByteArrayInputStream(os.toByteArray()), objectPath);
            log.debug("...reindexing doc with id " + idToIndex);
        }
    }

    public void removeFromIndex(List<IndexTask> tasks) throws Exception {
        for (IndexTask indexTask : tasks) {
            String identifier = indexTask.getPid();
            try {
                this.removeFromIndex(identifier);
            }
            catch (Exception e2) {
                log.error("Unable to remove from index: " + identifier, e2);
            }
        }
    }

    public void insertIntoIndex(String id, InputStream systemMetaDataStream, String objectPath) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException, EncoderException {
        log.debug("Entering insertIntoIndex(...)");
        UpdateAssembler updates = this.processInsertTask(id, systemMetaDataStream, objectPath);
        log.debug("update assembled, sending command...");
        long solrAddStart = System.currentTimeMillis();
        this.sendCommand(updates);
        this.perfLog.log("SolrIndexService.sendCommand(UpdateAssembler) adding docs into Solr index for id " + id, System.currentTimeMillis() - solrAddStart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateAssembler processInsertTask(String id, InputStream systemMetaDataStream, String objectPath) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException, EncoderException {
        UpdateAssembler collector;
        long processObjStart;
        block14: {
            block12: {
                processObjStart = System.currentTimeMillis();
                collector = new UpdateAssembler(this.solrSchema);
                try {
                    long sysmetaProcStart = System.currentTimeMillis();
                    Date d = new Date();
                    this.systemMetadataProcessor.processDocument(id, collector, systemMetaDataStream);
                    if (log.isDebugEnabled()) {
                        log.debug("...subprocessor SystemMetadataProcessor invoked for " + id);
                    }
                    this.perfLog.log(this.systemMetadataProcessor.getClass().getSimpleName() + ".processDocument() processing sysmeta for id " + id, System.currentTimeMillis() - sysmetaProcStart);
                }
                catch (Exception e2) {
                    log.error("Error parsing system metadata for id: " + id + e2.getMessage(), e2);
                }
                if (objectPath == null) break block12;
                List<SolrDoc> update2 = collector.assembleUpdate(0);
                String formatId = update2.get(0).getFirstFieldValue("formatId");
                int i = 1;
                for (IDocumentSubprocessorV2 subprocessor : this.getSubprocessors()) {
                    if (subprocessor.canProcess(formatId)) {
                        FileInputStream objectStream;
                        block11: {
                            objectStream = null;
                            try {
                                if (log.isDebugEnabled()) {
                                    log.debug("...subprocessor " + subprocessor.getClass().getSimpleName() + ".processDocument(...) invoked for " + id);
                                }
                                long startFechingFile = System.currentTimeMillis();
                                objectStream = new FileInputStream(objectPath);
                                this.perfLog.log("Loop " + i + ". SolrIndexService.processObject() fetch file for id " + id, System.currentTimeMillis() - startFechingFile);
                                if (!objectStream.getFD().valid()) {
                                    log.error("Could not load OBJECT file for ID,Path=" + id + ", " + objectPath);
                                    break block11;
                                }
                                Date dd = new Date();
                                long scimetaProcStart = System.currentTimeMillis();
                                subprocessor.processDocument(id, collector, objectStream);
                                this.perfLog.log(String.format("Loop %d. SolrIndexService.processObject() %s.processDocument() total subprocessor processing time for id %s with format: %s", i, subprocessor.getClass().getSimpleName(), id, formatId), System.currentTimeMillis() - scimetaProcStart);
                            }
                            catch (Exception e3) {
                                try {
                                    log.warn(String.format("The subprocessor %s can't process the id %s since %s. However, the index still can be achieved without this part of information provided by the processor.", subprocessor.getClass().getName(), id, e3.getMessage()), e3);
                                }
                                catch (Throwable throwable) {
                                    IOUtils.closeQuietly(objectStream);
                                    throw throwable;
                                }
                                IOUtils.closeQuietly(objectStream);
                            }
                        }
                        IOUtils.closeQuietly(objectStream);
                    }
                    ++i;
                }
                break block14;
            }
            log.warn("The optional objectPath for pid " + id + " is null, so skipping processing with content subprocessors");
        }
        this.perfLog.log("SolrIndexService.processObject() total processing time for id " + id, System.currentTimeMillis() - processObjStart);
        return collector;
    }

    private void sendCommand(UpdateAssembler assembler) throws IOException {
        SolrJClient client = (SolrJClient)this.getD1IndexerSolrClient();
        log.info("sendCommand using partial update?: " + this.usePartialUpdate);
        client.sendUpdate(this.getSolrindexUri(), assembler, this.usePartialUpdate);
    }

    private void deleteDocFromIndex(String identifier) {
        this.d1IndexerSolrClient.sendSolrDelete(identifier);
    }

    public String getSolrindexUri() {
        return this.solrIndexUri;
    }

    public void setSolrIndexUri(String solrindexUri) {
        this.solrIndexUri = solrindexUri;
    }

    public void setD1IndexerSolrClient(D1IndexerSolrClient service) {
        this.d1IndexerSolrClient = service;
    }

    public D1IndexerSolrClient getD1IndexerSolrClient() {
        return this.d1IndexerSolrClient;
    }

    public String getSolrQueryUri() {
        return this.solrQueryUri;
    }

    public void setSolrQueryUri(String solrQueryUri) {
        this.solrQueryUri = solrQueryUri;
    }

    public void setSolrSchema(SolrSchema schema) {
        this.solrSchema = schema;
    }

    public List<IDocumentSubprocessorV2> getSubprocessors() {
        if (this.subprocessors == null) {
            this.subprocessors = new ArrayList<IDocumentSubprocessorV2>();
        }
        return this.subprocessors;
    }

    public List<IDocumentDeleteSubprocessor> getDeleteSubprocessors() {
        if (this.deleteSubprocessors == null) {
            this.deleteSubprocessors = new ArrayList<IDocumentDeleteSubprocessor>();
        }
        return this.deleteSubprocessors;
    }

    public void setSubprocessors(List<IDocumentSubprocessorV2> subprocessorList) {
        this.subprocessors = subprocessorList;
    }

    public void setDeleteSubprocessors(List<IDocumentDeleteSubprocessor> deleteSubprocessorList) {
        this.deleteSubprocessors = deleteSubprocessorList;
    }

    public IDocumentSubprocessorV2 getSystemMetadataProcessor() {
        return this.systemMetadataProcessor;
    }

    public void setSystemMetadataProcessor(IDocumentSubprocessorV2 systemMetadataProcessor) {
        this.systemMetadataProcessor = systemMetadataProcessor;
    }

    public void setUsePartialUpdate(boolean value) {
        this.usePartialUpdate = value;
    }

    public boolean getUsePartialUpdate() {
        return this.usePartialUpdate;
    }
}

