/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.solrhttp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.dataone.cn.indexer.D1IndexerSolrClient;
import org.dataone.cn.indexer.parser.UpdateAssembler;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementAdd;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.dataone.cn.indexer.solrhttp.SolrSchema;
import org.dataone.configuration.Settings;
import org.dataone.service.util.DateTimeMarshaller;

public class SolrJClient
implements D1IndexerSolrClient {
    private static final String CHAR_ENCODING = "UTF-8";
    private static final String XML_CONTENT_TYPE = "text/xml";
    static final String PARAM_START = "start";
    static final String PARAM_ROWS = "rows";
    static final String PARAM_INDENT = "indent";
    static final String VALUE_INDENT_ON = "on";
    static final String VALUE_INDENT_OFF = "off";
    static final String PARAM_QUERY = "q";
    private static final String MAX_ROWS = "5000";
    private static final String DYNAMIC_FIELD_SUFFIX = "_sm";
    private static final Pattern VERSION_MISMATCH_PATTERN = Pattern.compile("version conflict for (.+) expected=(\\d+)");
    public int COMMIT_WITHIN_MS = Settings.getConfiguration().getInt("dataone.indexer.solrClient.commit.within.ms", 250);
    public static final boolean USE_REAL_TIME_GETS = true;
    public static final boolean UPDATES_USE_JAVABIN = Settings.getConfiguration().getBoolean("dataone.indexer.solrClient.updates.use.javabin", false);
    private static Logger log = Logger.getLogger(SolrJClient.class.getName());
    private SolrSchema solrSchema;
    private HttpClient httpClient;
    private SolrClient queryClient;
    private SolrClient updateClient;
    private String solrIndexUri;
    private Set<String> multiValuedSolrFieldNames = new HashSet<String>();
    protected static boolean AUDIT_CALL_MODE = false;
    protected List<String> solrCallList = new ArrayList<String>();
    protected List<Date> solrCallStartTimeList = new ArrayList<Date>();
    protected List<Long> solrCallDurationList = new ArrayList<Long>();

    public SolrJClient(SolrSchema schema, SolrClient updateClient, SolrClient queryClient) {
        this.solrSchema = schema;
        this.updateClient = updateClient;
        this.queryClient = queryClient;
    }

    @Override
    public void sendUpdate(String uri, List<SolrDoc> data) throws IOException {
        this.sendUpdate(uri, data, CHAR_ENCODING);
    }

    @Override
    public void sendUpdate(String uri, List<SolrDoc> data, String encoding) throws IOException {
        this.sendUpdate(uri, data, encoding, true);
    }

    @Override
    public void sendUpdate(String uri, List<SolrDoc> data, String encoding, boolean isAtomic) throws IOException {
        this.sendUpdateWithRedo(uri, data, isAtomic);
    }

    public void sendUpdate(String uri, UpdateAssembler assembler, boolean isAtomic) throws IOException {
        List<SolrDoc> remaining = assembler.assembleUpdate(0);
        log.info("... update size = " + remaining.size());
        int attempts = 0;
        while (remaining.size() > 0 && attempts++ <= 50) {
            Integer numberProcessed = this.sendUpdateWithRedo(uri, remaining, isAtomic);
            log.info("... number processed = " + numberProcessed);
            if (numberProcessed == null) {
                log.warn("Exception caught during update, but not sure it's a conflict.  Reprocessing as if it was");
                numberProcessed = 0;
            }
            if (numberProcessed == -1) {
                for (SolrDoc solrDoc : remaining) {
                    String id = solrDoc.getFirstFieldValue("id");
                    log.debug("fetching solr record due to conflict for id: " + id);
                    try {
                        SolrDocument newExisting = this.queryClient.getById(id);
                        if (newExisting != null) {
                            log.trace("...found existing solr document");
                            assembler.addToUpdate(id, this.parseResponse(newExisting), null);
                            continue;
                        }
                        log.trace("...did not find existing solr document");
                    }
                    catch (SolrServerException e2) {
                        IOException ioe = new IOException("unable to fetch the current solr record with ID: " + id);
                        ioe.initCause(e2);
                        throw ioe;
                    }
                }
                remaining = assembler.assembleUpdate(0);
                continue;
            }
            if (numberProcessed >= remaining.size()) break;
            log.warn("Not all updates succeeded. [" + numberProcessed + "/" + remaining.size() + "] attempt:" + attempts);
            String id = remaining.get(numberProcessed).getFirstFieldValue("id");
            log.debug("fetching solr record due to conflict for conflicted id: " + id);
            try {
                SolrDocument solrDocument = this.queryClient.getById(id);
                if (solrDocument != null) {
                    log.trace("...found an existing solr document");
                    assembler.addToUpdate(id, this.parseResponse(solrDocument), null);
                } else {
                    log.trace("...did not find an existing solr document");
                }
                remaining = assembler.assembleUpdate(numberProcessed);
            }
            catch (SolrServerException e3) {
                IOException ioe = new IOException("unable to fetch the current solr record with ID: " + id);
                ioe.initCause(e3);
                throw ioe;
            }
        }
    }

    private SolrInputDocument convertSolrDoc(SolrDoc doc, boolean isAtomic) {
        SolrInputDocument updateDoc = new SolrInputDocument();
        boolean hasAtomicUpdates = false;
        for (SolrElementField sef : doc.getFieldList()) {
            HashMap<String, String> fieldModifier;
            String value;
            String string = value = UPDATES_USE_JAVABIN ? this.solrSchema.convertToSolrType(sef.getName(), sef.getValue()) : sef.getValue();
            if (sef.getModifier() != null) {
                hasAtomicUpdates = true;
                fieldModifier = new HashMap<String, String>(1);
                fieldModifier.put(sef.getModifier().toString(), value);
                updateDoc.addField(sef.getName(), fieldModifier);
                log.trace(String.format("update field '%s' using modifier '%s' with value '%s' [type: %s]", new Object[]{sef.getName(), sef.getModifier(), sef.getValue(), value.getClass().getSimpleName()}));
                continue;
            }
            if (isAtomic && !sef.getName().equals("id") && !sef.getName().equals("_version_")) {
                hasAtomicUpdates = true;
                fieldModifier = new HashMap(1);
                String modifierKeyword = this.multiValuedSolrFieldNames.contains(sef.getName()) ? "add" : "set";
                fieldModifier.put(modifierKeyword, value);
                updateDoc.addField(sef.getName(), fieldModifier);
                log.trace(String.format("update field '%s' using midifier '%s' with value '%s' [type: %s]", sef.getName(), modifierKeyword, sef.getValue(), value.getClass().getSimpleName()));
                continue;
            }
            updateDoc.addField(sef.getName(), value);
            log.trace(String.format("update field '%s' with value '%s' [type: %s]", sef.getName(), sef.getValue(), value.getClass().getSimpleName()));
        }
        if (!isAtomic || hasAtomicUpdates) {
            return updateDoc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendUpdateWithRedo(String uri, List<SolrDoc> data, boolean isAtomic) throws IOException {
        log.debug("is Atomic Update: " + isAtomic);
        ArrayList<SolrInputDocument> updateDocList = new ArrayList<SolrInputDocument>();
        for (SolrDoc doc : data) {
            String id = doc.getFirstFieldValue("id");
            log.debug("SolrDoc to update: " + id);
            SolrInputDocument updateDoc = this.convertSolrDoc(doc, isAtomic);
            if (updateDoc == null) continue;
            log.debug("...successfully converted to SolrInputDocument - added to list: " + id);
            updateDocList.add(updateDoc);
        }
        Integer processed = null;
        if (updateDocList.size() == 0) {
            log.info("submitting no update documents!!");
        } else {
            log.info("submitting update for " + updateDocList.size() + " documents.");
            Date callStart = new Date();
            long callEnd = 0L;
            try {
                log.debug("COMMIT_WITHIN_MS = " + this.COMMIT_WITHIN_MS);
                if (this.COMMIT_WITHIN_MS == -1) {
                    this.updateClient.add(updateDocList);
                    this.updateClient.commit();
                } else {
                    this.updateClient.add(updateDocList, this.COMMIT_WITHIN_MS);
                }
                callEnd = System.currentTimeMillis();
                log.info(".... update submitted");
                processed = updateDocList.size();
            }
            catch (Exception e2) {
                log.warn("not all objects processed...");
                processed = this.determineNumberProcessed(e2, updateDocList, data);
                if (processed == null) {
                    log.error("exception updating solr from SolrClient", e2);
                    IOException ioe = new IOException("Unexpected exception from solr update!", e2);
                    throw ioe;
                }
            }
            finally {
                if (AUDIT_CALL_MODE) {
                    this.solrCallList.add("update:" + updateDocList.size());
                    this.solrCallDurationList.add(callEnd - callStart.getTime());
                    this.solrCallStartTimeList.add(callStart);
                }
            }
        }
        return processed;
    }

    private Integer determineNumberProcessed(Throwable e2, List<SolrInputDocument> updateDocList, List<SolrDoc> data) throws IOException {
        log.debug("exception in update: " + e2.getClass().getCanonicalName() + ": " + e2.getMessage());
        Integer processed = null;
        Matcher m = VERSION_MISMATCH_PATTERN.matcher(e2.getMessage());
        String problemId = null;
        SolrInputDocument head = null;
        int i = 0;
        if (m.find()) {
            problemId = m.group(1);
            boolean found = false;
            while (!found) {
                head = updateDocList.get(i);
                if (problemId.equals(head.getFieldValue("id"))) {
                    found = true;
                    log.debug("Found conflict id: " + head.getFieldValue("id"));
                    continue;
                }
                ++i;
            }
            processed = i;
            log.info("processed " + i + " updates.");
            log.info("remaining " + (updateDocList.size() - i));
        } else if (e2.getMessage().toLowerCase().contains("conflict")) {
            processed = -1;
        }
        return processed;
    }

    @Override
    public void sendSolrDelete(String pid) {
        try {
            log.info("Deleting record in Solr with id: " + pid);
            if (this.COMMIT_WITHIN_MS == -1) {
                this.updateClient.deleteById(pid);
                this.updateClient.commit();
            } else {
                this.updateClient.deleteById(pid, this.COMMIT_WITHIN_MS);
            }
        }
        catch (IOException | SolrServerException e1) {
            this.logError(e1, pid, e1.getMessage(), "zkHost");
            e1.printStackTrace();
        }
    }

    @Override
    public void sendSolrDeletes(List<String> pids) {
        try {
            log.info("Deleting records in Solr with id: " + StringUtils.join(pids, ", "));
            if (this.COMMIT_WITHIN_MS == -1) {
                this.updateClient.deleteById(pids);
                this.updateClient.commit();
            } else {
                this.updateClient.deleteById(pids, this.COMMIT_WITHIN_MS);
            }
        }
        catch (IOException | SolrServerException e1) {
            String pidString = StringUtils.join(pids, ",");
            this.logError(e1, pidString, e1.getMessage(), "zkHost");
            e1.printStackTrace();
        }
    }

    private void logError(Throwable ex, List<SolrDoc> data, String messageResponse, String uri) throws IOException {
        try {
            if (ex != null) {
                log.error("Unable to write to stream", ex);
            }
            SolrElementAdd add = new SolrElementAdd(data);
            log.error("URL: " + uri);
            log.error("Post: ");
            log.error("message response: " + messageResponse);
            log.error("Attempting to serialize the request...");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            add.serialize(baos, CHAR_ENCODING);
            log.error(new String(baos.toByteArray(), CHAR_ENCODING));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void logError(Exception ex, String data, String messageResponse, String uri) {
        try {
            if (ex != null) {
                log.error("Unable to write to stream", ex);
            }
            log.error("URL: " + uri);
            log.error("Post: ");
            log.error(data);
            log.error("\n\n\nResponse: \n");
            log.error(messageResponse);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public List<SolrDoc> getDocumentsByD1Identifier(String uir, List<String> ids) throws IOException {
        List<SolrDoc> docs = this.getDocumentsBySolrId(ids);
        if (docs.size() < ids.size()) {
            docs.addAll(this.getDocumentsByField(uir, ids, "seriesId", false));
        }
        return docs;
    }

    @Override
    public List<SolrDoc> getDocumentBySolrId(String uir, String id) throws IOException {
        try {
            log.info("Id for solrId get: " + id + " from " + uir);
            if (log.isTraceEnabled()) {
                log.trace(Thread.currentThread().getStackTrace()[1].getMethodName());
                log.trace(Thread.currentThread().getStackTrace()[2].getMethodName());
                log.trace(Thread.currentThread().getStackTrace()[3].getClassName() + ":" + Thread.currentThread().getStackTrace()[5].getMethodName());
                log.trace(Thread.currentThread().getStackTrace()[4].getClassName() + ":" + Thread.currentThread().getStackTrace()[6].getMethodName());
            }
            SolrDocument d = this.queryClient.getById(id);
            ArrayList<SolrDoc> docs = new ArrayList<SolrDoc>();
            SolrDoc dd = this.parseResponse(d);
            if (dd != null) {
                docs.add(dd);
            }
            return docs;
        }
        catch (SolrServerException e2) {
            throw new IOException(e2);
        }
    }

    public List<SolrDoc> getDocumentsBySolrId(List<String> ids) throws IOException {
        try {
            log.info("Ids for solrId get: " + StringUtils.join(ids, ", "));
            if (log.isTraceEnabled()) {
                log.trace(Thread.currentThread().getStackTrace()[1].getMethodName());
                log.trace(Thread.currentThread().getStackTrace()[2].getMethodName());
                log.trace(Thread.currentThread().getStackTrace()[3].getClassName() + ":" + Thread.currentThread().getStackTrace()[5].getMethodName());
                log.trace(Thread.currentThread().getStackTrace()[4].getClassName() + ":" + Thread.currentThread().getStackTrace()[6].getMethodName());
            }
            SolrDocumentList d = this.queryClient.getById(ids);
            ArrayList<SolrDoc> docs = new ArrayList<SolrDoc>();
            docs.addAll(this.parseResponse(d));
            return docs;
        }
        catch (SolrServerException e2) {
            throw new IOException(e2);
        }
    }

    @Override
    public List<SolrDoc> getDocumentsByResourceMap(String uir, String resourceMapId) throws IOException {
        return this.getDocumentsByField(uir, Collections.singletonList(resourceMapId), "resourceMap", true);
    }

    @Override
    public List<SolrDoc> getDocumentsByField(String uir, List<String> fieldValues, String queryField, boolean maxRows) throws IOException {
        if (fieldValues == null || fieldValues.size() <= 0) {
            return null;
        }
        ArrayList<SolrDoc> docs = new ArrayList<SolrDoc>();
        int rows = 0;
        String rowString = "";
        StringBuilder sb = new StringBuilder();
        for (String id : fieldValues) {
            if (StringUtils.isEmpty(id)) continue;
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append(queryField + ":").append(ClientUtils.escapeQueryChars(id));
            ++rows;
            if (sb.length() <= 5000) continue;
            rowString = maxRows ? MAX_ROWS : Integer.toString(rows);
            docs.addAll(this.doRequest(uir, sb, rowString));
            rows = 0;
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            rowString = maxRows ? MAX_ROWS : Integer.toString(rows);
            docs.addAll(this.doRequest(uir, sb, rowString));
        }
        return docs;
    }

    @Override
    public List<SolrDoc> getDocumentsByResourceMapFieldAndDocumentsField(String uir, String resourceMapId, String documentsId) throws IOException {
        return this.getDocumentsByTwoFields(uir, "resourceMap", resourceMapId, "documents", documentsId);
    }

    @Override
    public List<SolrDoc> getDocumentsByResourceMapFieldAndIsDocumentedByField(String uir, String resourceMapId, String isDocumentedById) throws IOException {
        return this.getDocumentsByTwoFields(uir, "resourceMap", resourceMapId, "isDocumentedBy", isDocumentedById);
    }

    private List<SolrDoc> getDocumentsByTwoFields(String uir, String field1, String field1Value, String field2, String field2Value) throws IOException {
        ArrayList<SolrDoc> docs = new ArrayList<SolrDoc>();
        StringBuilder sb = new StringBuilder();
        sb.append(field1 + ":").append(ClientUtils.escapeQueryChars(field1Value));
        sb.append(" AND ");
        sb.append(field2 + ":").append(ClientUtils.escapeQueryChars(field2Value));
        docs.addAll(this.doRequest(uir, sb, MAX_ROWS));
        return docs;
    }

    protected List<SolrDoc> doRequest(String uir, StringBuilder sb, String rows) throws IOException {
        String solrQ = sb.toString();
        log.info("Query string: " + solrQ);
        if (log.isTraceEnabled()) {
            log.trace(this);
            log.trace(Thread.currentThread().getStackTrace()[3].getMethodName());
            log.trace(Thread.currentThread().getStackTrace()[4].getMethodName());
            log.trace(Thread.currentThread().getStackTrace()[5].getClassName() + ":" + Thread.currentThread().getStackTrace()[5].getMethodName());
            log.trace(Thread.currentThread().getStackTrace()[6].getClassName() + ":" + Thread.currentThread().getStackTrace()[6].getMethodName());
        }
        SolrQuery sq2 = new SolrQuery();
        sq2.setQuery(solrQ);
        sq2.setParam(PARAM_INDENT, VALUE_INDENT_ON);
        if (rows != null) {
            sq2.setParam(PARAM_START, "0");
            sq2.setParam(PARAM_ROWS, ClientUtils.escapeQueryChars(rows));
        }
        Date callStart = new Date();
        long callEnd = 0L;
        try {
            QueryResponse qr = this.queryClient.query(sq2);
            List<SolrDoc> response = this.parseResponse(qr.getResults());
            callEnd = System.currentTimeMillis();
            List<SolrDoc> list = response;
            return list;
        }
        catch (SolrServerException e1) {
            throw new IOException(e1);
        }
        finally {
            if (AUDIT_CALL_MODE) {
                this.solrCallList.add(solrQ);
                this.solrCallDurationList.add(callEnd - callStart.getTime());
                this.solrCallStartTimeList.add(callStart);
            }
        }
    }

    protected List<SolrDoc> parseResponse(SolrDocumentList sdl) {
        Iterator it = sdl.iterator();
        int countDoc = 0;
        ArrayList<SolrDoc> docs = new ArrayList<SolrDoc>();
        while (it.hasNext()) {
            ++countDoc;
            docs.add(this.parseResponse((SolrDocument)it.next()));
        }
        log.info("DocCount = " + countDoc);
        return docs;
    }

    protected SolrDoc parseResponse(SolrDocument sd) {
        SolrDoc solrDoc = new SolrDoc();
        if (sd == null) {
            return null;
        }
        log.debug("version for the returned record: " + sd.getFieldValue("_version_"));
        if (sd.hasChildDocuments()) {
            log.info("ChildDocCount = " + sd.getChildDocumentCount());
        }
        int fieldCount = 0;
        StringBuffer sb = new StringBuffer();
        for (String fieldName : sd.getFieldNames()) {
            log.trace(" field name: " + fieldName);
            ++fieldCount;
            sb.append(" [" + fieldName + ": ");
            if (this.solrSchema.getValidFields().contains(fieldName) || fieldName.equals("_version_") || fieldName.endsWith(DYNAMIC_FIELD_SUFFIX)) {
                sb.append("valid: ");
                Object v = sd.getFieldValue(fieldName);
                if (v instanceof Collection) {
                    sb.append("multi-valued: ");
                    for (Object vv : sd.getFieldValues(fieldName)) {
                        SolrElementField sef = new SolrElementField();
                        sef.setName(fieldName);
                        sef.setValue(this.valueConverter(vv));
                        solrDoc.addField(sef);
                        sb.append(this.valueConverter(vv) + "'");
                    }
                } else {
                    SolrElementField sef = new SolrElementField();
                    sef.setName(fieldName);
                    sef.setValue(this.valueConverter(v));
                    solrDoc.addField(sef);
                    sb.append(this.valueConverter(v));
                }
            } else {
                sb.append("NOT valid");
            }
            sb.append("]");
        }
        if (log.isTraceEnabled()) {
            log.trace(sb.toString());
        }
        log.info("FieldCount = " + fieldCount);
        return solrDoc;
    }

    private String valueConverter(Object o) {
        try {
            return (String)o;
        }
        catch (ClassCastException e2) {
            if (o instanceof Long) {
                return Long.toString((Long)o);
            }
            if (o instanceof Boolean) {
                return Boolean.toString((Boolean)o);
            }
            if (o instanceof Date) {
                String date2 = DateTimeMarshaller.serializeDateToUTC((Date)o);
                return StringUtils.replace(date2, "+00:00", "Z");
            }
            if (o instanceof Float) {
                return Float.toString(((Float)o).floatValue());
            }
            if (o instanceof Integer) {
                return Integer.toString((Integer)o);
            }
            throw e2;
        }
    }

    @Override
    public SolrDoc retrieveDocumentFromSolrServer(String id, String solrQueryUri) throws IOException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id);
        List<SolrDoc> indexedDocuments = this.getDocumentsByD1Identifier(solrQueryUri, ids);
        if (indexedDocuments.size() > 0) {
            return indexedDocuments.get(0);
        }
        return null;
    }

    @Override
    public void setSolrSchemaPath(String path) {
    }

    @Override
    public void setSolrIndexUri(String uri) {
        this.solrIndexUri = uri;
    }

    @Override
    public String getSolrIndexUri() {
        return this.solrIndexUri;
    }

    @Override
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected void commit() throws SolrServerException, IOException {
        this.updateClient.commit();
    }
}

