/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.utility;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.IMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.index.generator.IndexTaskGenerator;
import org.dataone.cn.index.processor.IndexTaskProcessor;
import org.dataone.cn.index.task.IgnoringIndexIdPool;
import org.dataone.cn.index.task.IndexTask;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class SolrIndexBuildTool {
    private static Logger logger = Logger.getLogger(SolrIndexBuildTool.class.getName());
    private static final String HZ_SYSTEM_METADATA = Settings.getConfiguration().getString("dataone.hazelcast.systemMetadata");
    private static final String HZ_OBJECT_PATH = Settings.getConfiguration().getString("dataone.hazelcast.objectPath");
    private static final String HZ_IDENTIFIERS = Settings.getConfiguration().getString("dataone.hazelcast.identifiers");
    private static final String STANDARD_FS_CONFIG_LOCATION = "/etc/dataone/index/index-generation-context/";
    private static final String DEFAULT_INDEX_APPLICATION_CONTEXT = "index-tool-context.xml";
    private static final String NEXT_INDEX_APPLICATION_CONTEXT = "index-tool-next-context.xml";
    private static boolean BATCH_UPDATE = Settings.getConfiguration().getBoolean("dataone.indexing.tool.batchUpdate", false);
    private static int BATCH_UPDATE_SIZE = Settings.getConfiguration().getInt("dataone.indexing.batchUpdateSize", 1000);
    private static int INDEX_TASK_ONE_CYCLE_SIZE = Settings.getConfiguration().getInt("dataone.indexing.tool.indexTaskOneCycleSize", 1000);
    private HazelcastClient hzClient;
    private IMap<Identifier, SystemMetadata> systemMetadata;
    private IMap<Identifier, String> objectPaths;
    private Set<Identifier> pids;
    private ApplicationContext context;
    private IndexTaskGenerator generator;
    private IndexTaskProcessor processor;
    private boolean buildNextIndex = false;

    public static void main(String[] args) {
        int i;
        Options options = new Options();
        options.addOption("help", false, "print this message");
        options.addOption("getCount", false, "returns the number of pids in the HZ Identifiers set");
        options.addOption("listPids", false, "Output a list of all pids");
        options.addOption("all", false, "reindex from HZ identifiers set from the object store");
        options.addOption("pidFile", true, "Refresh index document for pids contained in the file path supplied with this option.  File should contain one pid per line.");
        options.addOption("date", true, "System data modified date to begin index build/refresh from. Format: mm/dd/yyyy");
        options.addOption("startAt", true, "index in the list to start processing at");
        options.addOption("count", true, "the number of items to process");
        options.addOption("useIndexQueue", false, "use the persistent index task queue to process from.  this simulates normal workflow");
        options.addOption("generateOnly", false, "Don't process any tasks, just submit to the persistent index task queue.");
        options.addOption("processOnly", false, "Don't generate new tasks");
        options.addOption("migrate", false, "Build/refresh data object into the next search index version's core - as configured in: /etc/dataone/solr-next.properties");
        options.addOption("stayAlive", false, "if set, keeps process alive until interrupt received.  Use primarily for profiling.");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e2) {
            System.err.println("Command Line Parsing failed.  Reason: " + e2.getMessage());
        }
        HelpFormatter formatter = new HelpFormatter();
        if (cmd.hasOption("help")) {
            formatter.printHelp("index build tool", options);
            return;
        }
        String[] exclusiveOptions = new String[]{"all", "pidList", "getCount", "listPids"};
        int excl = 0;
        for (i = 0; i < exclusiveOptions.length; ++i) {
            if (!cmd.hasOption(exclusiveOptions[i])) continue;
            ++excl;
        }
        if (excl > 1) {
            System.err.println("Only one of -all, -pidFile, -getCount, or -listPids can be used!!");
            formatter.printHelp("index build tool", options);
            return;
        }
        exclusiveOptions = new String[]{"processOnly", "generateOnly", "useIndexQueue"};
        excl = 0;
        for (i = 0; i < exclusiveOptions.length; ++i) {
            if (!cmd.hasOption(exclusiveOptions[i])) continue;
            ++excl;
        }
        if (excl > 1) {
            System.err.println("Only one of -processOnly, -generateOnly, -useIndexQueue,can be used!!");
            formatter.printHelp("index build tool", options);
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        Date startDate = null;
        String dateString = null;
        if (cmd.hasOption("date")) {
            try {
                startDate = dateFormat.parse(cmd.getOptionValue("date"));
            }
            catch (java.text.ParseException e3) {
                System.out.println("Unable to parse provided date string: " + dateString);
                formatter.printHelp("index build tool", options);
                return;
            }
        }
        SolrIndexBuildTool indexTool = new SolrIndexBuildTool();
        try {
            indexTool.doWork(cmd);
        }
        catch (Exception e4) {
            System.out.println("Solr index refresh failed: " + e4.getMessage());
            e4.printStackTrace(System.out);
        }
        if (cmd.hasOption("stayAlive")) {
            try {
                while (true) {
                    Thread.sleep(60000L);
                }
            }
            catch (InterruptedException e5) {
                System.out.println("Interrupt received...");
            }
        }
        System.out.println("Exiting solr index refresh tool.");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(CommandLine cmd) throws InterruptedException {
        this.setBuildNextIndex(cmd.hasOption("migrate"));
        this.configureContext();
        System.err.println("Starting work... (" + new Date() + ")");
        this.configureHazelcast();
        if (cmd.hasOption("getCount")) {
            System.out.println("There is a pid total (from HZ Identifier set) of " + this.pids.size());
            return;
        }
        if (cmd.hasOption("listPids")) {
            System.err.println("Listing Pids (from Hazelcast Identifiers set)");
            for (Identifier pid : this.pids) {
                System.out.println(pid.getValue());
            }
            return;
        }
        boolean exceptionThrown = false;
        int futuresCount = 0;
        HashSet<Future> doneFutures = new HashSet<Future>();
        try {
            Collection<Identifier> pidSource = null;
            if (cmd.hasOption("all")) {
                System.err.println("Reindexing all from HZ.identifiers map, using date and index filters");
                pidSource = this.pids;
            } else if (cmd.hasOption("pidFile")) {
                String filepath = cmd.getOptionValue("pidFile");
                pidSource = this.getPidList(filepath);
            }
            List filteredPids = null;
            if (pidSource != null) {
                Stream s = pidSource.stream();
                System.out.println("start  / count = " + cmd.getOptionValue("startAt") + " / " + cmd.getOptionValue("count"));
                if (cmd.hasOption("startAt")) {
                    s = s.skip(Long.valueOf(cmd.getOptionValue("startAt")));
                }
                if (cmd.hasOption("count")) {
                    s = s.limit(Long.valueOf(cmd.getOptionValue("count")));
                }
                filteredPids = s.collect(Collectors.toList());
                System.out.println("********** post filtering pid count = " + filteredPids.size());
            } else {
                if (!cmd.hasOption("processOnly")) {
                    return;
                }
                filteredPids = (List)pidSource;
            }
            if (cmd.hasOption("useIndexQueue") || cmd.hasOption("generateOnly")) {
                for (Object id : filteredPids) {
                    SystemMetadata smd = this.systemMetadata.get(id);
                    if (smd == null) {
                        System.out.println("Unable to get system metadata for id: " + ((Identifier)id).getValue());
                        continue;
                    }
                    if (!IgnoringIndexIdPool.isNotIgnorePid(smd)) continue;
                    String objectPath = this.retrieveObjectPath(smd.getIdentifier().getValue());
                    this.generator.processSystemMetaDataUpdate(smd, objectPath);
                    System.out.println("Submitted index task for id: " + ((Identifier)id).getValue());
                }
            }
            if (cmd.hasOption("generateOnly")) {
                return;
            }
            if (cmd.hasOption("useIndexQueue") || cmd.hasOption("processOnly")) {
                this.processor.processIndexTaskQueue();
            } else {
                ArrayList<IndexTask> privateQueue = new ArrayList<IndexTask>();
                for (Identifier id : filteredPids) {
                    SystemMetadata smd = this.systemMetadata.get(id);
                    if (smd == null) {
                        System.out.println("Unable to get system metadata for id: " + id.getValue());
                        continue;
                    }
                    if (!IgnoringIndexIdPool.isNotIgnorePid(smd)) continue;
                    String objectPath = this.retrieveObjectPath(smd.getIdentifier().getValue());
                    IndexTask indexTask = new IndexTask(smd, objectPath);
                    indexTask.setAddPriority();
                    privateQueue.add(indexTask);
                }
                this.processor.processIndexTaskQueue(privateQueue);
            }
            Queue<Future<Void>> futures = this.getIndexTaskProcessor().getFutureQueue();
            futuresCount = futures.size();
            System.out.println(futures.size() + " futures found in the indexProcessorFutureQueue.");
            if (futuresCount > 0) {
                int totalTimeout = futuresCount * 2000;
                System.out.println("... waiting maximum of " + totalTimeout + "ms to finish (2s per future...");
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() < start + (long)totalTimeout) {
                    for (Future future : futures) {
                        if (doneFutures.contains(future) || !future.isDone()) continue;
                        doneFutures.add(future);
                        try {
                            future.get(100L, TimeUnit.MILLISECONDS);
                        }
                        catch (Throwable t) {
                            Throwable cause = t.getCause();
                            if (cause == null) {
                                cause = t;
                            }
                            logger.warn("Exception returned from the thread: " + cause.getClass().getSimpleName() + ":: " + cause.getMessage());
                            t.printStackTrace();
                        }
                    }
                    if (doneFutures.size() == futuresCount) {
                        int coolDownMillis = futuresCount > 9000 ? futuresCount / 3 : 3000;
                        System.out.println("all futures are done (" + futuresCount + "). Cooling-down for " + coolDownMillis + " millis.");
                        Thread.sleep(coolDownMillis);
                        break;
                    }
                    Thread.sleep(2000L);
                    System.out.println("Total of " + doneFutures.size() + " futures of " + futures.size() + " are done.");
                }
                if (doneFutures.size() < futuresCount) {
                    System.out.println("Not all futures completed before timing out. There are " + (futuresCount - doneFutures.size()) + " not done.");
                }
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            exceptionThrown = true;
            System.out.print("Throwable thrown. Recalculating futureQueue.size from the executor.  Was " + futuresCount);
            try {
                futuresCount = this.getIndexTaskProcessor().getFutureQueue().size();
                System.out.println(".  Now " + futuresCount);
            }
            catch (Throwable filteredPids) {
                // empty catch block
            }
            System.out.println("Exception thrown during processing, so waiting the maximum time (" + 2 * futuresCount + " seconds) before shutting down");
            long startWait = System.currentTimeMillis();
            try {
                Thread.sleep(futuresCount * 2000);
            }
            catch (InterruptedException e1) {
                System.out.println("Are you sure you want to interrupt?  Signal again to break out of waiting period.");
                long elapsed = System.currentTimeMillis() - startWait;
                Thread.sleep((long)(futuresCount * 2000) - elapsed);
            }
        }
        finally {
            if (doneFutures.size() < futuresCount) {
                logger.warn("Shutting down index task processor executor...");
                this.getIndexTaskProcessor().shutdownExecutor();
            }
            logger.warn("Finishing work... (" + new Date() + ")");
            System.out.println("Finishing work... (" + new Date() + ")");
            this.shutdown();
        }
    }

    /*
     * Exception decompiling
     */
    private List<Identifier> getPidList(String filepath) throws FileNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateIndexForPids(String pidFilePath) {
    }

    private void generateIndexTasksAndProcess(Date fromDate, int totalToProcess, int startIndex) {
        System.out.println("Generating index updates: " + new Date());
        int count = 0;
        System.out.println("System Identifiers HzCast structure contains: " + this.pids.size() + " identifiers.");
        ArrayList<IndexTask> queue = new ArrayList<IndexTask>();
        for (Identifier smdId : this.pids) {
            SystemMetadata systemMetadata = this.systemMetadata.get(smdId);
            if (!IgnoringIndexIdPool.isNotIgnorePid(systemMetadata)) {
                System.out.println("PID: " + smdId.getValue() + " was skipped for indexing since it is in the ignoring id pool.");
                continue;
            }
            if (++count < startIndex) {
                System.out.println("Skipping pid: " + smdId.getValue());
                continue;
            }
            if (startIndex > 0) {
                startIndex = -1;
            }
            if (fromDate != null && fromDate.compareTo(systemMetadata.getDateSysMetadataModified()) > 0) continue;
            if (systemMetadata == null || systemMetadata.getIdentifier() == null) {
                System.out.println("PID: " + smdId.getValue() + " exists in pids set but cannot be found in system metadata map.");
                continue;
            }
            String objectPath = this.retrieveObjectPath(systemMetadata.getIdentifier().getValue());
            IndexTask task = new IndexTask(systemMetadata, objectPath);
            task.setAddPriority();
            queue.add(task);
            if (count > INDEX_TASK_ONE_CYCLE_SIZE) {
                this.processor.processIndexTaskQueue(queue);
                count = 0;
                logger.info("SolrINdexBuildTool.generateIndexTasksAndProcess - empty the queue for the next cycle.");
                queue = new ArrayList();
            }
            if (count % 10 == 0) {
                System.out.print(".");
            }
            if (totalToProcess <= 0 || count < totalToProcess) continue;
            System.out.println("Total to process reached. Exiting after processing.");
            break;
        }
        this.processor.processIndexTaskQueue(queue);
        logger.info("Submitting all new index tasks has completed in the generaterIndexTasksAndProcess");
        try {
            Queue<Future<Void>> futures = this.getIndexTaskProcessor().getFutureQueue();
            block3: for (Future future : futures) {
                for (int i = 0; i < 60; ++i) {
                    if (future == null || future.isDone()) {
                        logger.info("A future has been done. Ignore it before starting to index failed index tasks.");
                        continue block3;
                    }
                    logger.info("A future has NOT been done. Wait 5 seconds for starting to index failed index tasks.");
                    Thread.sleep(5000L);
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        logger.info("All new index tasks have been done in the generaterIndexTasksAndProcess and we will start to index the failured or not-ready index tasks.");
        this.processor.processIndexTaskQueue();
    }

    private String retrieveObjectPath(String pid) {
        Identifier PID = new Identifier();
        PID.setValue(pid);
        return this.objectPaths.get(PID);
    }

    private void configureHazelcast() {
        logger.info("starting hazelcast client...");
        this.hzClient = HazelcastClientFactory.getStorageClient();
        this.systemMetadata = this.hzClient.getMap(HZ_SYSTEM_METADATA);
        this.objectPaths = this.hzClient.getMap(HZ_OBJECT_PATH);
        this.pids = this.hzClient.getSet(HZ_IDENTIFIERS);
    }

    private void configureContext() {
        String contextFileName = this.buildNextIndex ? NEXT_INDEX_APPLICATION_CONTEXT : DEFAULT_INDEX_APPLICATION_CONTEXT;
        logger.warn("solrIndexBuildTool - context from filename: " + contextFileName);
        try {
            logger.warn("SolrIndexBuildTool - trying file system location first...");
            this.context = new FileSystemXmlApplicationContext(STANDARD_FS_CONFIG_LOCATION + contextFileName);
        }
        catch (Exception e2) {
            logger.warn("SolrIndexBuildTool - Falling back to configuration included in jar file.");
            this.context = new ClassPathXmlApplicationContext(contextFileName);
        }
        this.generator = (IndexTaskGenerator)this.context.getBean("indexTaskGenerator");
        this.processor = (IndexTaskProcessor)this.context.getBean("indexTaskProcessor");
    }

    private void shutdown() {
        if (this.hzClient != null) {
            logger.warn("Shutting down HZ client...");
            this.hzClient.shutdown();
        } else {
            logger.warn("(No HZ client to shutdown)");
        }
    }

    private void setBuildNextIndex(boolean next) {
        this.buildNextIndex = next;
    }

    public IndexTaskProcessor getIndexTaskProcessor() {
        return this.processor;
    }
}

