/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite.jena;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.foresite.AggregatedResource;
import org.dspace.foresite.Aggregation;
import org.dspace.foresite.OREException;
import org.dspace.foresite.Proxy;
import org.dspace.foresite.Triple;
import org.dspace.foresite.TripleSelector;
import org.dspace.foresite.Vocab;
import org.dspace.foresite.jena.JenaOREFactory;
import org.dspace.foresite.jena.ORE;
import org.dspace.foresite.jena.OREResourceJena;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatedResourceJena
extends OREResourceJena
implements AggregatedResource {
    @Override
    public void empty() {
    }

    @Override
    public void detach() throws OREException {
    }

    @Override
    public List<Triple> listTriples(TripleSelector selector) throws OREException {
        selector.setSubjectURI(this.getURI());
        return super.listTriples(selector);
    }

    @Override
    public void initialise(URI uri) throws OREException {
        String ident = uri.toString();
        String rx = ".+://.+";
        Pattern p = Pattern.compile(rx);
        Matcher m = p.matcher(ident);
        if (!m.matches()) {
            throw new OREException("Illegal URI: " + uri.toString() + "; AggregatedResource requires a protocol-based URI");
        }
        this.res = this.model.createResource(uri.toString());
        this.res.addProperty(RDF.type, ORE.AggregatedResource);
    }

    @Override
    public List<URI> getAggregations() throws OREException {
        try {
            ArrayList<URI> uris = new ArrayList<URI>();
            StmtIterator itr = this.res.listProperties(ORE.isAggregatedBy);
            while (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                String value = ((Literal)statement.getObject()).getLexicalForm();
                uris.add(new URI(value));
            }
            return uris;
        }
        catch (URISyntaxException e2) {
            throw new OREException(e2);
        }
    }

    @Override
    public void setAggregations(List<URI> aggregations) {
        this.clearAggregations();
        for (URI agg : aggregations) {
            this.addAggregation(agg);
        }
    }

    @Override
    public void addAggregation(URI aggregation) {
        this.res.addProperty(ORE.isAggregatedBy, this.model.createTypedLiteral(aggregation));
    }

    @Override
    public void clearAggregations() {
        StmtIterator itr = this.res.listProperties(ORE.isAggregatedBy);
        this.model.remove(itr);
    }

    @Override
    public Aggregation getAggregation() throws OREException {
        try {
            ResIterator itr = this.model.listSubjectsWithProperty(ORE.aggregates, this.res);
            if (itr.hasNext()) {
                Resource resource = itr.nextResource();
                Aggregation agg = JenaOREFactory.createAggregation(this.model, new URI(resource.getURI()));
                return agg;
            }
            return null;
        }
        catch (URISyntaxException e2) {
            throw new OREException(e2);
        }
    }

    @Override
    public void setTypes(List<URI> types) {
        super.setTypes(types);
        SimpleSelector selector = new SimpleSelector(this.res, RDF.type, ORE.Aggregation);
        StmtIterator itr = this.model.listStatements(selector);
        if (!itr.hasNext()) {
            this.res.addProperty(RDF.type, ORE.AggregatedResource);
        }
    }

    @Override
    public void clearTypes() {
        super.clearTypes();
        this.res.addProperty(RDF.type, ORE.AggregatedResource);
    }

    @Override
    public List<URI> getResourceMaps() throws OREException {
        try {
            ArrayList<URI> rems = new ArrayList<URI>();
            StmtIterator itr = this.res.listProperties(ORE.isDescribedBy);
            while (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                Resource resource = (Resource)statement.getObject();
                rems.add(new URI(resource.getURI()));
            }
            return rems;
        }
        catch (URISyntaxException e2) {
            throw new OREException(e2);
        }
    }

    @Override
    public void setResourceMaps(List<URI> rems) throws OREException {
        this.clearResourceMaps();
        for (URI rem : rems) {
            this.addResourceMap(rem);
        }
    }

    @Override
    public void addResourceMap(URI rem) throws OREException {
        this.res.addProperty(ORE.isDescribedBy, this.model.createResource(rem.toString()));
    }

    @Override
    public void clearResourceMaps() throws OREException {
        StmtIterator itr = this.res.listProperties(ORE.isDescribedBy);
        this.model.remove(itr);
    }

    @Override
    public boolean hasProxy() throws OREException {
        SimpleSelector selector = new SimpleSelector(null, ORE.proxyFor, this.res);
        StmtIterator itr = this.model.listStatements(selector);
        return itr.hasNext();
    }

    @Override
    public Proxy getProxy() throws OREException {
        try {
            SimpleSelector selector = new SimpleSelector(null, ORE.proxyFor, this.res);
            StmtIterator itr = this.model.listStatements(selector);
            if (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                Proxy proxy = JenaOREFactory.createProxy(this.model, new URI(statement.getSubject().getURI()));
                return proxy;
            }
            return null;
        }
        catch (URISyntaxException e2) {
            throw new OREException(e2);
        }
    }

    @Override
    public Proxy createProxy(URI proxyURI) throws OREException {
        Aggregation agg = this.getAggregation();
        if (agg == null) {
            throw new OREException("Cannot create a Proxy in an AggregatedResource which does not belong to an Aggregation");
        }
        Proxy proxy = JenaOREFactory.createProxy(this.model, proxyURI);
        proxy.setProxyForURI(this.getURI());
        proxy.setProxyInURI(agg.getURI());
        return proxy;
    }

    @Override
    public Vocab getOREType() throws OREException {
        return Vocab.ore_AggregatedResource;
    }
}

