/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.lang.reflect.SourceLocation;
import org.aspectj.runtime.internal.AroundClosure;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.Assert;

public class MethodInvocationProceedingJoinPoint
implements ProceedingJoinPoint,
JoinPoint.StaticPart {
    private static final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private final ProxyMethodInvocation methodInvocation;
    private Object[] defensiveCopyOfArgs;
    private Signature signature;
    private SourceLocation sourceLocation;

    public MethodInvocationProceedingJoinPoint(ProxyMethodInvocation methodInvocation) {
        Assert.notNull(methodInvocation, "MethodInvocation must not be null");
        this.methodInvocation = methodInvocation;
    }

    @Override
    public void set$AroundClosure(AroundClosure aroundClosure) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object proceed() throws Throwable {
        return this.methodInvocation.invocableClone().proceed();
    }

    @Override
    public Object proceed(Object[] arguments) throws Throwable {
        Assert.notNull(arguments, "Argument array passed to proceed cannot be null");
        if (arguments.length != this.methodInvocation.getArguments().length) {
            throw new IllegalArgumentException("Expecting " + this.methodInvocation.getArguments().length + " arguments to proceed, but was passed " + arguments.length + " arguments");
        }
        this.methodInvocation.setArguments(arguments);
        return this.methodInvocation.invocableClone(arguments).proceed();
    }

    @Override
    public Object getThis() {
        return this.methodInvocation.getProxy();
    }

    @Override
    public Object getTarget() {
        return this.methodInvocation.getThis();
    }

    @Override
    public Object[] getArgs() {
        if (this.defensiveCopyOfArgs == null) {
            Object[] argsSource = this.methodInvocation.getArguments();
            this.defensiveCopyOfArgs = new Object[argsSource.length];
            System.arraycopy(argsSource, 0, this.defensiveCopyOfArgs, 0, argsSource.length);
        }
        return this.defensiveCopyOfArgs;
    }

    @Override
    public Signature getSignature() {
        if (this.signature == null) {
            this.signature = new MethodSignatureImpl();
        }
        return this.signature;
    }

    @Override
    public SourceLocation getSourceLocation() {
        if (this.sourceLocation == null) {
            this.sourceLocation = new SourceLocationImpl();
        }
        return this.sourceLocation;
    }

    @Override
    public String getKind() {
        return "method-execution";
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public JoinPoint.StaticPart getStaticPart() {
        return this;
    }

    @Override
    public String toShortString() {
        return "execution(" + this.getSignature().toShortString() + ")";
    }

    @Override
    public String toLongString() {
        return "execution(" + this.getSignature().toLongString() + ")";
    }

    @Override
    public String toString() {
        return "execution(" + this.getSignature().toString() + ")";
    }

    private class SourceLocationImpl
    implements SourceLocation {
        private SourceLocationImpl() {
        }

        @Override
        public Class<?> getWithinType() {
            if (MethodInvocationProceedingJoinPoint.this.methodInvocation.getThis() == null) {
                throw new UnsupportedOperationException("No source location joinpoint available: target is null");
            }
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getThis().getClass();
        }

        @Override
        public String getFileName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLine() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public int getColumn() {
            throw new UnsupportedOperationException();
        }
    }

    private class MethodSignatureImpl
    implements MethodSignature {
        private volatile String[] parameterNames;

        private MethodSignatureImpl() {
        }

        @Override
        public String getName() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getName();
        }

        @Override
        public int getModifiers() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getModifiers();
        }

        @Override
        public Class<?> getDeclaringType() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getDeclaringClass();
        }

        @Override
        public String getDeclaringTypeName() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getDeclaringClass().getName();
        }

        @Override
        public Class<?> getReturnType() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getReturnType();
        }

        @Override
        public Method getMethod() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod();
        }

        public Class<?>[] getParameterTypes() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getParameterTypes();
        }

        @Override
        public String[] getParameterNames() {
            if (this.parameterNames == null) {
                this.parameterNames = parameterNameDiscoverer.getParameterNames(this.getMethod());
            }
            return this.parameterNames;
        }

        public Class<?>[] getExceptionTypes() {
            return MethodInvocationProceedingJoinPoint.this.methodInvocation.getMethod().getExceptionTypes();
        }

        @Override
        public String toShortString() {
            return this.toString(false, false, false, false);
        }

        @Override
        public String toLongString() {
            return this.toString(true, true, true, true);
        }

        @Override
        public String toString() {
            return this.toString(false, true, false, true);
        }

        private String toString(boolean includeModifier, boolean includeReturnTypeAndArgs, boolean useLongReturnAndArgumentTypeName, boolean useLongTypeName) {
            StringBuilder sb = new StringBuilder();
            if (includeModifier) {
                sb.append(Modifier.toString(this.getModifiers()));
                sb.append(" ");
            }
            if (includeReturnTypeAndArgs) {
                this.appendType(sb, this.getReturnType(), useLongReturnAndArgumentTypeName);
                sb.append(" ");
            }
            this.appendType(sb, this.getDeclaringType(), useLongTypeName);
            sb.append(".");
            sb.append(this.getMethod().getName());
            sb.append("(");
            Class<?>[] parametersTypes = this.getParameterTypes();
            this.appendTypes(sb, parametersTypes, includeReturnTypeAndArgs, useLongReturnAndArgumentTypeName);
            sb.append(")");
            return sb.toString();
        }

        private void appendTypes(StringBuilder sb, Class<?>[] types, boolean includeArgs, boolean useLongReturnAndArgumentTypeName) {
            if (includeArgs) {
                int size = types.length;
                for (int i = 0; i < size; ++i) {
                    this.appendType(sb, types[i], useLongReturnAndArgumentTypeName);
                    if (i >= size - 1) continue;
                    sb.append(",");
                }
            } else if (types.length != 0) {
                sb.append("..");
            }
        }

        private void appendType(StringBuilder sb, Class<?> type, boolean useLongTypeName) {
            if (type.isArray()) {
                this.appendType(sb, type.getComponentType(), useLongTypeName);
                sb.append("[]");
            } else {
                sb.append(useLongTypeName ? type.getName() : type.getSimpleName());
            }
        }
    }
}

