/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class ReflectionUtils {
    public static <T> T createInstanceIfPresent(String classname, T defaultInstance) {
        try {
            Class<?> type = ClassUtils.getDefaultClassLoader().loadClass(classname);
            return (T)BeanUtils.instantiateClass(type);
        }
        catch (Exception e2) {
            return defaultInstance;
        }
    }

    public static Field findField(Class<?> type, final ReflectionUtils.FieldFilter filter) {
        return ReflectionUtils.findField(type, new DescribedFieldFilter(){

            @Override
            public boolean matches(Field field) {
                return filter.matches(field);
            }

            @Override
            public String getDescription() {
                return String.format("FieldFilter %s", filter.toString());
            }
        }, false);
    }

    public static Field findField(Class<?> type, DescribedFieldFilter filter) {
        return ReflectionUtils.findField(type, filter, true);
    }

    public static Field findField(Class<?> type, DescribedFieldFilter filter, boolean enforceUniqueness) {
        Assert.notNull(type, "Type must not be null!");
        Assert.notNull(filter, "Filter must not be null!");
        Field foundField = null;
        for (Class<?> targetClass = type; targetClass != Object.class; targetClass = targetClass.getSuperclass()) {
            for (Field field : targetClass.getDeclaredFields()) {
                if (!filter.matches(field)) continue;
                if (!enforceUniqueness) {
                    return field;
                }
                if (foundField != null && enforceUniqueness) {
                    throw new IllegalStateException(filter.getDescription());
                }
                foundField = field;
            }
        }
        return foundField;
    }

    public static void setField(Field field, Object target, Object value) {
        org.springframework.util.ReflectionUtils.makeAccessible(field);
        org.springframework.util.ReflectionUtils.setField(field, target, value);
    }

    public static class AnnotationFieldFilter
    implements DescribedFieldFilter {
        private final Class<? extends Annotation> annotationType;

        public AnnotationFieldFilter(Class<? extends Annotation> annotationType) {
            Assert.notNull(annotationType, "Annotation type must not be null!");
            this.annotationType = annotationType;
        }

        @Override
        public boolean matches(Field field) {
            return AnnotationUtils.getAnnotation((AnnotatedElement)field, this.annotationType) != null;
        }

        @Override
        public String getDescription() {
            return String.format("Annotation filter for %s", this.annotationType.getName());
        }
    }

    public static interface DescribedFieldFilter
    extends ReflectionUtils.FieldFilter {
        public String getDescription();
    }
}

