/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.util.Assert;

public abstract class AbstractDirtiesContextTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log logger = LogFactory.getLog(AbstractDirtiesContextTestExecutionListener.class);

    @Override
    public abstract int getOrder();

    protected void dirtyContext(TestContext testContext, DirtiesContext.HierarchyMode hierarchyMode) {
        testContext.markApplicationContextDirty(hierarchyMode);
        testContext.setAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE, Boolean.TRUE);
    }

    protected void beforeOrAfterTestMethod(TestContext testContext, DirtiesContext.MethodMode requiredMethodMode, DirtiesContext.ClassMode requiredClassMode) throws Exception {
        DirtiesContext.ClassMode classMode;
        Assert.notNull(testContext, "TestContext must not be null");
        Assert.notNull((Object)requiredMethodMode, "requiredMethodMode must not be null");
        Assert.notNull((Object)requiredClassMode, "requiredClassMode must not be null");
        Class<?> testClass = testContext.getTestClass();
        Method testMethod = testContext.getTestMethod();
        Assert.notNull(testClass, "The test class of the supplied TestContext must not be null");
        Assert.notNull(testMethod, "The test method of the supplied TestContext must not be null");
        DirtiesContext methodAnn = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)testMethod, DirtiesContext.class);
        DirtiesContext classAnn = AnnotatedElementUtils.findMergedAnnotation(testClass, DirtiesContext.class);
        boolean methodAnnotated = methodAnn != null;
        boolean classAnnotated = classAnn != null;
        DirtiesContext.MethodMode methodMode = methodAnnotated ? methodAnn.methodMode() : null;
        DirtiesContext.ClassMode classMode2 = classMode = classAnnotated ? classAnn.classMode() : null;
        if (logger.isDebugEnabled()) {
            String phase = requiredClassMode.name().startsWith("BEFORE") ? "Before" : "After";
            logger.debug(String.format("%s test method: context %s, class annotated with @DirtiesContext [%s] with mode [%s], method annotated with @DirtiesContext [%s] with mode [%s].", new Object[]{phase, testContext, classAnnotated, classMode, methodAnnotated, methodMode}));
        }
        if (methodMode == requiredMethodMode || classMode == requiredClassMode) {
            DirtiesContext.HierarchyMode hierarchyMode = methodAnnotated ? methodAnn.hierarchyMode() : classAnn.hierarchyMode();
            this.dirtyContext(testContext, hierarchyMode);
        }
    }

    protected void beforeOrAfterTestClass(TestContext testContext, DirtiesContext.ClassMode requiredClassMode) throws Exception {
        DirtiesContext.ClassMode classMode;
        Assert.notNull(testContext, "TestContext must not be null");
        Assert.notNull((Object)requiredClassMode, "requiredClassMode must not be null");
        Class<?> testClass = testContext.getTestClass();
        Assert.notNull(testClass, "The test class of the supplied TestContext must not be null");
        DirtiesContext dirtiesContext = AnnotatedElementUtils.findMergedAnnotation(testClass, DirtiesContext.class);
        boolean classAnnotated = dirtiesContext != null;
        DirtiesContext.ClassMode classMode2 = classMode = classAnnotated ? dirtiesContext.classMode() : null;
        if (logger.isDebugEnabled()) {
            String phase = requiredClassMode.name().startsWith("BEFORE") ? "Before" : "After";
            logger.debug(String.format("%s test class: context %s, class annotated with @DirtiesContext [%s] with mode [%s].", new Object[]{phase, testContext, classAnnotated, classMode}));
        }
        if (classMode == requiredClassMode) {
            this.dirtyContext(testContext, dirtiesContext.hierarchyMode());
        }
    }
}

