/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ActiveProfilesResolver;
import org.springframework.test.context.support.DefaultActiveProfilesResolver;
import org.springframework.test.util.MetaAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class ActiveProfilesUtils {
    private static final Log logger = LogFactory.getLog(ActiveProfilesUtils.class);

    ActiveProfilesUtils() {
    }

    static String[] resolveActiveProfiles(Class<?> testClass) {
        Assert.notNull(testClass, "Class must not be null");
        ArrayList<String[]> profileArrays = new ArrayList<String[]>();
        Class<ActiveProfiles> annotationType = ActiveProfiles.class;
        MetaAnnotationUtils.AnnotationDescriptor<ActiveProfiles> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(testClass, annotationType);
        if (descriptor == null && logger.isDebugEnabled()) {
            logger.debug(String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType.getName(), testClass.getName()));
        }
        while (descriptor != null) {
            ActiveProfilesResolver resolver;
            Class<? extends ActiveProfilesResolver> resolverClass;
            Class<?> rootDeclaringClass = descriptor.getRootDeclaringClass();
            Class<?> declaringClass = descriptor.getDeclaringClass();
            ActiveProfiles annotation = descriptor.synthesizeAnnotation();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Retrieved @ActiveProfiles [%s] for declaring class [%s]", annotation, declaringClass.getName()));
            }
            if (ActiveProfilesResolver.class == (resolverClass = annotation.resolver())) {
                resolverClass = DefaultActiveProfilesResolver.class;
            }
            try {
                resolver = BeanUtils.instantiateClass(resolverClass, ActiveProfilesResolver.class);
            }
            catch (Exception ex) {
                String msg = String.format("Could not instantiate ActiveProfilesResolver of type [%s] for test class [%s]", resolverClass.getName(), rootDeclaringClass.getName());
                logger.error(msg);
                throw new IllegalStateException(msg, ex);
            }
            String[] profiles = resolver.resolve(rootDeclaringClass);
            if (profiles == null) {
                String msg = String.format("ActiveProfilesResolver [%s] returned a null array of bean definition profiles", resolverClass.getName());
                logger.error(msg);
                throw new IllegalStateException(msg);
            }
            profileArrays.add(profiles);
            descriptor = annotation.inheritProfiles() ? MetaAnnotationUtils.findAnnotationDescriptor(rootDeclaringClass.getSuperclass(), annotationType) : null;
        }
        Collections.reverse(profileArrays);
        LinkedHashSet<String> activeProfiles = new LinkedHashSet<String>();
        Iterator iterator = profileArrays.iterator();
        while (iterator.hasNext()) {
            String[] profiles;
            for (String profile : profiles = (String[])iterator.next()) {
                if (!StringUtils.hasText(profile)) continue;
                activeProfiles.add(profile.trim());
            }
        }
        return StringUtils.toStringArray(activeProfiles);
    }
}

