/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import java.io.IOException;
import java.util.Iterator;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.test.web.client.AbstractRequestExpectationManager;
import org.springframework.test.web.client.RequestExpectation;
import org.springframework.util.Assert;

public class SimpleRequestExpectationManager
extends AbstractRequestExpectationManager {
    private Iterator<RequestExpectation> expectationIterator;
    private final AbstractRequestExpectationManager.RequestExpectationGroup repeatExpectations = new AbstractRequestExpectationManager.RequestExpectationGroup();

    @Override
    protected void afterExpectationsDeclared() {
        Assert.state(this.expectationIterator == null, "Expectations already declared");
        this.expectationIterator = this.getExpectations().iterator();
    }

    @Override
    public ClientHttpResponse validateRequestInternal(ClientHttpRequest request) throws IOException {
        RequestExpectation expectation;
        block2: {
            try {
                expectation = this.next(request);
                expectation.match(request);
            }
            catch (AssertionError error) {
                expectation = this.repeatExpectations.findExpectation(request);
                if (expectation != null) break block2;
                throw error;
            }
        }
        ClientHttpResponse response = expectation.createResponse(request);
        this.repeatExpectations.update(expectation);
        return response;
    }

    private RequestExpectation next(ClientHttpRequest request) {
        if (this.expectationIterator.hasNext()) {
            return this.expectationIterator.next();
        }
        throw this.createUnexpectedRequestError(request);
    }

    @Override
    public void reset() {
        super.reset();
        this.expectationIterator = null;
        this.repeatExpectations.reset();
    }
}

