/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rdfsReasoner1;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.IllegalParameterException;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSInfGraph;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveEngine;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class RDFSReasoner
extends TransitiveReasoner
implements Reasoner {
    public static final Node domainP = RDFS.Nodes.domain;
    public static final Node rangeP = RDFS.Nodes.range;
    protected boolean scanProperties = true;

    public RDFSReasoner() {
    }

    public RDFSReasoner(Resource configuration) {
        Boolean flag;
        if (configuration != null && (flag = this.checkBinaryPredicate(RDFSReasonerFactory.scanProperties, configuration)) != null) {
            this.scanProperties = flag;
        }
    }

    protected RDFSReasoner(Finder tbox, TransitiveGraphCache subClassCache, TransitiveGraphCache subPropertyCache, boolean scanProperties) {
        super(tbox, subClassCache, subPropertyCache);
        this.scanProperties = scanProperties;
    }

    public boolean supportsProperty(Property property) {
        ReasonerFactory rf = RDFSReasonerFactory.theInstance();
        Model caps = rf.getCapabilities();
        Resource root2 = caps.getResource(rf.getURI());
        return caps.contains(root2, ReasonerVocabulary.supportsP, property);
    }

    private Boolean checkBinaryPredicate(Property predicate, Resource configuration) {
        StmtIterator i = configuration.listProperties(predicate);
        if (i.hasNext()) {
            return new Boolean(((Object)i.nextStatement().getObject()).toString().equalsIgnoreCase("true"));
        }
        return null;
    }

    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        if (this.tbox != null) {
            throw new ReasonerException("Attempt to bind multiple rulesets - disallowed for now");
        }
        FGraph ftbox = new FGraph(tbox);
        TransitiveGraphCache sCc = new TransitiveGraphCache(directSubClassOf, subClassOf);
        TransitiveGraphCache sPc = new TransitiveGraphCache(directSubPropertyOf, subPropertyOf);
        TransitiveEngine.cacheSubPropUtility(ftbox, sPc);
        TransitiveEngine.cacheSubClassUtility(ftbox, sPc, sCc);
        sPc.setCaching(true);
        return new RDFSReasoner(ftbox, sCc, sPc, this.scanProperties);
    }

    public InfGraph bind(Graph data) throws ReasonerException {
        return new RDFSInfGraph(this, data);
    }

    public void setDerivationLogging(boolean logOn) {
    }

    public void setParameter(Property parameter, Object value) {
        if (!parameter.equals(RDFSReasonerFactory.scanProperties)) {
            throw new IllegalParameterException(parameter.toString());
        }
        this.scanProperties = Util.convertBooleanPredicateArg(parameter, value);
    }
}

