/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.regression.NewRegressionBase;
import com.hp.hpl.jena.shared.PropertyNotFoundException;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.Test;
import junit.framework.TestSuite;

public class NewRegressionResourceMethods
extends NewRegressionBase {
    protected Model m;
    protected Resource r;
    protected final String lang = "en";
    protected Literal tvLiteral;
    protected Resource tvResource;

    public NewRegressionResourceMethods(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(NewRegressionResourceMethods.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
        this.tvLiteral = this.m.createLiteral("test 12 string 2");
        this.tvResource = this.m.createResource();
        this.r = this.m.createResource().addLiteral(RDF.value, true).addLiteral(RDF.value, 1L).addLiteral(RDF.value, 2L).addLiteral(RDF.value, -1L).addLiteral(RDF.value, -2L).addLiteral(RDF.value, '!').addLiteral(RDF.value, 123.456f).addLiteral(RDF.value, -123.456).addProperty(RDF.value, "test 12 string").addProperty(RDF.value, "test 12 string", "en").addLiteral(RDF.value, tvObject).addProperty(RDF.value, this.tvLiteral).addProperty(RDF.value, this.tvResource);
    }

    public void testBoolean() {
        NewRegressionResourceMethods.assertTrue((boolean)this.r.hasLiteral(RDF.value, true));
    }

    public void testByte() {
        NewRegressionResourceMethods.assertTrue((boolean)this.r.hasLiteral(RDF.value, 1L));
    }

    public void testShort() {
        NewRegressionResourceMethods.assertTrue((boolean)this.r.hasLiteral(RDF.value, 2L));
    }

    public void testInt() {
        NewRegressionResourceMethods.assertTrue((boolean)this.r.hasLiteral(RDF.value, -1L));
    }

    public void testLong() {
        NewRegressionResourceMethods.assertTrue((boolean)this.r.hasLiteral(RDF.value, -2L));
    }

    public void testChar() {
        NewRegressionResourceMethods.assertTrue((boolean)this.r.hasLiteral(RDF.value, '!'));
    }

    public void testFloat() {
        NewRegressionResourceMethods.assertTrue((boolean)this.r.hasLiteral(RDF.value, 123.456f));
    }

    public void testDouble() {
        NewRegressionResourceMethods.assertTrue((boolean)this.r.hasLiteral(RDF.value, -123.456));
    }

    public void testString() {
        NewRegressionResourceMethods.assertTrue((boolean)this.r.hasProperty(RDF.value, "test 12 string"));
    }

    public void testStringWithLanguage() {
        NewRegressionResourceMethods.assertTrue((boolean)this.r.hasProperty(RDF.value, "test 12 string", "en"));
    }

    public void testObject() {
        NewRegressionResourceMethods.assertTrue((boolean)this.r.hasLiteral(RDF.value, tvObject));
    }

    public void testLiteral() {
        NewRegressionResourceMethods.assertTrue((boolean)this.r.hasProperty(RDF.value, this.tvLiteral));
    }

    public void testResource() {
        NewRegressionResourceMethods.assertTrue((boolean)this.r.hasProperty(RDF.value, this.tvResource));
    }

    public void testCorrectSubject() {
        NewRegressionResourceMethods.assertEquals((Object)this.r, (Object)this.r.getRequiredProperty(RDF.value).getSubject());
    }

    public void testNoSuchPropertyException() {
        try {
            this.r.getRequiredProperty(RDF.type);
            NewRegressionResourceMethods.fail((String)"missing property should throw exception");
        }
        catch (PropertyNotFoundException e2) {
            NewRegressionResourceMethods.pass();
        }
    }

    public void testNoSuchPropertyNull() {
        NewRegressionResourceMethods.assertNull((Object)this.r.getProperty(RDF.type));
    }

    public void testAllSubjectsCorrect() {
        this.testHasSubjectR(this.m.listStatements());
        this.testHasSubjectR(this.r.listProperties());
    }

    protected void testHasSubjectR(StmtIterator it) {
        while (it.hasNext()) {
            NewRegressionResourceMethods.assertEquals((Object)this.r, (Object)it.nextStatement().getSubject());
        }
    }

    public void testCountsCorrect() {
        NewRegressionResourceMethods.assertEquals((int)13, (int)NewRegressionResourceMethods.iteratorToList(this.m.listStatements()).size());
        NewRegressionResourceMethods.assertEquals((int)13, (int)NewRegressionResourceMethods.iteratorToList(this.r.listProperties(RDF.value)).size());
        NewRegressionResourceMethods.assertEquals((int)0, (int)NewRegressionResourceMethods.iteratorToList(this.r.listProperties(RDF.type)).size());
    }

    public void testRemoveProperties() {
        this.r.removeProperties();
        NewRegressionResourceMethods.assertEquals((boolean)false, (boolean)this.m.listStatements(this.r, null, (RDFNode)null).hasNext());
    }
}

