/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify.op;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.modify.op.GraphUpdateN;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class UpdatePattern
extends GraphUpdateN {
    private Element pattern = null;
    private List bindings = new ArrayList();

    public Element getElement() {
        return this.pattern;
    }

    public void setPattern(Element pattern) {
        this.pattern = pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = QueryFactory.createElement(pattern);
    }

    protected abstract void exec(Graph var1, List var2);

    protected void startExec(GraphStore graphStore) {
        if (this.pattern != null) {
            Plan plan = QueryExecutionFactory.createPlan(this.pattern, (DatasetGraph)graphStore);
            QueryIterator qIter = plan.iterator();
            while (qIter.hasNext()) {
                Binding b = qIter.nextBinding();
                this.bindings.add(b);
            }
            qIter.close();
        } else {
            this.bindings.add(BindingRoot.create());
        }
    }

    protected void finishExec() {
        this.bindings = null;
    }

    protected void exec(Graph graph) {
        this.exec(graph, this.bindings);
    }

    protected static Collection subst(Template template, QueryIterator qIter) {
        HashSet acc = new HashSet();
        while (qIter.hasNext()) {
            HashMap bNodeMap = new HashMap();
            Binding b = qIter.nextBinding();
            template.subst(acc, bNodeMap, b);
        }
        Iterator iter = acc.iterator();
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            if (UpdatePattern.isGroundTriple(triple)) continue;
            throw new UpdateException("Unbound triple: " + FmtUtils.stringForTriple(triple));
        }
        return acc;
    }

    private static boolean isGroundTriple(Triple triple) {
        return UpdatePattern.isGroundNode(triple.getSubject()) && UpdatePattern.isGroundNode(triple.getPredicate()) && UpdatePattern.isGroundNode(triple.getObject());
    }

    private static boolean isGroundNode(Node node) {
        return node.isConcrete();
    }
}

