/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSingleton;
import com.hp.hpl.jena.sparql.resultset.RSCompare;
import com.hp.hpl.jena.sparql.resultset.ResultSetFormat;
import com.hp.hpl.jena.sparql.resultset.ResultSetMem;
import com.hp.hpl.jena.sparql.resultset.ResultSetRewindable;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.util.FileManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestResultSet
extends TestCase {
    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestResultSet.class);
        ts.setName(Utils.classShortName(TestResultSet.class));
        return ts;
    }

    public void test_RS_1() {
        ResultSetMem rs1 = new ResultSetMem();
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsXML((OutputStream)arr, rs1);
        rs1.reset();
        ByteArrayInputStream ins = new ByteArrayInputStream(arr.toByteArray());
        ResultSet rs2 = ResultSetFactory.fromXML(ins);
        TestResultSet.assertTrue((boolean)RSCompare.same(rs1, rs2));
    }

    public void test_RS_1_str() {
        ResultSetMem rs1 = new ResultSetMem();
        String x = ResultSetFormatter.asXMLString(rs1);
        rs1.reset();
        ResultSet rs2 = ResultSetFactory.fromXML(x);
        TestResultSet.assertTrue((boolean)RSCompare.same(rs1, rs2));
    }

    public void test_RS_2() {
        ResultSetRewindable rs1 = this.makeRewindable("x", Node.createURI("tag:local"));
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsXML((OutputStream)arr, rs1);
        rs1.reset();
        ByteArrayInputStream ins = new ByteArrayInputStream(arr.toByteArray());
        ResultSet rs2 = ResultSetFactory.fromXML(ins);
        TestResultSet.assertTrue((boolean)RSCompare.same(rs1, rs2));
    }

    public void test_RS_2_str() {
        ResultSetRewindable rs1 = this.makeRewindable("x", Node.createURI("tag:local"));
        String x = ResultSetFormatter.asXMLString(rs1);
        rs1.reset();
        ResultSet rs2 = ResultSetFactory.fromXML(x);
        TestResultSet.assertTrue((boolean)RSCompare.same(rs1, rs2));
    }

    public void test_RS_3() {
        ResultSetMem rs1 = new ResultSetMem();
        Model model = ResultSetFormatter.toModel(rs1);
        rs1.reset();
        ResultSet rs2 = ResultSetFactory.fromRDF(model);
        TestResultSet.assertTrue((boolean)RSCompare.same(rs1, rs2));
    }

    public void test_RS_4() {
        ResultSetRewindable rs1 = this.makeRewindable("x", Node.createURI("tag:local"));
        Model model = ResultSetFormatter.toModel(rs1);
        rs1.reset();
        ResultSet rs2 = ResultSetFactory.fromRDF(model);
        TestResultSet.assertTrue((boolean)RSCompare.same(rs1, rs2));
    }

    public void test_RS_5() {
        ResultSetMem rs1 = new ResultSetMem();
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)arr, rs1);
        rs1.reset();
        ByteArrayInputStream ins = new ByteArrayInputStream(arr.toByteArray());
        ResultSet rs2 = ResultSetFactory.fromJSON(ins);
        TestResultSet.assertTrue((boolean)RSCompare.same(rs1, rs2));
    }

    public void test_RS_6() {
        ResultSetRewindable rs1 = this.make2Rewindable("x", Node.createURI("tag:local"));
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)arr, rs1);
        rs1.reset();
        ByteArrayInputStream ins = new ByteArrayInputStream(arr.toByteArray());
        ResultSet rs2 = ResultSetFactory.fromJSON(ins);
        TestResultSet.assertTrue((boolean)RSCompare.same(rs1, rs2));
    }

    public void test_RS_7() {
        InputStream in = FileManager.get().open("testing/ResultSet/output.srx");
        com.hp.hpl.jena.query.ResultSetRewindable rs1 = ResultSetFactory.makeRewindable(ResultSetFactory.fromXML(in));
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.output(arr, rs1, ResultSetFormat.syntaxRDF_XML);
        rs1.reset();
        ByteArrayInputStream ins = new ByteArrayInputStream(arr.toByteArray());
        ResultSet rs2 = ResultSetFactory.load(ins, ResultSetFormat.syntaxRDF_XML);
        TestResultSet.assertTrue((boolean)RSCompare.same(rs1, rs2));
    }

    public void test_RS_8() {
        InputStream in = FileManager.get().open("testing/ResultSet/output.srx");
        com.hp.hpl.jena.query.ResultSetRewindable rs1 = ResultSetFactory.makeRewindable(ResultSetFactory.fromXML(in));
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.output(arr, rs1, ResultSetFormat.syntaxJSON);
        rs1.reset();
        ByteArrayInputStream ins = new ByteArrayInputStream(arr.toByteArray());
        ResultSet rs2 = ResultSetFactory.load(ins, ResultSetFormat.syntaxJSON);
        TestResultSet.assertTrue((boolean)RSCompare.same(rs1, rs2));
    }

    public void test_RS_cmp_1() {
        ResultSetMem rs1 = new ResultSetMem();
        ResultSetMem rs2 = new ResultSetMem();
        TestResultSet.assertTrue((boolean)RSCompare.sameOrdered(rs1, rs2));
        rs1.reset();
        rs2.reset();
        TestResultSet.assertTrue((boolean)RSCompare.sameUnordered(rs1, rs2));
    }

    public void test_RS_cmp_2() {
        ResultSet rs1 = this.make("x", Node.createURI("tag:local"));
        ResultSetMem rs2 = new ResultSetMem();
        TestResultSet.assertFalse((boolean)RSCompare.sameOrdered(rs1, rs2));
    }

    public void test_RS_cmp_3() {
        ResultSet rs1 = this.make("x", Node.createURI("tag:local"));
        ResultSetMem rs2 = new ResultSetMem();
        TestResultSet.assertFalse((boolean)RSCompare.sameUnordered(rs1, rs2));
    }

    public void test_RS_cmp_4() {
        ResultSet rs1 = this.make("x", Node.createURI("tag:local"));
        ResultSet rs2 = this.make("x", Node.createURI("tag:local"));
        TestResultSet.assertTrue((boolean)RSCompare.sameOrdered(rs1, rs2));
        TestResultSet.assertTrue((boolean)RSCompare.sameUnordered(rs1, rs2));
    }

    public void test_RS_cmp_5() {
        ResultSetRewindable rs1 = this.makeRewindable("x", Node.createURI("tag:local:1"));
        ResultSetRewindable rs2 = this.makeRewindable("x", Node.createURI("tag:local:2"));
        TestResultSet.assertFalse((boolean)RSCompare.sameOrdered(rs1, rs2));
        rs1.reset();
        rs2.reset();
        TestResultSet.assertFalse((boolean)RSCompare.sameUnordered(rs1, rs2));
    }

    public void test_RS_cmp_6() {
        ResultSetRewindable rs1 = this.makeRewindable("x", Node.createURI("tag:local"));
        ResultSetRewindable rs2 = this.makeRewindable("y", Node.createURI("tag:local"));
        TestResultSet.assertFalse((boolean)RSCompare.sameOrdered(rs1, rs2));
        rs1.reset();
        rs2.reset();
        TestResultSet.assertFalse((boolean)RSCompare.sameUnordered(rs1, rs2));
    }

    private ResultSet make(String var, Node val) {
        BindingMap b = new BindingMap();
        b.add(Var.alloc(var), val);
        ArrayList<String> vars = new ArrayList<String>();
        vars.add(var);
        QueryIterSingleton qIter = new QueryIterSingleton(b, null);
        ResultSetStream rs = new ResultSetStream(vars, null, qIter);
        return rs;
    }

    private ResultSet make2(String var, Node val) {
        BindingMap b1 = new BindingMap();
        b1.add(Var.alloc(var), val);
        BindingMap b2 = new BindingMap();
        b2.add(Var.alloc(var), val);
        ArrayList<String> vars = new ArrayList<String>();
        vars.add(var);
        ArrayList<BindingMap> solutions = new ArrayList<BindingMap>();
        solutions.add(b1);
        solutions.add(b2);
        QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(solutions.iterator(), null);
        ResultSetStream rs = new ResultSetStream(vars, null, qIter);
        return rs;
    }

    private ResultSetRewindable makeRewindable(String var, Node val) {
        ResultSet rs = this.make(var, val);
        com.hp.hpl.jena.query.ResultSetRewindable rsw = ResultSetFactory.makeRewindable(rs);
        return rsw;
    }

    private ResultSetRewindable make2Rewindable(String var, Node val) {
        ResultSet rs = this.make2(var, val);
        com.hp.hpl.jena.query.ResultSetRewindable rsw = ResultSetFactory.makeRewindable(rs);
        return rsw;
    }

    private ResultSet make(String var1, Node val1, String var2, Node val2) {
        BindingMap b = new BindingMap();
        b.add(Var.alloc(var1), val1);
        b.add(Var.alloc(var2), val2);
        ArrayList<String> vars = new ArrayList<String>();
        vars.add(var1);
        vars.add(var2);
        QueryIterSingleton qIter = new QueryIterSingleton(b, null);
        ResultSetStream rs = new ResultSetStream(vars, null, qIter);
        return rs;
    }

    private ResultSetRewindable makeRewindable(String var1, Node val1, String var2, Node val2) {
        ResultSet rs = this.make(var1, val1, var2, val2);
        com.hp.hpl.jena.query.ResultSetRewindable rsw = ResultSetFactory.makeRewindable(rs);
        return rsw;
    }
}

