/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.junit;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.junit.TestException;

public class TestUtils {
    public static Resource getResource(Resource r, Property p) {
        if (r == null) {
            return null;
        }
        if (!r.hasProperty(p)) {
            return null;
        }
        RDFNode n = r.getProperty(p).getObject();
        if (n instanceof Resource) {
            return (Resource)n;
        }
        throw new TestException("Manifest problem (not a Resource): " + n + " => " + p);
    }

    public static String getLiteral(Resource r, Property p) {
        if (r == null) {
            return null;
        }
        if (!r.hasProperty(p)) {
            return null;
        }
        RDFNode n = r.getProperty(p).getObject();
        if (n instanceof Literal) {
            return ((Literal)n).getLexicalForm();
        }
        throw new TestException("Manifest problem (not a Literal): " + n + " => " + p);
    }

    public static String getLiteralOrURI(Resource r, Property p) {
        Resource r2;
        if (r == null) {
            return null;
        }
        if (!r.hasProperty(p)) {
            return null;
        }
        RDFNode n = r.getProperty(p).getObject();
        if (n instanceof Literal) {
            return ((Literal)n).getLexicalForm();
        }
        if (n instanceof Resource && !(r2 = (Resource)n).isAnon()) {
            return r2.getURI();
        }
        throw new TestException("Manifest problem: " + n + " => " + p);
    }

    public static String safeName(String s) {
        s = s.replace('(', '[');
        s = s.replace(')', ']');
        return s;
    }
}

