/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.transform.impl;

import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.transform.ClassEmitterTransformer;
import org.objectweb.asm.Type;

public class AccessFieldTransformer
extends ClassEmitterTransformer {
    private Callback callback;

    public AccessFieldTransformer(Callback callback) {
        this.callback = callback;
    }

    public void declare_field(int access, String name, Type type, Object value) {
        super.declare_field(access, name, type, value);
        String property = TypeUtils.upperFirst(this.callback.getPropertyName(this.getClassType(), name));
        if (property != null) {
            CodeEmitter e2 = this.begin_method(1, new Signature("get" + property, type, Constants.TYPES_EMPTY), null);
            e2.load_this();
            e2.getfield(name);
            e2.return_value();
            e2.end_method();
            e2 = this.begin_method(1, new Signature("set" + property, Type.VOID_TYPE, new Type[]{type}), null);
            e2.load_this();
            e2.load_arg(0);
            e2.putfield(name);
            e2.return_value();
            e2.end_method();
        }
    }

    public static interface Callback {
        public String getPropertyName(Type var1, String var2);
    }
}

