/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StreamWriterToReceiver;
import net.sf.saxon.event.TransformerReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.value.StringValue;

public class TimingTraceListener
implements TraceListener {
    private int repeat = 0;
    Logger out = new StandardLogger();
    private long t_total;
    private Stack<InstructionDetails> instructs = new Stack();
    HashMap<InstructionInfo, InstructionDetails> instructMap = new HashMap();
    protected Configuration config = null;
    private InstructionInfo[] instructStack = new InstructionInfo[1500];
    private int stackDepth = 0;
    private int lang = 50;

    @Override
    public void setOutputDestination(Logger stream) {
        this.out = stream;
    }

    @Override
    public void open(Controller controller) {
        this.config = controller.getConfiguration();
        this.lang = controller.getExecutable().getHostLanguage();
        this.t_total = System.nanoTime();
    }

    @Override
    public void close() {
        this.t_total = System.nanoTime() - this.t_total;
        ++this.repeat;
        try {
            PreparedStylesheet sheet = this.getStyleSheet();
            XsltController controller = sheet.newController();
            SerializationProperties props = new SerializationProperties();
            props.setProperty("method", "html");
            props.setProperty("indent", "yes");
            controller.setTraceListener(null);
            TransformerReceiver tr = new TransformerReceiver(controller);
            controller.initializeController(new GlobalParameterSet());
            tr.open();
            Receiver result = this.config.getSerializerFactory().getReceiver((Result)this.out.asStreamResult(), props, controller.makePipelineConfiguration());
            tr.setDestination(result);
            StreamWriterToReceiver writer = new StreamWriterToReceiver(tr);
            writer.writeStartDocument();
            writer.writeStartElement("trace");
            writer.writeAttribute("t-total", Double.toString((double)this.t_total / 1000000.0));
            for (InstructionDetails ins : this.instructMap.values()) {
                writer.writeStartElement("fn");
                String name = "UNKNOWN";
                if (ins.instruct.getObjectName() != null) {
                    name = ins.instruct.getObjectName().getDisplayName();
                    writer.writeAttribute("name", name);
                } else if (ins.instruct.getProperty("name") != null) {
                    name = ins.instruct.getProperty("name").toString();
                    writer.writeAttribute("name", name);
                }
                if (ins.instruct.getProperty("match") != null) {
                    name = ins.instruct.getProperty("match").toString();
                    writer.writeAttribute("match", name);
                }
                if (ins.instruct.getProperty("mode") != null) {
                    name = ins.instruct.getProperty("mode").toString();
                    writer.writeAttribute("mode", name);
                }
                writer.writeAttribute("construct", ins.instruct.getConstructType() == 158 ? "function" : (ins.instruct.getConstructType() == 206 ? "variable" : "template"));
                String file = ins.instruct.getSystemId();
                if (file != null) {
                    writer.writeAttribute("file", file);
                }
                writer.writeAttribute("count", Long.toString(ins.count / (long)this.repeat));
                writer.writeAttribute("t-sum-net", Double.toString((double)ins.net / (double)this.repeat / 1000000.0));
                writer.writeAttribute("t-avg-net", Double.toString((double)ins.net / (double)ins.count / 1000000.0));
                writer.writeAttribute("t-sum", Double.toString((double)ins.gross / (double)this.repeat / 1000000.0));
                writer.writeAttribute("t-avg", Double.toString((double)ins.gross / (double)ins.count / 1000000.0));
                writer.writeAttribute("line", Long.toString(ins.instruct.getLineNumber()));
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (TransformerException e2) {
            System.err.println("Unable to transform timing profile information: " + e2.getMessage());
        }
        catch (XMLStreamException e3) {
            System.err.println("Unable to generate timing profile information: " + e3.getMessage());
        }
    }

    @Override
    public void enter(InstructionInfo instruction, XPathContext context) {
        int loc = instruction.getConstructType();
        if (loc == 158 || loc == 200 || loc == 206) {
            long start = System.nanoTime();
            InstructionDetails instructDetails = new InstructionDetails();
            instructDetails.instruct = instruction;
            instructDetails.gross = start;
            this.instructs.add(instructDetails);
            this.instructStack[this.stackDepth++] = instruction;
        }
    }

    @Override
    public void leave(InstructionInfo instruction) {
        int loc = instruction.getConstructType();
        if (loc == 158 || loc == 200 || loc == 206) {
            InstructionDetails instruct = this.instructs.peek();
            long duration = System.nanoTime() - instruct.gross;
            instruct.net = duration - instruct.net;
            instruct.gross = duration;
            InstructionDetails foundInstructDetails = this.instructMap.get(instruction);
            if (foundInstructDetails == null) {
                instruct.count = 1L;
                this.instructMap.put(instruction, instruct);
                --this.stackDepth;
            } else {
                ++foundInstructDetails.count;
                boolean inStack = false;
                for (int i = 0; i < this.stackDepth - 1; ++i) {
                    if (this.instructStack[i] != instruction) continue;
                    inStack = true;
                    break;
                }
                --this.stackDepth;
                if (!inStack) {
                    foundInstructDetails.gross += instruct.gross;
                }
                foundInstructDetails.net += instruct.net;
            }
            this.instructs.pop();
            if (!this.instructs.isEmpty()) {
                InstructionDetails parentInstruct = this.instructs.peek();
                parentInstruct.net += duration;
            }
        }
    }

    @Override
    public void startCurrentItem(Item item) {
    }

    @Override
    public void endCurrentItem(Item item) {
    }

    protected PreparedStylesheet getStyleSheet() throws XPathException {
        InputStream in = this.getStylesheetInputStream();
        StreamSource ss = new StreamSource(in, "profile.xsl");
        CompilerInfo info = this.config.getDefaultXsltCompilerInfo();
        info.setParameter(new StructuredQName("", "", "lang"), new StringValue(this.lang == 50 ? "XSLT" : "XQuery"));
        return Compilation.compileSingletonPackage(this.config, info, ss);
    }

    protected InputStream getStylesheetInputStream() {
        ArrayList<String> messages = new ArrayList<String>();
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        return Configuration.locateResource("profile.xsl", messages, classLoaders);
    }

    private static class InstructionDetails {
        public InstructionInfo instruct;
        public long gross;
        public long net;
        public long count;

        private InstructionDetails() {
        }
    }
}

