/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.shared.Lock;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.system.Txn;

public class DatasetGraphWrapper
implements DatasetGraph,
Sync {
    private final DatasetGraph dsg;

    public final DatasetGraph getWrapped() {
        return this.get();
    }

    public final DatasetGraph getBase() {
        DatasetGraph dsgw = this.dsg;
        while (dsgw instanceof DatasetGraphWrapper) {
            dsgw = ((DatasetGraphWrapper)this.dsg).getWrapped();
        }
        return dsgw;
    }

    protected DatasetGraph get() {
        return this.dsg;
    }

    protected DatasetGraph getR() {
        return this.get();
    }

    protected DatasetGraph getW() {
        return this.get();
    }

    protected DatasetGraph getG() {
        return this.get();
    }

    protected DatasetGraph getT() {
        return this.get();
    }

    public DatasetGraphWrapper(DatasetGraph dsg) {
        this.dsg = dsg;
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        return this.getR().containsGraph(graphNode);
    }

    @Override
    public Graph getDefaultGraph() {
        return this.getG().getDefaultGraph();
    }

    @Override
    public Graph getUnionGraph() {
        return this.getG().getUnionGraph();
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return this.getG().getGraph(graphNode);
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        this.getW().addGraph(graphName, graph);
    }

    @Override
    public void removeGraph(Node graphName) {
        this.getW().removeGraph(graphName);
    }

    @Override
    public void setDefaultGraph(Graph g) {
        this.getW().setDefaultGraph(g);
    }

    @Override
    public Lock getLock() {
        return this.getR().getLock();
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return this.getR().listGraphNodes();
    }

    @Override
    public void add(Quad quad) {
        this.getW().add(quad);
    }

    @Override
    public void delete(Quad quad) {
        this.getW().delete(quad);
    }

    @Override
    public void add(Node g, Node s, Node p, Node o) {
        this.getW().add(g, s, p, o);
    }

    @Override
    public void delete(Node g, Node s, Node p, Node o) {
        this.getW().delete(g, s, p, o);
    }

    @Override
    public void deleteAny(Node g, Node s, Node p, Node o) {
        this.getW().deleteAny(g, s, p, o);
    }

    @Override
    public void clear() {
        this.getW().clear();
    }

    @Override
    public boolean isEmpty() {
        return this.getR().isEmpty();
    }

    @Override
    public Iterator<Quad> find() {
        return this.getR().find();
    }

    @Override
    public Iterator<Quad> find(Quad quad) {
        return this.getR().find(quad);
    }

    @Override
    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        return this.getR().find(g, s, p, o);
    }

    @Override
    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        return this.getR().findNG(g, s, p, o);
    }

    @Override
    public boolean contains(Quad quad) {
        return this.getR().contains(quad);
    }

    @Override
    public boolean contains(Node g, Node s, Node p, Node o) {
        return this.getR().contains(g, s, p, o);
    }

    @Override
    public Context getContext() {
        return this.getR().getContext();
    }

    @Override
    public long size() {
        return this.getR().size();
    }

    @Override
    public void close() {
        this.getW().close();
    }

    public String toString() {
        DatasetGraph dsg = this.getR();
        return Txn.calculateRead(dsg, () -> dsg.toString());
    }

    @Override
    public void sync() {
        SystemARQ.sync(this.getW());
    }

    @Override
    public void begin() {
        this.getT().begin();
    }

    @Override
    public ReadWrite transactionMode() {
        return this.getT().transactionMode();
    }

    @Override
    public TxnType transactionType() {
        return this.getT().transactionType();
    }

    @Override
    public void begin(TxnType type) {
        this.getT().begin(type);
    }

    @Override
    public void begin(ReadWrite readWrite) {
        this.getT().begin(readWrite);
    }

    @Override
    public boolean promote() {
        return this.getT().promote();
    }

    @Override
    public boolean promote(Transactional.Promote type) {
        return this.getT().promote(type);
    }

    @Override
    public void commit() {
        this.getT().commit();
    }

    @Override
    public void abort() {
        this.getT().abort();
    }

    @Override
    public void end() {
        this.getT().end();
    }

    @Override
    public boolean isInTransaction() {
        return this.get().isInTransaction();
    }

    @Override
    public boolean supportsTransactions() {
        return this.getT().supportsTransactions();
    }

    @Override
    public boolean supportsTransactionAbort() {
        return this.getT().supportsTransactionAbort();
    }
}

