/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.base.file;

import java.nio.ByteBuffer;
import org.apache.jena.tdb.base.block.Block;
import org.apache.jena.tdb.base.file.BlockAccess;
import org.apache.jena.tdb.base.file.FileException;

public class BlockAccessByteArray
implements BlockAccess {
    private ByteBuffer bytes = ByteBuffer.allocate(1024);
    private long length = 0L;
    private long alloc = 0L;
    private final String label;

    public BlockAccessByteArray(String label) {
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Block allocate(int size) {
        long addr = this.alloc;
        ByteBuffer bb = ByteBuffer.allocate(size);
        this.alloc += (long)(size + 4);
        return new Block((int)addr, bb);
    }

    @Override
    public Block read(long id) {
        if (id < 0L || id >= this.length || id >= (long)this.bytes.capacity()) {
            throw new FileException("Bad id (read): " + id);
        }
        this.bytes.position((int)id);
        int len = this.bytes.getInt();
        ByteBuffer bb = ByteBuffer.allocate(len);
        this.bytes.get(bb.array(), 0, len);
        return new Block(id, bb);
    }

    @Override
    public void write(Block block) {
        long loc = block.getId();
        if (loc < 0L || loc > this.length) {
            throw new FileException("Bad id (write): " + loc + " (" + this.alloc + "," + this.length + ")");
        }
        ByteBuffer bb = block.getByteBuffer();
        int len = bb.capacity();
        if (loc == this.length) {
            if ((long)this.bytes.capacity() - this.length < (long)len) {
                int cap2 = this.bytes.capacity() + 1024;
                while ((long)this.bytes.capacity() - this.length < (long)len) {
                    cap2 += 1024;
                }
                ByteBuffer bytes2 = ByteBuffer.allocate(cap2);
                bytes2.position(0);
                bytes2.put(this.bytes);
            }
            this.length += (long)(len + 4);
        }
        this.bytes.position((int)loc);
        this.bytes.putInt(len);
        this.bytes.put(bb.array(), 0, bb.capacity());
    }

    @Override
    public void overwrite(Block block) {
        this.write(block);
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0L;
    }

    @Override
    public boolean valid(long id) {
        return id >= 0L && id < this.length;
    }

    @Override
    public void sync() {
    }

    @Override
    public void close() {
    }
}

