/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrClientCache
implements Serializable {
    protected static final Logger log = LoggerFactory.getLogger(SolrClientCache.class);
    private Map<String, SolrClient> solrClients = new HashMap<String, SolrClient>();

    public synchronized CloudSolrClient getCloudSolrClient(String zkHost) {
        CloudSolrClient client = null;
        if (this.solrClients.containsKey(zkHost)) {
            client = (CloudSolrClient)this.solrClients.get(zkHost);
        } else {
            client = new CloudSolrClient(zkHost);
            client.connect();
            this.solrClients.put(zkHost, client);
        }
        return client;
    }

    public synchronized HttpSolrClient getHttpSolrClient(String host) {
        HttpSolrClient client = null;
        if (this.solrClients.containsKey(host)) {
            client = (HttpSolrClient)this.solrClients.get(host);
        } else {
            client = new HttpSolrClient(host);
            this.solrClients.put(host, client);
        }
        return client;
    }

    public void close() {
        Iterator<SolrClient> it = this.solrClients.values().iterator();
        while (it.hasNext()) {
            try {
                it.next().close();
            }
            catch (IOException e2) {
                log.error(e2.getMessage(), e2);
            }
        }
    }
}

