/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.util.Vector;

class DTLSReassembler {
    private final short msg_type;
    private final byte[] body;
    private Vector missing = new Vector();

    DTLSReassembler(short s, int n) {
        this.msg_type = s;
        this.body = new byte[n];
        this.missing.addElement(new Range(0, n));
    }

    short getMsgType() {
        return this.msg_type;
    }

    byte[] getBodyIfComplete() {
        return this.missing.isEmpty() ? this.body : null;
    }

    void contributeFragment(short s, int n, byte[] byArray, int n2, int n4, int n5) {
        Range range;
        int n6 = n4 + n5;
        if (this.msg_type != s || this.body.length != n || n6 > n) {
            return;
        }
        if (n5 == 0) {
            Range range2;
            if (n4 == 0 && !this.missing.isEmpty() && (range2 = (Range)this.missing.firstElement()).getEnd() == 0) {
                this.missing.removeElementAt(0);
            }
            return;
        }
        for (int i = 0; i < this.missing.size() && (range = (Range)this.missing.elementAt(i)).getStart() < n6; ++i) {
            if (range.getEnd() <= n4) continue;
            int n7 = Math.max(range.getStart(), n4);
            int n8 = Math.min(range.getEnd(), n6);
            int n9 = n8 - n7;
            System.arraycopy(byArray, n2 + n7 - n4, this.body, n7, n9);
            if (n7 == range.getStart()) {
                if (n8 == range.getEnd()) {
                    this.missing.removeElementAt(i--);
                    continue;
                }
                range.setStart(n8);
                continue;
            }
            if (n8 != range.getEnd()) {
                this.missing.insertElementAt(new Range(n8, range.getEnd()), ++i);
            }
            range.setEnd(n7);
        }
    }

    void reset() {
        this.missing.removeAllElements();
        this.missing.addElement(new Range(0, this.body.length));
    }

    private static class Range {
        private int start;
        private int end;

        Range(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int n) {
            this.start = n;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int n) {
            this.end = n;
        }
    }
}

