/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.EncoderException;
import org.apache.log4j.Logger;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.index.processor.IndexTaskDeleteProcessor;
import org.dataone.cn.index.task.IndexTask;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.cn.indexer.D1IndexerSolrClient;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.parser.SubprocessorUtility;
import org.dataone.cn.indexer.parser.utility.SeriesIdResolver;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.dataone.ore.ResourceMapFactory;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.TypeFactory;
import org.dataone.service.types.v2.SystemMetadata;
import org.dspace.foresite.OREParserException;
import org.springframework.beans.factory.annotation.Autowired;

public class ResourceMapSubprocessor
implements IDocumentSubprocessor {
    private static Logger logger = Logger.getLogger(ResourceMapSubprocessor.class.getName());
    @Autowired
    private D1IndexerSolrClient d1IndexerSolrClient = null;
    @Autowired
    private String solrQueryUri = null;
    @Autowired
    private IndexTaskDeleteProcessor deleteProcessor;
    @Autowired
    private SubprocessorUtility processorUtility;
    private PerformanceLogger perfLog = PerformanceLogger.getInstance();
    private List<String> matchDocuments = null;
    private List<String> fieldsToMerge = new ArrayList<String>();

    @Override
    public SolrDoc mergeWithIndexedDocument(SolrDoc indexDocument) throws IOException, EncoderException, XPathExpressionException {
        return this.processorUtility.mergeWithIndexedDocument(indexDocument, this.fieldsToMerge);
    }

    @Override
    public Map<String, SolrDoc> processDocument(String identifier, Map<String, SolrDoc> docs, InputStream is) throws XPathExpressionException, IOException, EncoderException {
        SolrDoc resourceMapSolrDoc = docs.get(identifier);
        List<Object> processedDocs = new ArrayList();
        try {
            long procResMapStart = System.currentTimeMillis();
            processedDocs = this.processResourceMap(resourceMapSolrDoc, is);
            this.perfLog.log("ResourceMapSubprocessor.processDocument() for id " + identifier, System.currentTimeMillis() - procResMapStart);
        }
        catch (OREParserException oreException) {
            logger.error("Unable to parse resource map: " + identifier + ".  Unrecoverable parse exception:  task will not be re-tried.");
        }
        HashMap<String, SolrDoc> processedDocsMap = new HashMap<String, SolrDoc>();
        for (SolrDoc solrDoc : processedDocs) {
            processedDocsMap.put(solrDoc.getIdentifier(), solrDoc);
        }
        return processedDocsMap;
    }

    protected List<SolrDoc> processResourceMap(SolrDoc indexDocument, InputStream resourceMapStream) throws OREParserException, XPathExpressionException, IOException, EncoderException {
        long buildResMapStart = System.currentTimeMillis();
        Map<Identifier, Map<Identifier, List<Identifier>>> tmpResourceMap = null;
        try {
            tmpResourceMap = ResourceMapFactory.getInstance().parseResourceMap(resourceMapStream);
        }
        catch (Throwable e2) {
            logger.error("Unable to parse ORE document:", e2);
            throw new OREParserException(e2);
        }
        this.perfLog.log("ResourceMapFactory.buildResourceMap() create ResourceMap from InputStream", System.currentTimeMillis() - buildResMapStart);
        HashMap<Identifier, SolrDoc> memberDocs = new HashMap<Identifier, SolrDoc>();
        Map.Entry<Identifier, Map<Identifier, List<Identifier>>> resMapHierarchy = tmpResourceMap.entrySet().iterator().next();
        String resourceMapId = resMapHierarchy.getKey().getValue();
        Map<Identifier, List<Identifier>> metadataMap = resMapHierarchy.getValue();
        for (Identifier mdId : metadataMap.keySet()) {
            if (!memberDocs.containsKey(mdId)) {
                memberDocs.put(mdId, new SolrDoc());
                ((SolrDoc)memberDocs.get(mdId)).addField(new SolrElementField("id", mdId.getValue()));
                ((SolrDoc)memberDocs.get(mdId)).addField(new SolrElementField("resourceMap", resourceMapId));
            }
            for (Identifier dataId : metadataMap.get(mdId)) {
                if (!memberDocs.containsKey(dataId)) {
                    memberDocs.put(dataId, new SolrDoc());
                    ((SolrDoc)memberDocs.get(dataId)).addField(new SolrElementField("id", dataId.getValue()));
                    ((SolrDoc)memberDocs.get(dataId)).addField(new SolrElementField("resourceMap", resourceMapId));
                }
                ((SolrDoc)memberDocs.get(dataId)).addField(new SolrElementField("isDocumentedBy", mdId.getValue()));
                ((SolrDoc)memberDocs.get(mdId)).addField(new SolrElementField("documents", dataId.getValue()));
            }
        }
        ArrayList<SolrDoc> allMembers = new ArrayList<SolrDoc>();
        allMembers.add(indexDocument);
        allMembers.addAll(memberDocs.values());
        return allMembers;
    }

    private void clearObsoletesChain(String resourceMapIdentifier, List<String> memberIds) {
        boolean memberListContainsSeriesId = false;
        for (String memberId : memberIds) {
            Identifier relatedPid = new Identifier();
            relatedPid.setValue(memberId);
            if (!SeriesIdResolver.isSeriesId(relatedPid)) continue;
            memberListContainsSeriesId = true;
            break;
        }
        if (memberListContainsSeriesId) {
            Identifier pidToProcess = TypeFactory.buildIdentifier(resourceMapIdentifier);
            while (pidToProcess != null) {
                SystemMetadata sysmeta = HazelcastClientFactory.getSystemMetadataMap().get(pidToProcess);
                if (sysmeta != null) {
                    String objectPath = HazelcastClientFactory.getObjectPathMap().get(pidToProcess);
                    logger.debug("Removing pidToProcess===" + pidToProcess.getValue());
                    logger.debug("Removing objectPath===" + objectPath);
                    IndexTask task = new IndexTask(sysmeta, objectPath);
                    try {
                        this.deleteProcessor.process(task);
                    }
                    catch (Exception e2) {
                        logger.error(e2.getMessage(), e2);
                    }
                    pidToProcess = sysmeta.getObsoletes();
                    continue;
                }
                pidToProcess = null;
            }
        }
    }

    public List<String> getMatchDocuments() {
        return this.matchDocuments;
    }

    public void setMatchDocuments(List<String> matchDocuments) {
        this.matchDocuments = matchDocuments;
    }

    @Override
    public boolean canProcess(String formatId) {
        return this.matchDocuments.contains(formatId);
    }

    public List<String> getFieldsToMerge() {
        return this.fieldsToMerge;
    }

    public void setFieldsToMerge(List<String> fieldsToMerge) {
        this.fieldsToMerge = fieldsToMerge;
    }
}

