/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser.utility;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.dataone.cn.indexer.parser.utility.FilterProcessor;
import org.dataone.cn.indexer.parser.utility.LeafElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FilterRootElement {
    private String name;
    private String xPath;
    private XPathExpression xPathExpression = null;
    private String delimiter = " ";
    private List<LeafElement> leafs = new ArrayList<LeafElement>();
    private List<FilterRootElement> subRoots = new ArrayList<FilterRootElement>();
    private List<FilterProcessor> filters = null;
    private String prefixMatch = null;
    private String fixedTerm = null;
    private String postfixMatch = null;

    public String getRootValues(Object docOrNode) throws XPathExpressionException {
        NodeList nodeList = (NodeList)this.getxPathExpression().evaluate(docOrNode, XPathConstants.NODESET);
        String prefilterValue = null;
        String postfilterValue = null;
        String filterValue = null;
        List<FilterProcessor> filters = this.getFilters();
        this.prefixMatch = this.getPrefixMatch();
        this.fixedTerm = this.getFixedTerm();
        this.postfixMatch = this.getPostfixMatch();
        HashSet<String> prefixMatchingFields = new HashSet<String>();
        if (this.prefixMatch != null && !this.prefixMatch.isEmpty()) {
            String[] tokens;
            for (String token : tokens = this.prefixMatch.split(",")) {
                prefixMatchingFields.add(token);
            }
        }
        HashSet<String> postfixMatchingFields = new HashSet<String>();
        if (this.postfixMatch != null && !this.postfixMatch.isEmpty()) {
            String[] tokens;
            for (String token : tokens = this.postfixMatch.split(",")) {
                postfixMatchingFields.add(token);
            }
        }
        String mainFilterValue = null;
        String completeFilterValue = null;
        String operator = "AND";
        int nFilters = filters.size();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Matcher m1;
            Pattern p;
            Node node = nodeList.item(i);
            for (FilterProcessor filterProcessor : filters) {
                if (!node.getNodeName().equalsIgnoreCase(filterProcessor.getMatchElement())) continue;
                filterProcessor.initXPathExpressions();
                filterValue = filterProcessor.getFilterValue(node);
                break;
            }
            if (filterValue == null) continue;
            Boolean prefilter = false;
            Boolean postfilter = false;
            if (!prefixMatchingFields.isEmpty()) {
                for (String term : prefixMatchingFields) {
                    p = Pattern.compile("[(-]" + term + ":|^" + term + ":");
                    m1 = null;
                    m1 = p.matcher(filterValue);
                    if (!m1.find()) continue;
                    prefilter = true;
                    if (prefilterValue == null) {
                        prefilterValue = filterValue;
                        continue;
                    }
                    prefilterValue = prefilterValue + " OR " + filterValue;
                }
            }
            if (!postfixMatchingFields.isEmpty()) {
                for (String term : postfixMatchingFields) {
                    p = Pattern.compile("[(-]" + term + ":|^" + term + ":");
                    m1 = null;
                    m1 = p.matcher(filterValue);
                    if (!m1.find()) continue;
                    postfilter = true;
                    if (postfilterValue == null) {
                        postfilterValue = filterValue;
                        continue;
                    }
                    postfilterValue = postfilterValue + " OR " + filterValue;
                }
            }
            if (prefilter.booleanValue() || postfilter.booleanValue()) continue;
            mainFilterValue = mainFilterValue == null ? filterValue : mainFilterValue + " " + operator + " " + filterValue;
        }
        if (prefilterValue != null) {
            completeFilterValue = "(" + prefilterValue + ")";
        }
        if (mainFilterValue != null) {
            completeFilterValue = completeFilterValue != null ? "(" + completeFilterValue + " OR (" + mainFilterValue + "))" : "(" + mainFilterValue + ")";
        }
        if ((prefilterValue != null || mainFilterValue != null) && this.fixedTerm != null) {
            completeFilterValue = completeFilterValue != null ? "(" + completeFilterValue + " AND " + this.fixedTerm + ")" : "(" + this.fixedTerm + ")";
        }
        if (postfilterValue != null && !postfilterValue.isEmpty()) {
            completeFilterValue = completeFilterValue != null ? completeFilterValue + " OR (" + postfilterValue + ")" : postfilterValue;
        }
        if (completeFilterValue == null) {
            completeFilterValue = "(id:*)";
        }
        completeFilterValue = "(" + completeFilterValue + ")";
        return completeFilterValue;
    }

    public void initXPathExpressions(XPath xPathObject) {
        try {
            if (this.xPathExpression == null) {
                this.xPathExpression = xPathObject.compile(this.xPath);
            }
            for (LeafElement leaf : this.leafs) {
                leaf.initXPathExpression(xPathObject);
            }
            for (FilterRootElement subRoot : this.subRoots) {
                subRoot.initXPathExpressions(xPathObject);
            }
        }
        catch (XPathExpressionException e2) {
            e2.printStackTrace();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getxPath() {
        return this.xPath;
    }

    public void setxPath(String xPath) {
        this.xPath = xPath;
    }

    public XPathExpression getxPathExpression() {
        return this.xPathExpression;
    }

    public void setxPathExpression(XPathExpression xPathExpression) {
        this.xPathExpression = xPathExpression;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getPrefixMatch() {
        return this.prefixMatch;
    }

    public void setPrefixMatch(String prefixMatch) {
        this.prefixMatch = prefixMatch;
    }

    public String getFixedTerm() {
        return this.fixedTerm;
    }

    public void setFixedTerm(String fixedTerm) {
        this.fixedTerm = fixedTerm;
    }

    public String getPostfixMatch() {
        return this.postfixMatch;
    }

    public void setPostfixMatch(String postfixMatch) {
        this.postfixMatch = postfixMatch;
    }

    public List<LeafElement> getLeafs() {
        return this.leafs;
    }

    public void setLeafs(List<LeafElement> leafs) {
        this.leafs = leafs;
    }

    public List<FilterRootElement> getSubRoots() {
        return this.subRoots;
    }

    public void setSubRoots(List<FilterRootElement> subRoots) {
        this.subRoots = subRoots;
    }

    public List<FilterProcessor> getFilters() {
        return this.filters;
    }

    public void setFilters(List<FilterProcessor> filters) {
        this.filters = filters;
    }
}

