/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.solrhttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.log4j.Logger;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementAdd;

class OutputStreamHttpEntity
implements HttpEntity {
    private static Logger log = Logger.getLogger(OutputStreamHttpEntity.class);
    private Header contentType;
    private SolrElementAdd add = null;
    private String encoding = "UTF-8";

    public OutputStreamHttpEntity(List<SolrDoc> add, String encoding) {
        this.add = new SolrElementAdd(add);
        this.encoding = encoding;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public Header getContentType() {
        return this.contentType;
    }

    @Override
    public Header getContentEncoding() {
        return new BasicHeader("Content-Type", "text/xml; charset=" + this.encoding + "");
    }

    @Override
    public InputStream getContent() throws IOException, IllegalStateException {
        throw new Error("MethodNotImplemented");
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        log.info("Creating HTTP Output Stream for " + this.add.getDocList().size() + " docs: ");
        this.add.serialize(outputStream, this.encoding);
        outputStream.flush();
        outputStream.close();
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @Override
    public void consumeContent() throws IOException {
    }

    public void setContentType(Header contentType) {
        this.contentType = contentType;
    }
}

