/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.ldap;

import java.util.Date;
import java.util.NoSuchElementException;
import javax.naming.directory.DirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.DefaultPooledObjectInfo;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.dataone.cn.ldap.DirContextPooledObjectFactory;
import org.dataone.configuration.Settings;

public class DirContextProvider {
    public static Log log = LogFactory.getLog(DirContextProvider.class);
    private static boolean BLOCK_WHEN_EXHAUSTED = Settings.getConfiguration().getBoolean("cn.ldap.pool.block_when_exhausted", true);
    private static long MAX_WAIT_MILLIS = Settings.getConfiguration().getLong("cn.ldap.pool.max_wait_millis", 2000L);
    private static long MIN_EVICTABLE_IDLE_TIME_MILLIS = Settings.getConfiguration().getLong("cn.ldap.pool.min_evictable_idle_time_millis", -1L);
    private static long TIME_BETWEEN_EVICTION_RUNS_MILLIS = Settings.getConfiguration().getLong("cn.ldap.pool.time_between_eviction_runs_millis", 300000L);
    private static int MAX_TOTAL_POOL_OBJECTS = Settings.getConfiguration().getInt("cn.ldap.pool.max_total", 20);
    private static int MAX_IDLE_POOL_OBJECTS = Settings.getConfiguration().getInt("cn.ldap.pool.max_idle", 2);
    private static int MIN_IDLE_POOL_OBJECTS = Settings.getConfiguration().getInt("cn.ldap.pool.min_idle", 0);
    private static final long serialVersionUID = 1L;
    private GenericObjectPool<DirContext> dirContextPool;
    private static volatile DirContextProvider dirContextPoolProvider;

    private DirContextProvider() {
        DirContextPooledObjectFactory dirContextPooledObjectFactory = new DirContextPooledObjectFactory();
        GenericObjectPoolConfig conf = new GenericObjectPoolConfig();
        conf.setBlockWhenExhausted(BLOCK_WHEN_EXHAUSTED);
        conf.setMaxWaitMillis(MAX_WAIT_MILLIS);
        conf.setMinEvictableIdleTimeMillis(MIN_EVICTABLE_IDLE_TIME_MILLIS);
        conf.setSoftMinEvictableIdleTimeMillis(MIN_EVICTABLE_IDLE_TIME_MILLIS);
        conf.setTimeBetweenEvictionRunsMillis(TIME_BETWEEN_EVICTION_RUNS_MILLIS);
        conf.setEvictionPolicyClassName("org.apache.commons.pool2.impl.DefaultEvictionPolicy");
        conf.setMaxTotal(MAX_TOTAL_POOL_OBJECTS);
        conf.setMaxIdle(MAX_IDLE_POOL_OBJECTS);
        conf.setMinIdle(MIN_IDLE_POOL_OBJECTS);
        conf.setTestWhileIdle(true);
        conf.setTestOnReturn(false);
        conf.setTestOnBorrow(true);
        this.dirContextPool = new GenericObjectPool<DirContext>(dirContextPooledObjectFactory, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DirContextProvider getInstance() {
        if (dirContextPoolProvider != null) return dirContextPoolProvider;
        Class<DirContextProvider> clazz = DirContextProvider.class;
        synchronized (DirContextProvider.class) {
            if (dirContextPoolProvider != null) return dirContextPoolProvider;
            dirContextPoolProvider = new DirContextProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dirContextPoolProvider;
        }
    }

    public DirContext borrowDirContext() throws NoSuchElementException, Exception {
        return this.dirContextPool.borrowObject();
    }

    public void returnDirContext(DirContext context) {
        Date date2;
        Date borrowedDate;
        for (DefaultPooledObjectInfo defaultPooledObject : this.dirContextPool.listAllObjects()) {
            borrowedDate = new Date(defaultPooledObject.getLastBorrowTime());
            date2 = new Date(defaultPooledObject.getLastReturnTime());
        }
        this.dirContextPool.returnObject(context);
        for (DefaultPooledObjectInfo defaultPooledObject : this.dirContextPool.listAllObjects()) {
            borrowedDate = new Date(defaultPooledObject.getLastBorrowTime());
            date2 = new Date(defaultPooledObject.getLastReturnTime());
        }
    }

    public int getNumDirContextActive() {
        return this.dirContextPool.getNumActive();
    }

    public int getNumDirContextIdle() {
        return this.dirContextPool.getNumIdle();
    }

    private DirContextProvider readResolve() {
        return dirContextPoolProvider;
    }
}

