/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.HibernateException;
import org.hibernate.type.LobType;
import org.hibernate.type.descriptor.sql.BlobTypeDescriptor;
import org.hibernate.type.descriptor.sql.ClobTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AlternativeLobTypes<S, T extends LobType<S>>
implements Serializable {
    private final T defaultType;
    private final T streamBindingType;
    private final T lobBindingType;

    private AlternativeLobTypes(Class<? extends T> clazz, SqlTypeDescriptor defaultDescriptor, SqlTypeDescriptor streamBindingDescriptor, SqlTypeDescriptor lobBindingDescriptor) {
        Constructor constructor = this.getConstructor(clazz);
        this.defaultType = this.createLobType(clazz, constructor, defaultDescriptor);
        this.streamBindingType = this.createLobType(clazz, constructor, streamBindingDescriptor);
        this.lobBindingType = this.createLobType(clazz, constructor, lobBindingDescriptor);
    }

    public final T getDefaultType() {
        return this.defaultType;
    }

    public final T getStreamBindingType() {
        return this.streamBindingType;
    }

    public final T getLobBindingType() {
        return this.lobBindingType;
    }

    protected Constructor getConstructor(Class<? extends T> clazz) {
        try {
            return clazz.getDeclaredConstructor(SqlTypeDescriptor.class, this.getClass());
        }
        catch (NoSuchMethodException e2) {
            throw new HibernateException("Could not get constructor for " + clazz.getClass().getName() + " with argument types: [" + SqlTypeDescriptor.class.getName() + ", " + this.getClass().getName() + "]", e2);
        }
    }

    protected T createLobType(Class<? extends T> lobTypeClass, Constructor constructor, SqlTypeDescriptor sqlTypeDescriptor) {
        try {
            return (T)((LobType)lobTypeClass.cast(constructor.newInstance(sqlTypeDescriptor, this)));
        }
        catch (InstantiationException e2) {
            throw new HibernateException("Cannot instantiate type: " + lobTypeClass.getName());
        }
        catch (IllegalAccessException e3) {
            throw new HibernateException("IllegalAccessException trying to instantiate: " + lobTypeClass.getName());
        }
        catch (InvocationTargetException e4) {
            throw new HibernateException("Could not create type: " + lobTypeClass.getName(), e4.getCause());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BlobTypes<S, T extends LobType<S>>
    extends AlternativeLobTypes<S, T> {
        private final T primitiveArrayBindingType;

        BlobTypes(Class<? extends T> blobTypeClass) {
            super(blobTypeClass, BlobTypeDescriptor.DEFAULT, BlobTypeDescriptor.STREAM_BINDING, BlobTypeDescriptor.BLOB_BINDING);
            Constructor constructor = this.getConstructor(blobTypeClass);
            this.primitiveArrayBindingType = this.createLobType(blobTypeClass, constructor, BlobTypeDescriptor.PRIMITIVE_ARRAY_BINDING);
        }

        public final T getPrimitiveArrayBindingType() {
            return this.primitiveArrayBindingType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClobTypes<S, T extends LobType<S>>
    extends AlternativeLobTypes<S, T> {
        ClobTypes(Class<? extends T> clobTypeClass) {
            super(clobTypeClass, ClobTypeDescriptor.DEFAULT, ClobTypeDescriptor.STREAM_BINDING, ClobTypeDescriptor.CLOB_BINDING);
        }
    }
}

