/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Comparator;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.BlobProxy;
import org.hibernate.engine.jdbc.WrappedBlob;
import org.hibernate.type.descriptor.BinaryStream;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.BinaryStreamImpl;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.IncomparableComparator;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlobTypeDescriptor
extends AbstractTypeDescriptor<Blob> {
    public static final BlobTypeDescriptor INSTANCE = new BlobTypeDescriptor();

    public BlobTypeDescriptor() {
        super(Blob.class, BlobMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(Blob value) {
        byte[] bytes;
        try {
            bytes = DataHelper.extractBytes(value.getBinaryStream());
        }
        catch (SQLException e2) {
            throw new HibernateException("Unable to access blob stream", e2);
        }
        return PrimitiveByteArrayTypeDescriptor.INSTANCE.toString(bytes);
    }

    @Override
    public Blob fromString(String string) {
        return BlobProxy.generateProxy(PrimitiveByteArrayTypeDescriptor.INSTANCE.fromString(string));
    }

    @Override
    public Comparator<Blob> getComparator() {
        return IncomparableComparator.INSTANCE;
    }

    @Override
    public int extractHashCode(Blob value) {
        return System.identityHashCode(value);
    }

    @Override
    public boolean areEqual(Blob one, Blob another) {
        return one == another;
    }

    @Override
    public <X> X unwrap(Blob value, Class<X> type, WrapperOptions options) {
        if (!Blob.class.isAssignableFrom(type) && !BinaryStream.class.isAssignableFrom(type)) {
            throw this.unknownUnwrap(type);
        }
        if (value == null) {
            return null;
        }
        if (BinaryStream.class.isAssignableFrom(type)) {
            try {
                return (X)new BinaryStreamImpl(DataHelper.extractBytes(value.getBinaryStream()));
            }
            catch (SQLException e2) {
                throw new HibernateException("Unable to access blob stream", e2);
            }
        }
        Blob blob = WrappedBlob.class.isInstance(value) ? ((WrappedBlob)((Object)value)).getWrappedBlob() : value;
        return (X)blob;
    }

    @Override
    public <X> Blob wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (!Blob.class.isAssignableFrom(value.getClass())) {
            throw this.unknownWrap(value.getClass());
        }
        return options.getLobCreator().wrap((Blob)value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BlobMutabilityPlan
    implements MutabilityPlan<Blob> {
        public static final BlobMutabilityPlan INSTANCE = new BlobMutabilityPlan();

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public Blob deepCopy(Blob value) {
            return value;
        }

        @Override
        public Serializable disassemble(Blob value) {
            throw new UnsupportedOperationException("Blobs are not cacheable");
        }

        @Override
        public Blob assemble(Serializable cached) {
            throw new UnsupportedOperationException("Blobs are not cacheable");
        }
    }
}

