/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.jms;

import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.jobs.ee.jms.JmsHelper;
import org.quartz.jobs.ee.jms.JmsMessageFactory;

public final class SendQueueMessageJob
implements Job {
    public void execute(JobExecutionContext jobCtx) throws JobExecutionException {
        QueueConnection conn = null;
        QueueSession sess = null;
        QueueSender sender = null;
        try {
            JobDataMap dataMap = jobCtx.getMergedJobDataMap();
            InitialContext namingCtx = JmsHelper.getInitialContext(dataMap);
            QueueConnectionFactory connFactory = (QueueConnectionFactory)namingCtx.lookup(dataMap.getString("jms.connection.factory"));
            if (!JmsHelper.isDestinationSecure(dataMap)) {
                conn = connFactory.createQueueConnection();
            } else {
                String user = dataMap.getString("jms.user");
                String password = dataMap.getString("jms.password");
                conn = connFactory.createQueueConnection(user, password);
            }
            boolean useTransactions = JmsHelper.useTransaction(dataMap);
            int ackMode = dataMap.getInt("jms.acknowledge");
            sess = conn.createQueueSession(useTransactions, ackMode);
            Queue queue = (Queue)namingCtx.lookup(dataMap.getString("jms.destination"));
            sender = sess.createSender(queue);
            JmsMessageFactory msgFactory = JmsHelper.getMessageFactory(dataMap.getString("jms.message.factory.class.name"));
            Message msg = msgFactory.createMessage(dataMap, (Session)sess);
            sender.send(msg);
        }
        catch (Exception e2) {
            try {
                throw new JobExecutionException(e2.getMessage());
            }
            catch (Throwable throwable) {
                JmsHelper.closeResource(sender);
                JmsHelper.closeResource(sess);
                JmsHelper.closeResource(conn);
                throw throwable;
            }
        }
        JmsHelper.closeResource(sender);
        JmsHelper.closeResource(sess);
        JmsHelper.closeResource(conn);
    }
}

