/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerMethod {
    protected final Log logger = LogFactory.getLog(HandlerMethod.class);
    private final Object bean;
    private final Method method;
    private final BeanFactory beanFactory;
    private MethodParameter[] parameters;
    private final Method bridgedMethod;

    public HandlerMethod(Object bean, Method method) {
        Assert.notNull(bean, "bean is required");
        Assert.notNull(method, "method is required");
        this.bean = bean;
        this.beanFactory = null;
        this.method = method;
        this.bridgedMethod = BridgeMethodResolver.findBridgedMethod(method);
    }

    public HandlerMethod(Object bean, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Assert.notNull(bean, "bean is required");
        Assert.notNull(methodName, "method is required");
        this.bean = bean;
        this.beanFactory = null;
        this.method = bean.getClass().getMethod(methodName, parameterTypes);
        this.bridgedMethod = BridgeMethodResolver.findBridgedMethod(this.method);
    }

    public HandlerMethod(String beanName, BeanFactory beanFactory, Method method) {
        Assert.hasText(beanName, "beanName is required");
        Assert.notNull(beanFactory, "beanFactory is required");
        Assert.notNull(method, "method is required");
        Assert.isTrue(beanFactory.containsBean(beanName), "Bean factory [" + beanFactory + "] does not contain bean [" + beanName + "]");
        this.bean = beanName;
        this.beanFactory = beanFactory;
        this.method = method;
        this.bridgedMethod = BridgeMethodResolver.findBridgedMethod(method);
    }

    protected HandlerMethod(HandlerMethod handlerMethod) {
        Assert.notNull(handlerMethod, "HandlerMethod is required");
        this.bean = handlerMethod.bean;
        this.beanFactory = handlerMethod.beanFactory;
        this.method = handlerMethod.method;
        this.bridgedMethod = handlerMethod.bridgedMethod;
        this.parameters = handlerMethod.parameters;
    }

    public Object getBean() {
        return this.bean;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getBeanType() {
        Class<?> clazz = this.bean instanceof String ? this.beanFactory.getType((String)this.bean) : this.bean.getClass();
        return ClassUtils.getUserClass(clazz);
    }

    protected Method getBridgedMethod() {
        return this.bridgedMethod;
    }

    public MethodParameter[] getMethodParameters() {
        if (this.parameters == null) {
            int parameterCount = this.bridgedMethod.getParameterTypes().length;
            this.parameters = new MethodParameter[parameterCount];
            int i = 0;
            while (i < parameterCount) {
                this.parameters[i] = new HandlerMethodParameter(i);
                ++i;
            }
        }
        return this.parameters;
    }

    public MethodParameter getReturnType() {
        return new HandlerMethodParameter(-1);
    }

    public MethodParameter getReturnValueType(Object returnValue) {
        return new ReturnValueMethodParameter(returnValue);
    }

    public boolean isVoid() {
        return Void.TYPE.equals(this.getReturnType().getParameterType());
    }

    public <A extends Annotation> A getMethodAnnotation(Class<A> annotationType) {
        return AnnotationUtils.findAnnotation(this.method, annotationType);
    }

    public HandlerMethod createWithResolvedBean() {
        Object handler = this.bean;
        if (this.bean instanceof String) {
            String beanName = (String)this.bean;
            handler = this.beanFactory.getBean(beanName);
        }
        HandlerMethod handlerMethod = new HandlerMethod(handler, this.method);
        handlerMethod.parameters = this.getMethodParameters();
        return handlerMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o instanceof HandlerMethod) {
            HandlerMethod other = (HandlerMethod)o;
            return this.bean.equals(other.bean) && this.method.equals(other.method);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.bean.hashCode() + this.method.hashCode();
    }

    public String toString() {
        return this.method.toGenericString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HandlerMethodParameter
    extends MethodParameter {
        protected HandlerMethodParameter(int index) {
            super(HandlerMethod.this.bridgedMethod, index);
        }

        @Override
        public Class<?> getDeclaringClass() {
            return HandlerMethod.this.getBeanType();
        }

        @Override
        public <T extends Annotation> T getMethodAnnotation(Class<T> annotationType) {
            return HandlerMethod.this.getMethodAnnotation(annotationType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReturnValueMethodParameter
    extends HandlerMethodParameter {
        private final Object returnValue;

        public ReturnValueMethodParameter(Object returnValue) {
            super(-1);
            this.returnValue = returnValue;
        }

        @Override
        public Class<?> getParameterType() {
            return this.returnValue != null ? this.returnValue.getClass() : super.getParameterType();
        }
    }
}

