/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.AbstractRemotelyCallable;
import com.hazelcast.cluster.AbstractRemotelyProcessable;
import com.hazelcast.cluster.AddOrRemoveConnection;
import com.hazelcast.cluster.AuthorizationCall;
import com.hazelcast.cluster.ConnectionCheckCall;
import com.hazelcast.cluster.FinalizeJoin;
import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.cluster.JoinRequest;
import com.hazelcast.cluster.Master;
import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.cluster.MemberRemover;
import com.hazelcast.cluster.MembersUpdateCall;
import com.hazelcast.cluster.RemotelyProcessable;
import com.hazelcast.cluster.SyncProcess;
import com.hazelcast.core.Member;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.FallThroughRunnable;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.MergeClusters;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.NodeType;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.SplitBrainHandler;
import com.hazelcast.impl.base.Call;
import com.hazelcast.impl.base.PacketProcessor;
import com.hazelcast.impl.base.ScheduledAction;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.security.Credentials;
import com.hazelcast.util.Clock;
import com.hazelcast.util.Prioritized;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClusterManager
extends BaseManager
implements ConnectionListener {
    private final long WAIT_MILLIS_BEFORE_JOIN;
    private final long MAX_WAIT_SECONDS_BEFORE_JOIN;
    private final long MAX_NO_HEARTBEAT_MILLIS;
    private final long HEARTBEAT_INTERVAL_MILLIS;
    private final long MAX_NO_MASTER_CONFIRMATION_MILLIS;
    private final long MASTER_CONFIRMATION_INTERVAL_MILLIS;
    private final boolean ICMP_ENABLED;
    private final int ICMP_TTL;
    private final int ICMP_TIMEOUT;
    private final long MEMBER_LIST_PUBLISH_INTERVAL_MILLIS;
    private final Set<ScheduledAction> setScheduledActions = new LinkedHashSet<ScheduledAction>(1000);
    private final Set<MemberInfo> setJoins = new LinkedHashSet<MemberInfo>(100);
    private boolean joinInProgress = false;
    private long timeToStartJoin = 0L;
    private long firstJoinRequest = 0L;
    private long lastHeartbeat = 0L;
    private long lastMasterConfirmation = 0L;
    private long lastMemberListPublish = 0L;
    private final Map<MemberImpl, Long> memberMasterConfirmationTimes = new HashMap<MemberImpl, Long>();

    public ClusterManager(final Node node) {
        super(node);
        this.WAIT_MILLIS_BEFORE_JOIN = (long)node.groupProperties.WAIT_SECONDS_BEFORE_JOIN.getInteger() * 1000L;
        this.MAX_WAIT_SECONDS_BEFORE_JOIN = node.groupProperties.MAX_WAIT_SECONDS_BEFORE_JOIN.getInteger();
        this.MAX_NO_HEARTBEAT_MILLIS = (long)node.groupProperties.MAX_NO_HEARTBEAT_SECONDS.getInteger() * 1000L;
        this.HEARTBEAT_INTERVAL_MILLIS = (long)node.groupProperties.HEARTBEAT_INTERVAL_SECONDS.getInteger() * 1000L;
        this.MAX_NO_MASTER_CONFIRMATION_MILLIS = (long)node.groupProperties.MAX_NO_MASTER_CONFIRMATION_SECONDS.getInteger() * 1000L;
        this.MASTER_CONFIRMATION_INTERVAL_MILLIS = (long)node.groupProperties.MASTER_CONFIRMATION_INTERVAL_SECONDS.getInteger() * 1000L;
        this.MEMBER_LIST_PUBLISH_INTERVAL_MILLIS = (long)node.groupProperties.MEMBER_LIST_PUBLISH_INTERVAL_SECONDS.getInteger() * 1000L;
        this.ICMP_ENABLED = node.groupProperties.ICMP_ENABLED.getBoolean();
        this.ICMP_TTL = node.groupProperties.ICMP_TTL.getInteger();
        this.ICMP_TIMEOUT = node.groupProperties.ICMP_TIMEOUT.getInteger();
        node.clusterService.registerPeriodicRunnable(new SplitBrainHandler(node));
        node.clusterService.registerPeriodicRunnable(new Runnable(){

            public void run() {
                long now = Clock.currentTimeMillis();
                if (now - ClusterManager.this.lastHeartbeat >= ClusterManager.this.HEARTBEAT_INTERVAL_MILLIS) {
                    ClusterManager.this.heartBeater();
                    ClusterManager.this.lastHeartbeat = now;
                }
                if (now - ClusterManager.this.lastMasterConfirmation >= ClusterManager.this.MASTER_CONFIRMATION_INTERVAL_MILLIS) {
                    ClusterManager.this.sendMasterConfirmation();
                    ClusterManager.this.lastMasterConfirmation = now;
                }
                if (now - ClusterManager.this.lastMemberListPublish >= ClusterManager.this.MEMBER_LIST_PUBLISH_INTERVAL_MILLIS) {
                    ClusterManager.this.sendMemberListToOthers();
                    ClusterManager.this.lastMemberListPublish = now;
                }
            }
        });
        node.clusterService.registerPeriodicRunnable(new Runnable(){

            public void run() {
                ClusterManager.this.checkScheduledActions();
            }
        });
        node.connectionManager.addConnectionListener(this);
        this.registerPacketProcessor(ClusterOperation.RESPONSE, new PacketProcessor(){

            public void process(Packet packet) {
                ClusterManager.this.handleResponse(packet);
            }
        });
        this.registerPacketProcessor(ClusterOperation.HEARTBEAT, new PacketProcessor(){

            public void process(Packet packet) {
                ClusterManager.this.releasePacket(packet);
            }
        });
        this.registerPacketProcessor(ClusterOperation.LOG, new PacketProcessor(){

            public void process(Packet packet) {
                ClusterManager.this.logger.log(Level.parse(packet.name), IOUtil.toObject(packet.getValueData()).toString());
                ClusterManager.this.releasePacket(packet);
            }
        });
        this.registerPacketProcessor(ClusterOperation.JOIN_CHECK, new PacketProcessor(){

            public void process(Packet packet) {
                JoinInfo joinInfo;
                Connection conn = packet.conn;
                Request request = Request.copyFromPacket(packet);
                Data value = request.value;
                request.clearForResponse();
                if (node.isMaster() && node.joined() && node.isActive() && (joinInfo = (JoinInfo)IOUtil.toObject(value)) != null) {
                    try {
                        node.validateJoinRequest(joinInfo);
                        request.response = IOUtil.toData(node.createJoinInfo());
                    }
                    catch (Exception e) {
                        request.response = IOUtil.toData(e);
                    }
                }
                ClusterManager.this.returnResponse(request, conn);
                ClusterManager.this.releasePacket(packet);
            }
        });
        this.registerPacketProcessor(ClusterOperation.REMOTELY_PROCESS_AND_RESPOND, new PacketProcessor(){

            public void process(Packet packet) {
                Data data = packet.getValueData();
                RemotelyProcessable rp = (RemotelyProcessable)IOUtil.toObject(data);
                rp.setConnection(packet.conn);
                rp.setNode(node);
                rp.process();
                ClusterManager.this.sendResponse(packet);
            }
        });
        this.registerPacketProcessor(ClusterOperation.REMOTELY_PROCESS, new PacketProcessor(){

            public void process(Packet packet) {
                Data data = packet.getValueData();
                RemotelyProcessable rp = (RemotelyProcessable)IOUtil.toObject(data);
                rp.setConnection(packet.conn);
                rp.setNode(node);
                rp.process();
                ClusterManager.this.releasePacket(packet);
            }
        });
        this.registerPacketProcessor(ClusterOperation.REMOTELY_CALLABLE_BOOLEAN, new PacketProcessor(){

            public void process(Packet packet) {
                Boolean result;
                AbstractRemotelyCallable callable = null;
                try {
                    Data data = packet.getValueData();
                    callable = (AbstractRemotelyCallable)IOUtil.toObject(data);
                    callable.setConnection(packet.conn);
                    callable.setNode(node);
                    result = (Boolean)callable.call();
                }
                catch (Exception e) {
                    ClusterManager.this.logger.log(Level.SEVERE, "Error processing " + callable, e);
                    result = Boolean.FALSE;
                }
                if (result == Boolean.TRUE) {
                    ClusterManager.this.sendResponse(packet);
                } else {
                    ClusterManager.this.sendResponseFailure(packet);
                }
            }
        });
        this.registerPacketProcessor(ClusterOperation.REMOTELY_CALLABLE_OBJECT, new PacketProcessor(){

            public void process(Packet packet) {
                Object result;
                AbstractRemotelyCallable callable = null;
                try {
                    Data data = packet.getValueData();
                    callable = (AbstractRemotelyCallable)IOUtil.toObject(data);
                    callable.setConnection(packet.conn);
                    callable.setNode(node);
                    result = callable.call();
                }
                catch (Exception e) {
                    ClusterManager.this.logger.log(Level.SEVERE, "Error processing " + callable, e);
                    result = null;
                }
                if (result != null) {
                    Data value = result instanceof Data ? (Data)result : IOUtil.toData(result);
                    packet.setValue(value);
                }
                ClusterManager.this.sendResponse(packet);
            }
        });
    }

    public boolean shouldTryMerge() {
        return !this.joinInProgress && this.setJoins.size() == 0;
    }

    public JoinInfo checkJoin(Connection conn) {
        return new JoinCall(conn).checkJoin();
    }

    public void appendState(StringBuffer sbState) {
        sbState.append("\nClusterManager {");
        for (ScheduledAction sa : this.setScheduledActions) {
            sbState.append("\n\t" + sa + ", from:" + sa.getRequest().caller);
        }
        sbState.append("\n}");
    }

    void logMissingConnection(Address address) {
        String msg = this.thisMember + " has no connection to " + address;
        this.logAtMaster(Level.WARNING, msg);
        this.logger.log(Level.WARNING, msg);
    }

    public void logAtMaster(Level level, String msg) {
        Address master = this.getMasterAddress();
        if (!this.isMaster() && master != null) {
            Connection connMaster = this.node.connectionManager.getOrConnect(this.getMasterAddress());
            if (connMaster != null) {
                Packet packet = this.obtainPacket(level.toString(), null, IOUtil.toData(msg), ClusterOperation.LOG, 0L);
                this.sendOrReleasePacket(packet, connMaster);
            }
        } else {
            this.logger.log(level, msg);
        }
    }

    public final void heartBeater() {
        block21: {
            long now;
            block20: {
                if (!this.node.joined() || !this.node.isActive()) {
                    return;
                }
                now = Clock.currentTimeMillis();
                if (!this.isMaster()) break block20;
                ArrayList<Address> lsDeadAddresses = null;
                for (MemberImpl memberImpl : this.lsMembers) {
                    Address address = memberImpl.getAddress();
                    if (this.thisAddress.equals(address)) continue;
                    try {
                        Connection conn = this.node.connectionManager.getOrConnect(address);
                        if (conn != null && conn.live()) {
                            Long lastConfirmation;
                            if (now - memberImpl.getLastRead() >= this.MAX_NO_HEARTBEAT_MILLIS) {
                                conn = null;
                                if (lsDeadAddresses == null) {
                                    lsDeadAddresses = new ArrayList<Address>();
                                }
                                this.logger.log(Level.WARNING, "Added " + address + " to list of dead addresses because of timeout since last read");
                                lsDeadAddresses.add(address);
                            } else if (now - memberImpl.getLastRead() >= 5000L && now - memberImpl.getLastPing() >= 5000L) {
                                this.ping(memberImpl);
                            }
                            if (now - memberImpl.getLastWrite() > 500L) {
                                this.sendHeartbeat(conn);
                            }
                            if ((lastConfirmation = this.memberMasterConfirmationTimes.get(memberImpl)) != null && now - lastConfirmation <= this.MAX_NO_MASTER_CONFIRMATION_MILLIS) continue;
                            if (lsDeadAddresses == null) {
                                lsDeadAddresses = new ArrayList();
                            }
                            this.logger.log(Level.WARNING, "Added " + address + " to list of dead addresses because it has not sent a master confirmation recently");
                            lsDeadAddresses.add(address);
                            continue;
                        }
                        if (conn != null || now - memberImpl.getLastRead() <= 5000L) continue;
                        this.logMissingConnection(address);
                        memberImpl.didRead();
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                if (lsDeadAddresses == null) break block21;
                for (Address address : lsDeadAddresses) {
                    this.logger.log(Level.FINEST, "No heartbeat should remove " + address);
                    this.doRemoveAddress(address);
                }
                break block21;
            }
            Address masterAddress = this.getMasterAddress();
            if (masterAddress != null) {
                Connection connMaster = this.node.connectionManager.getOrConnect(masterAddress);
                MemberImpl masterMember = this.getMember(masterAddress);
                boolean removed = false;
                if (masterMember != null) {
                    if (now - masterMember.getLastRead() >= this.MAX_NO_HEARTBEAT_MILLIS) {
                        this.logger.log(Level.WARNING, "Master node has timed out its heartbeat and will be removed");
                        this.doRemoveAddress(masterAddress);
                        removed = true;
                    } else if (now - masterMember.getLastRead() >= 5000L && now - masterMember.getLastPing() >= 5000L) {
                        this.ping(masterMember);
                    }
                }
                if (!removed) {
                    this.sendHeartbeat(connMaster);
                }
            }
            for (MemberImpl member : this.lsMembers) {
                if (member.localMember()) continue;
                Address address = member.getAddress();
                Connection conn = this.node.connectionManager.getOrConnect(address);
                if (conn != null) {
                    this.sendHeartbeat(conn);
                    continue;
                }
                this.logger.log(Level.FINEST, "Could not connect to " + address + " to send heartbeat");
            }
        }
    }

    private void sendMasterConfirmation() {
        if (!this.node.joined() || !this.node.isActive() || this.isMaster()) {
            return;
        }
        Address masterAddress = this.getMasterAddress();
        if (masterAddress == null) {
            this.logger.log(Level.FINEST, "Could not send MasterConfirmation, master is null!");
            return;
        }
        MemberImpl masterMember = this.getMember(masterAddress);
        if (masterMember == null) {
            this.logger.log(Level.FINEST, "Could not send MasterConfirmation, master is null!");
            return;
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "Sending MasterConfirmation to " + masterMember);
        }
        this.sendProcessableTo((RemotelyProcessable)new MasterConfirmation(), masterAddress);
    }

    private void ping(final MemberImpl memberImpl) {
        memberImpl.didPing();
        if (!this.ICMP_ENABLED) {
            return;
        }
        this.node.executorManager.executeNow(new Runnable(){

            public void run() {
                try {
                    final Address address = memberImpl.getAddress();
                    ClusterManager.this.logger.log(Level.WARNING, ClusterManager.this.thisAddress + " will ping " + address);
                    for (int i = 0; i < 5; ++i) {
                        try {
                            if (!address.getInetAddress().isReachable(null, ClusterManager.this.ICMP_TTL, ClusterManager.this.ICMP_TIMEOUT)) continue;
                            ClusterManager.this.logger.log(Level.INFO, ClusterManager.this.thisAddress + " pings successfully. Target: " + address);
                            return;
                        }
                        catch (ConnectException connectException) {
                            // empty catch block
                        }
                    }
                    ClusterManager.this.logger.log(Level.WARNING, ClusterManager.this.thisAddress + " couldn't ping " + address);
                    ClusterManager.this.enqueueAndReturn(new Processable(){

                        public void process() {
                            ClusterManager.this.doRemoveAddress(address);
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    void sendHeartbeat(Connection conn) {
        if (conn == null) {
            return;
        }
        Packet packet = this.obtainPacket("heartbeat", null, null, ClusterOperation.HEARTBEAT, 0L);
        this.sendOrReleasePacket(packet, conn);
    }

    private void sendRemoveMemberToOthers(Address deadAddress) {
        for (MemberImpl member : this.lsMembers) {
            Address address = member.getAddress();
            if (this.thisAddress.equals(address) || address.equals(deadAddress)) continue;
            this.sendProcessableTo((RemotelyProcessable)new MemberRemover(deadAddress), address);
        }
    }

    private void resetMemberMasterConfirmations() {
        this.checkServiceThread();
        for (MemberImpl member : this.lsMembers) {
            this.memberMasterConfirmationTimes.put(member, Clock.currentTimeMillis());
        }
    }

    private void sendMemberListToOthers() {
        this.checkServiceThread();
        if (!this.isMaster()) {
            return;
        }
        this.sendProcessableToAll(new MembersUpdateCall(this.lsMembers, this.node.getClusterImpl().getClusterTime()), false);
    }

    public void sendClusterMergeToOthers(Address newTargetAddress) {
        this.sendProcessableToAll(new MergeClusters(newTargetAddress), false);
    }

    public void handleMaster(Master master) {
        if (!this.node.joined() && !this.thisAddress.equals(master.address)) {
            Connection conn;
            this.logger.log(Level.FINEST, "Handling master response: " + master);
            Address currentMaster = this.node.getMasterAddress();
            if (currentMaster != null && !currentMaster.equals(master.address) && (conn = this.node.connectionManager.getConnection(currentMaster)) != null && conn.live()) {
                this.logger.log(Level.FINEST, "Ignoring master response " + master + " since node has an active master: " + currentMaster);
                return;
            }
            this.node.setMasterAddress(master.address);
            this.node.connectionManager.getOrConnect(master.address);
            if (!this.sendJoinRequest(master.address, true)) {
                this.logger.log(Level.WARNING, "Could not create connection to possible master " + master.address);
            }
        }
    }

    public void handleAddRemoveConnection(AddOrRemoveConnection connection) {
        if (connection.add) {
            if (!connection.address.equals(this.thisAddress)) {
                this.node.connectionManager.getOrConnect(connection.address);
            }
        } else if (connection.address != null) {
            this.logger.log(Level.FINEST, "Disconnected from " + connection.address + "... will be removed!");
            this.doRemoveAddress(connection.address);
        }
    }

    void doRemoveAddress(Address deadAddress) {
        this.doRemoveAddress(deadAddress, true);
    }

    void doRemoveAddress(Address deadAddress, boolean destroyConnection) {
        MemberImpl deadMember;
        this.checkServiceThread();
        this.logger.log(Level.INFO, "Removing Address " + deadAddress);
        if (!this.node.joined()) {
            this.node.failedConnection(deadAddress);
            return;
        }
        if (deadAddress.equals(this.thisAddress)) {
            return;
        }
        if (deadAddress.equals(this.getMasterAddress())) {
            if (this.node.joined()) {
                MemberImpl newMaster = this.getNextMemberAfter(deadAddress, false, 1);
                if (newMaster != null) {
                    this.node.setMasterAddress(newMaster.getAddress());
                } else {
                    this.node.setMasterAddress(null);
                }
            } else {
                this.node.setMasterAddress(null);
            }
            this.logger.log(Level.FINEST, "Now Master " + this.node.getMasterAddress());
        }
        if (this.isMaster()) {
            this.setJoins.remove(new MemberInfo(deadAddress));
            this.resetMemberMasterConfirmations();
        }
        Connection conn = this.node.connectionManager.getConnection(deadAddress);
        if (destroyConnection && conn != null) {
            this.node.connectionManager.destroyConnection(conn);
        }
        if ((deadMember = this.getMember(deadAddress)) != null) {
            this.removeMember(deadMember);
            this.node.getClusterImpl().setMembers(this.lsMembers);
            this.node.concurrentMapManager.syncForDead(deadMember);
            this.node.blockingQueueManager.syncForDead(deadAddress);
            this.node.listenerManager.syncForDead(deadAddress);
            this.node.topicManager.syncForDead(deadAddress);
            this.disconnectExistingCalls(deadAddress);
            if (this.isMaster()) {
                this.logger.log(Level.FINEST, deadAddress + " is dead. Sending remove to all other members.");
                this.sendRemoveMemberToOthers(deadAddress);
            }
            this.logger.log(Level.INFO, this.toString());
        }
    }

    public void disconnectExistingCalls(Address deadAddress) {
        Object[] calls;
        for (Object call : calls = this.mapCalls.values().toArray()) {
            ((Call)call).onDisconnect(deadAddress);
        }
    }

    void handleJoinRequest(JoinRequest joinRequest) {
        boolean validJoinRequest;
        long now = Clock.currentTimeMillis();
        String msg = "Handling join from " + joinRequest.address + ", inProgress: " + this.joinInProgress + (this.timeToStartJoin > 0L ? ", timeToStart: " + (this.timeToStartJoin - now) : "");
        this.logger.log(Level.FINEST, msg);
        try {
            validJoinRequest = this.node.validateJoinRequest(joinRequest);
        }
        catch (Exception e) {
            validJoinRequest = false;
        }
        Connection conn = joinRequest.getConnection();
        if (validJoinRequest) {
            MemberImpl member = this.getMember(joinRequest.address);
            if (member != null) {
                if (joinRequest.getUuid().equals(member.getUuid())) {
                    String message = "Ignoring join request, member already exists.. => " + joinRequest;
                    this.logger.log(Level.FINEST, message);
                    long clusterTime = this.node.getClusterImpl().getClusterTime();
                    this.sendProcessableTo((RemotelyProcessable)new MembersUpdateCall(this.lsMembers, clusterTime), conn);
                    this.sendProcessableTo((RemotelyProcessable)new SyncProcess(), conn);
                    return;
                }
                if (this.isMaster() || member.getAddress().equals(this.getMasterAddress())) {
                    this.logger.log(Level.WARNING, "New join request has been received from an existing endpoint! => " + member + " Removing old member and processing join request...");
                    this.doRemoveAddress(member.getAddress(), false);
                }
            }
            if (!this.node.getConfig().getNetworkConfig().getJoin().getMulticastConfig().isEnabled() && this.node.isActive() && this.node.joined() && this.node.getMasterAddress() != null && !this.isMaster()) {
                this.sendProcessableTo((RemotelyProcessable)new Master(this.node.getMasterAddress()), conn);
            }
            if (this.isMaster() && this.node.joined() && this.node.isActive()) {
                MemberInfo newMemberInfo = new MemberInfo(joinRequest.address, joinRequest.nodeType, joinRequest.getUuid());
                if (this.node.securityContext != null && !this.setJoins.contains(newMemberInfo)) {
                    ILogger securityLogger = this.node.loggingService.getLogger("com.hazelcast.security");
                    Credentials cr = joinRequest.getCredentials();
                    if (cr == null) {
                        securityLogger.log(Level.SEVERE, "Expecting security credentials but credentials could not be found in JoinRequest!");
                        this.sendAuthFail(conn);
                        return;
                    }
                    try {
                        LoginContext lc = this.node.securityContext.createMemberLoginContext(cr);
                        lc.login();
                    }
                    catch (LoginException e) {
                        securityLogger.log(Level.SEVERE, "Authentication has failed for " + cr.getPrincipal() + '@' + cr.getEndpoint() + " => (" + e.getMessage() + ")");
                        securityLogger.log(Level.FINEST, e.getMessage(), e);
                        this.sendAuthFail(conn);
                        return;
                    }
                }
                if (joinRequest.to != null && !joinRequest.to.equals(this.thisAddress)) {
                    this.sendProcessableTo((RemotelyProcessable)new Master(this.node.getMasterAddress()), conn);
                    return;
                }
                if (!this.joinInProgress) {
                    if (this.firstJoinRequest != 0L && now - this.firstJoinRequest >= this.MAX_WAIT_SECONDS_BEFORE_JOIN * 1000L) {
                        this.startJoin();
                    } else {
                        if (this.setJoins.add(newMemberInfo)) {
                            this.sendProcessableTo((RemotelyProcessable)new Master(this.node.getMasterAddress()), conn);
                            if (this.firstJoinRequest == 0L) {
                                this.firstJoinRequest = now;
                            }
                            if (now - this.firstJoinRequest < this.MAX_WAIT_SECONDS_BEFORE_JOIN * 1000L) {
                                this.timeToStartJoin = now + this.WAIT_MILLIS_BEFORE_JOIN;
                            }
                        }
                        if (now > this.timeToStartJoin) {
                            this.startJoin();
                        }
                    }
                }
            }
        } else {
            conn.close();
        }
    }

    private void sendAuthFail(Connection conn) {
        this.sendProcessableTo((RemotelyProcessable)new AuthenticationFailureProcessable(), conn);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n\nMembers [");
        sb.append(this.lsMembers.size());
        sb.append("] {");
        for (MemberImpl member : this.lsMembers) {
            sb.append("\n\t").append(member);
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    void joinReset() {
        this.joinInProgress = false;
        this.setJoins.clear();
        this.timeToStartJoin = Clock.currentTimeMillis() + this.WAIT_MILLIS_BEFORE_JOIN;
        this.firstJoinRequest = 0L;
    }

    public void onRestart() {
        this.enqueueAndWait(new Processable(){

            public void process() {
                ClusterManager.this.joinReset();
                ClusterManager.this.lsMembers.clear();
                ClusterManager.this.mapMembers.clear();
                ClusterManager.this.dataMemberCount.reset();
                ClusterManager.this.memberMasterConfirmationTimes.clear();
            }
        }, 5);
    }

    public boolean checkAuthorization(String groupName, String groupPassword, Address target) {
        AuthorizationCall authorizationCall = new AuthorizationCall(groupName, groupPassword);
        NoneMemberAsyncRemotelyBooleanOp op = new NoneMemberAsyncRemotelyBooleanOp(authorizationCall, target, true);
        op.execute();
        return op.getResultAsBoolean();
    }

    public void finalizeJoin() {
        Set<Member> members = this.node.getClusterImpl().getMembers();
        ArrayList<AsyncRemotelyBooleanOp> calls = new ArrayList<AsyncRemotelyBooleanOp>();
        for (Member m : members) {
            MemberImpl member = (MemberImpl)m;
            if (member.localMember()) continue;
            AsyncRemotelyBooleanOp op = new AsyncRemotelyBooleanOp(new FinalizeJoin(), member.getAddress(), false);
            op.execute();
            calls.add(op);
        }
        for (AsyncRemotelyBooleanOp call : calls) {
            call.getResultAsBoolean();
        }
    }

    void startJoin() {
        this.logger.log(Level.FINEST, "Starting Join.");
        this.joinInProgress = true;
        MembersUpdateCall membersUpdate = new MembersUpdateCall(this.lsMembers, this.node.getClusterImpl().getClusterTime());
        if (this.setJoins != null && this.setJoins.size() > 0) {
            for (MemberInfo memberJoined : this.setJoins) {
                membersUpdate.addMemberInfo(memberJoined);
            }
        }
        membersUpdate.setNode(this.node);
        membersUpdate.call();
        this.node.executorManager.executeNow(new JoinRunnable(membersUpdate));
    }

    void updateMembers(Collection<MemberInfo> lsMemberInfos) {
        this.checkServiceThread();
        HashMap<Address, MemberImpl> mapOldMembers = new HashMap<Address, MemberImpl>();
        for (MemberImpl member : this.lsMembers) {
            mapOldMembers.put(member.getAddress(), member);
        }
        if (mapOldMembers.size() == lsMemberInfos.size()) {
            boolean same = true;
            for (MemberInfo memberInfo : lsMemberInfos) {
                MemberImpl member = (MemberImpl)mapOldMembers.get(memberInfo.getAddress());
                if (member != null && member.getUuid().equals(memberInfo.uuid)) continue;
                same = false;
                break;
            }
            if (same) {
                this.logger.log(Level.FINEST, "No need to process member update...");
                return;
            }
        }
        this.logger.log(Level.FINEST, "Updating Members");
        this.lsMembers.clear();
        this.dataMemberCount.reset();
        this.mapMembers.clear();
        this.memberMasterConfirmationTimes.clear();
        for (MemberInfo memberInfo : lsMemberInfos) {
            MemberImpl member = (MemberImpl)mapOldMembers.get(memberInfo.address);
            if (member == null) {
                member = this.addMember(memberInfo.address, memberInfo.nodeType, memberInfo.uuid);
            } else {
                this.addMember(member);
            }
            member.didRead();
        }
        if (!this.lsMembers.contains(this.thisMember)) {
            throw new RuntimeException("Member list doesn't contain local member!");
        }
        this.heartBeater();
        this.node.getClusterImpl().setMembers(this.lsMembers);
        this.node.setJoined();
        this.logger.log(Level.INFO, this.toString());
    }

    public boolean sendJoinRequest(Address toAddress, boolean withCredentials) {
        if (toAddress == null) {
            toAddress = this.node.getMasterAddress();
        }
        this.logger.log(Level.INFO, "Sending join request to " + toAddress);
        boolean send = this.sendProcessableTo((RemotelyProcessable)this.node.createJoinInfo(withCredentials), toAddress);
        if (!send) {
            this.logger.log(Level.WARNING, "Could not send join request to " + toAddress);
        }
        return send;
    }

    public void registerScheduledAction(ScheduledAction scheduledAction) {
        this.setScheduledActions.add(scheduledAction);
    }

    public void deregisterScheduledAction(ScheduledAction scheduledAction) {
        this.setScheduledActions.remove(scheduledAction);
    }

    public void checkScheduledActions() {
        if (!this.node.joined() || !this.node.isActive()) {
            return;
        }
        if (this.setScheduledActions.size() > 0) {
            Iterator<ScheduledAction> it = this.setScheduledActions.iterator();
            while (it.hasNext()) {
                ScheduledAction sa = it.next();
                if (sa.expired() && sa.isValid()) {
                    sa.onExpire();
                    it.remove();
                    continue;
                }
                if (sa.isValid()) continue;
                it.remove();
            }
        }
    }

    public void invalidateScheduledActionsFor(Address endpoint, Set<Integer> threadIds) {
        if (!this.node.joined() || !this.node.isActive()) {
            return;
        }
        if (this.setScheduledActions.size() > 0) {
            Iterator<ScheduledAction> it = this.setScheduledActions.iterator();
            while (it.hasNext()) {
                ScheduledAction sa = it.next();
                Request request = sa.getRequest();
                if (!endpoint.equals(request.caller) || !threadIds.contains(request.lockThreadId)) continue;
                sa.setValid(false);
                it.remove();
            }
        }
    }

    @Override
    public void connectionAdded(final Connection connection) {
        this.enqueueAndReturn(new Processable(){

            public void process() {
                MemberImpl member = ClusterManager.this.getMember(connection.getEndPoint());
                if (member != null) {
                    member.didRead();
                }
            }
        });
    }

    @Override
    public void connectionRemoved(Connection connection) {
        this.logger.log(Level.FINEST, "Connection is removed " + connection.getEndPoint());
        if (!this.node.joined() && this.getMasterAddress() != null && this.getMasterAddress().equals(connection.getEndPoint())) {
            this.node.setMasterAddress(null);
        }
    }

    public Member addMember(MemberImpl member) {
        return this.addMember(true, member);
    }

    public Member addMember(boolean checkServiceThread, MemberImpl member) {
        if (checkServiceThread) {
            this.checkServiceThread();
        }
        this.logger.log(Level.FINEST, "ClusterManager adding " + member);
        if (this.lsMembers.contains(member)) {
            for (MemberImpl m : this.lsMembers) {
                if (!m.equals(member)) continue;
                member = m;
            }
            this.mapMembers.put(member.getAddress(), member);
        } else {
            this.lsMembers.add(member);
            this.mapMembers.put(member.getAddress(), member);
            if (!member.isLiteMember()) {
                this.dataMemberCount.increment();
            }
        }
        this.memberMasterConfirmationTimes.put(member, Clock.currentTimeMillis());
        return member;
    }

    public void removeMember(MemberImpl member) {
        this.checkServiceThread();
        this.logger.log(Level.FINEST, "ClusterManager removing  " + member);
        this.mapMembers.remove(member.getAddress());
        this.lsMembers.remove(member);
        this.memberMasterConfirmationTimes.remove(member);
        if (!member.isLiteMember()) {
            this.dataMemberCount.decrement();
        }
    }

    protected MemberImpl createMember(Address address, NodeType nodeType, String nodeUuid, String ipV6ScopeId) {
        address.setScopeId(ipV6ScopeId);
        return new MemberImpl(address, this.thisAddress.equals(address), nodeType, nodeUuid);
    }

    public MemberImpl getMember(Address address) {
        if (address == null) {
            return null;
        }
        return (MemberImpl)this.mapMembers.get(address);
    }

    public final MemberImpl addMember(Address address, NodeType nodeType, String nodeUuid) {
        this.checkServiceThread();
        if (address == null) {
            this.logger.log(Level.FINEST, "Address cannot be null");
            return null;
        }
        MemberImpl member = this.getMember(address);
        if (member == null) {
            member = this.createMember(address, nodeType, nodeUuid, this.thisAddress.getScopeId());
        }
        this.addMember(member);
        return member;
    }

    public void stop() {
        if (this.setJoins != null) {
            this.setJoins.clear();
        }
        this.timeToStartJoin = 0L;
        if (this.lsMembers != null) {
            this.lsMembers.clear();
        }
        this.dataMemberCount.reset();
        if (this.mapMembers != null) {
            this.mapMembers.clear();
        }
        if (this.mapCalls != null) {
            this.mapCalls.clear();
        }
        if (this.memberMasterConfirmationTimes != null) {
            this.memberMasterConfirmationTimes.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JoinRunnable
    extends FallThroughRunnable
    implements Prioritized {
        final MembersUpdateCall membersUpdate;

        JoinRunnable(MembersUpdateCall membersUpdate) {
            this.membersUpdate = membersUpdate;
        }

        @Override
        public void doRun() {
            Collection<MemberInfo> lsMemberInfos = this.membersUpdate.getMemberInfos();
            ArrayList<Address> newMemberList = new ArrayList<Address>(lsMemberInfos.size());
            for (MemberInfo memberInfo : lsMemberInfos) {
                newMemberList.add(memberInfo.address);
            }
            this.doCall(this.membersUpdate, newMemberList, true);
            ClusterManager.this.systemLogService.logJoin("JoinRunnable update members done.");
            this.doCall(new SyncProcess(), newMemberList, false);
            ClusterManager.this.systemLogService.logJoin("JoinRunnable sync done.");
            this.doCall(new ConnectionCheckCall(), newMemberList, false);
            ClusterManager.this.systemLogService.logJoin("JoinRunnable connection check done.");
        }

        void doCall(AbstractRemotelyCallable callable, List<Address> targets, boolean ignoreThis) {
            ArrayList<AsyncRemotelyBooleanOp> calls = new ArrayList<AsyncRemotelyBooleanOp>(targets.size());
            for (Address target : targets) {
                boolean skip = ignoreThis && ClusterManager.this.thisAddress.equals(target);
                if (skip) continue;
                AsyncRemotelyBooleanOp op = new AsyncRemotelyBooleanOp(callable, target, false);
                op.execute();
                calls.add(op);
            }
            for (AsyncRemotelyBooleanOp call : calls) {
                if (call.getResultAsBoolean(5)) continue;
                targets.remove(call.getTarget());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AsyncRemotelyBooleanOp
    extends BaseManager.TargetAwareOp {
        private final AbstractRemotelyCallable<Boolean> arp;
        private final boolean canTimeout;

        public AsyncRemotelyBooleanOp(AbstractRemotelyCallable<Boolean> arp, Address target, boolean canTimeout) {
            super(ClusterManager.this);
            this.arp = arp;
            this.target = target;
            this.canTimeout = canTimeout;
        }

        public void execute() {
            this.arp.setNode(ClusterManager.this.node);
            this.setLocal(ClusterOperation.REMOTELY_CALLABLE_BOOLEAN, "call", null, this.arp, 0L, -1L);
            this.request.setBooleanRequest();
            this.doOp();
        }

        @Override
        public Address getTarget() {
            return this.target;
        }

        @Override
        public void onDisconnect(Address dead) {
            if (dead.equals(this.target)) {
                ClusterManager.this.removeRemoteCall(this.getCallId());
                this.setResult(Boolean.FALSE);
            }
        }

        @Override
        public void doLocalOp() {
            try {
                Boolean result = (Boolean)this.arp.call();
                this.setResult(result);
            }
            catch (Exception e) {
                ClusterManager.this.logger.log(Level.FINEST, e.getMessage(), e);
            }
        }

        @Override
        public void setTarget() {
        }

        @Override
        public void redo(int redoTypeCode) {
            ClusterManager.this.removeRemoteCall(this.getCallId());
            this.setResult(Boolean.FALSE);
        }

        @Override
        protected void memberDoesNotExist() {
            this.setResult(Boolean.FALSE);
        }

        @Override
        protected void packetNotSent() {
            this.setResult(Boolean.FALSE);
        }

        @Override
        protected final boolean canTimeout() {
            return this.canTimeout;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NoneMemberAsyncRemotelyBooleanOp
    extends AsyncRemotelyBooleanOp {
        public NoneMemberAsyncRemotelyBooleanOp(AbstractRemotelyCallable<Boolean> arp, Address target, boolean canTimeout) {
            super(arp, target, canTimeout);
        }

        @Override
        protected boolean memberOnly() {
            return false;
        }
    }

    public static class AuthenticationFailureProcessable
    extends AbstractRemotelyProcessable
    implements RemotelyProcessable {
        public void process() {
            this.node.executorManager.executeNow(new Runnable(){

                public void run() {
                    ILogger logger2 = AuthenticationFailureProcessable.this.node.loggingService.getLogger("com.hazelcast.security");
                    logger2.log(Level.SEVERE, "Authentication failed on master node! Node is going to shutdown now!");
                    AuthenticationFailureProcessable.this.node.shutdown(true, true);
                }
            });
        }
    }

    public static class MasterConfirmation
    extends AbstractRemotelyProcessable {
        public void process() {
            Address endPoint = this.conn.getEndPoint();
            if (endPoint == null) {
                return;
            }
            ILogger logger2 = this.node.getLogger(MasterConfirmation.class.getName());
            ClusterManager clusterManager = this.node.clusterManager;
            MemberImpl member = clusterManager.getMember(endPoint);
            if (member != null) {
                if (this.getNode().isMaster()) {
                    if (logger2.isLoggable(Level.FINEST)) {
                        logger2.log(Level.FINEST, "MasterConfirmation has been received from " + member);
                    }
                    clusterManager.memberMasterConfirmationTimes.put(member, Clock.currentTimeMillis());
                } else {
                    logger2.log(Level.WARNING, endPoint + " has sent MasterConfirmation, but this node is not master!");
                }
            } else {
                logger2.log(Level.WARNING, "MasterConfirmation has been received from " + endPoint + ", but it is not a member of this cluster!");
                clusterManager.sendProcessableTo((RemotelyProcessable)new MemberRemover(clusterManager.thisAddress), this.conn);
            }
        }
    }

    class JoinCall
    extends BaseManager.ConnectionAwareOp {
        JoinCall(Connection target) {
            super(ClusterManager.this, target);
        }

        JoinInfo checkJoin() {
            this.setLocal(ClusterOperation.JOIN_CHECK, "join", null, ClusterManager.this.node.createJoinInfo(), 0L, 0L);
            this.doOp();
            return (JoinInfo)this.getResultAsObject();
        }
    }
}

