/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.util;

import java.io.File;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public final class ArchiveEntryUtils {
    private ArchiveEntryUtils() {
    }

    public static void chmod(File file, int mode, Logger logger2) throws ArchiverException {
        if (!Os.isFamily("unix")) {
            return;
        }
        String m = Integer.toOctalString(mode & 0xFFF);
        try {
            Commandline commandline = new Commandline();
            commandline.setWorkingDirectory(file.getParentFile().getAbsolutePath());
            commandline.setExecutable("chmod");
            commandline.createArg().setValue(m);
            String path = file.getAbsolutePath();
            commandline.createArg().setValue(path);
            CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
            CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
            int exitCode = CommandLineUtils.executeCommandLine(commandline, stderr, stdout);
            if (exitCode != 0) {
                logger2.warn("-------------------------------");
                logger2.warn("Standard error:");
                logger2.warn("-------------------------------");
                logger2.warn(stderr.getOutput());
                logger2.warn("-------------------------------");
                logger2.warn("Standard output:");
                logger2.warn("-------------------------------");
                logger2.warn(stdout.getOutput());
                logger2.warn("-------------------------------");
                throw new ArchiverException("chmod exit code was: " + exitCode);
            }
        }
        catch (CommandLineException e) {
            throw new ArchiverException("Error while executing chmod.", e);
        }
    }
}

