/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.schemagen;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.persistence.PersistenceException;
import org.hibernate.jpa.internal.schemagen.ScriptSourceInput;
import org.hibernate.jpa.internal.schemagen.ScriptSourceInputFromReader;
import org.jboss.logging.Logger;

public class ScriptSourceInputFromFile
extends ScriptSourceInputFromReader
implements ScriptSourceInput {
    private static final Logger log = Logger.getLogger(ScriptSourceInputFromFile.class);

    public ScriptSourceInputFromFile(File file) {
        super(ScriptSourceInputFromFile.toFileReader(file));
    }

    @Override
    public void release() {
        try {
            this.reader().close();
        }
        catch (IOException e) {
            log.warn("Unable to close file reader for generation script source");
        }
    }

    private static Reader toFileReader(File file) {
        if (!file.exists()) {
            log.warnf("Specified schema generation script file [%s] did not exist for reading", (Object)file);
            return new Reader(){

                @Override
                public int read(char[] cbuf, int off, int len) throws IOException {
                    return -1;
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
        try {
            return new FileReader(file);
        }
        catch (IOException e) {
            throw new PersistenceException("Unable to open specified script target file [" + file + "] for reading", e);
        }
    }
}

