/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.Properties;
import org.postgresql.core.ConnectionFactory;
import org.postgresql.core.Encoding;
import org.postgresql.core.Logger;
import org.postgresql.core.PGStream;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.Utils;
import org.postgresql.core.v3.ProtocolConnectionImpl;
import org.postgresql.gss.MakeGSS;
import org.postgresql.ssl.MakeSSL;
import org.postgresql.util.GT;
import org.postgresql.util.MD5Digest;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.PSQLWarning;
import org.postgresql.util.ServerErrorMessage;
import org.postgresql.util.UnixCrypt;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;
    private static final int AUTH_REQ_GSS = 7;
    private static final int AUTH_REQ_GSS_CONTINUE = 8;
    private static final int AUTH_REQ_SSPI = 9;

    @Override
    public ProtocolConnection openConnectionImpl(String host, int port, String user, String database, Properties info, Logger logger2) throws SQLException {
        boolean requireSSL;
        boolean trySSL = requireSSL = info.getProperty("ssl") != null;
        boolean requireTCPKeepAlive = Boolean.valueOf(info.getProperty("tcpKeepAlive"));
        if (logger2.logDebug()) {
            logger2.debug("Trying to establish a protocol version 3 connection to " + host + ":" + port);
        }
        PGStream newStream = null;
        try {
            newStream = new PGStream(host, port);
            if (trySSL) {
                newStream = this.enableSSL(newStream, requireSSL, info, logger2);
            }
            String socketTimeoutProperty = info.getProperty("socketTimeout", "0");
            try {
                int socketTimeout = Integer.parseInt(socketTimeoutProperty);
                if (socketTimeout > 0) {
                    newStream.getSocket().setSoTimeout(socketTimeout * 1000);
                }
            }
            catch (NumberFormatException nfe) {
                logger2.info("Couldn't parse socketTimeout value:" + socketTimeoutProperty);
            }
            newStream.getSocket().setKeepAlive(requireTCPKeepAlive);
            String[][] params = new String[][]{{"user", user}, {"database", database}, {"client_encoding", "UNICODE"}, {"DateStyle", "ISO"}, {"extra_float_digits", "2"}};
            this.sendStartupPacket(newStream, params, logger2);
            this.doAuthentication(newStream, host, user, info, logger2);
            ProtocolConnectionImpl protoConnection = new ProtocolConnectionImpl(newStream, user, database, info, logger2);
            this.readStartupMessages(newStream, protoConnection, logger2);
            return protoConnection;
        }
        catch (UnsupportedProtocolException upe) {
            if (logger2.logDebug()) {
                logger2.debug("Protocol not supported, abandoning connection.");
            }
            try {
                newStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return null;
        }
        catch (ConnectException cex) {
            throw new PSQLException(GT.tr("Connection refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections."), PSQLState.CONNECTION_REJECTED, (Throwable)cex);
        }
        catch (IOException ioe) {
            if (newStream != null) {
                try {
                    newStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw new PSQLException(GT.tr("The connection attempt failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
        }
        catch (SQLException se) {
            if (newStream != null) {
                try {
                    newStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw se;
        }
    }

    private PGStream enableSSL(PGStream pgStream, boolean requireSSL, Properties info, Logger logger2) throws IOException, SQLException {
        if (logger2.logDebug()) {
            logger2.debug(" FE=> SSLRequest");
        }
        pgStream.SendInteger4(8);
        pgStream.SendInteger2(1234);
        pgStream.SendInteger2(5679);
        pgStream.flush();
        int beresp = pgStream.ReceiveChar();
        switch (beresp) {
            case 69: {
                if (logger2.logDebug()) {
                    logger2.debug(" <=BE SSLError");
                }
                if (requireSSL) {
                    throw new PSQLException(GT.tr("The server does not support SSL."), PSQLState.CONNECTION_FAILURE);
                }
                pgStream.close();
                return new PGStream(pgStream.getHost(), pgStream.getPort());
            }
            case 78: {
                if (logger2.logDebug()) {
                    logger2.debug(" <=BE SSLRefused");
                }
                if (requireSSL) {
                    throw new PSQLException(GT.tr("The server does not support SSL."), PSQLState.CONNECTION_FAILURE);
                }
                return pgStream;
            }
            case 83: {
                if (logger2.logDebug()) {
                    logger2.debug(" <=BE SSLOk");
                }
                MakeSSL.convert(pgStream, info, logger2);
                return pgStream;
            }
        }
        throw new PSQLException(GT.tr("An error occured while setting up the SSL connection."), PSQLState.CONNECTION_FAILURE);
    }

    private void sendStartupPacket(PGStream pgStream, String[][] params, Logger logger2) throws IOException {
        int i;
        if (logger2.logDebug()) {
            String details = "";
            for (int i2 = 0; i2 < params.length; ++i2) {
                if (i2 != 0) {
                    details = details + ", ";
                }
                details = details + params[i2][0] + "=" + params[i2][1];
            }
            logger2.debug(" FE=> StartupPacket(" + details + ")");
        }
        int length = 8;
        byte[][] encodedParams = new byte[params.length * 2][];
        for (i = 0; i < params.length; ++i) {
            encodedParams[i * 2] = params[i][0].getBytes("UTF-8");
            encodedParams[i * 2 + 1] = params[i][1].getBytes("UTF-8");
            length += encodedParams[i * 2].length + 1 + encodedParams[i * 2 + 1].length + 1;
        }
        pgStream.SendInteger4(++length);
        pgStream.SendInteger2(3);
        pgStream.SendInteger2(0);
        for (i = 0; i < encodedParams.length; ++i) {
            pgStream.Send(encodedParams[i]);
            pgStream.SendChar(0);
        }
        pgStream.SendChar(0);
        pgStream.flush();
    }

    private void doAuthentication(PGStream pgStream, String host, String user, Properties info, Logger logger2) throws IOException, SQLException {
        String password = info.getProperty("password");
        block11: while (true) {
            int beresp = pgStream.ReceiveChar();
            switch (beresp) {
                case 69: {
                    int l_elen = pgStream.ReceiveInteger4();
                    if (l_elen > 30000) {
                        throw new UnsupportedProtocolException();
                    }
                    ServerErrorMessage errorMsg = new ServerErrorMessage(pgStream.ReceiveString(l_elen - 4), logger2.getLogLevel());
                    if (logger2.logDebug()) {
                        logger2.debug(" <=BE ErrorMessage(" + errorMsg + ")");
                    }
                    throw new PSQLException(errorMsg);
                }
                case 82: {
                    int l_msgLen = pgStream.ReceiveInteger4();
                    int areq = pgStream.ReceiveInteger4();
                    switch (areq) {
                        case 4: {
                            byte[] salt = pgStream.Receive(2);
                            if (logger2.logDebug()) {
                                logger2.debug(" <=BE AuthenticationReqCrypt(salt='" + new String(salt, "US-ASCII") + "')");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] encodedResult = UnixCrypt.crypt(salt, password.getBytes("UTF-8"));
                            if (logger2.logDebug()) {
                                logger2.debug(" FE=> Password(crypt='" + new String(encodedResult, "US-ASCII") + "')");
                            }
                            pgStream.SendChar(112);
                            pgStream.SendInteger4(4 + encodedResult.length + 1);
                            pgStream.Send(encodedResult);
                            pgStream.SendChar(0);
                            pgStream.flush();
                            continue block11;
                        }
                        case 5: {
                            byte[] md5Salt = pgStream.Receive(4);
                            if (logger2.logDebug()) {
                                logger2.debug(" <=BE AuthenticationReqMD5(salt=" + Utils.toHexString(md5Salt) + ")");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] digest = MD5Digest.encode(user.getBytes("UTF-8"), password.getBytes("UTF-8"), md5Salt);
                            if (logger2.logDebug()) {
                                logger2.debug(" FE=> Password(md5digest=" + new String(digest, "US-ASCII") + ")");
                            }
                            pgStream.SendChar(112);
                            pgStream.SendInteger4(4 + digest.length + 1);
                            pgStream.Send(digest);
                            pgStream.SendChar(0);
                            pgStream.flush();
                            continue block11;
                        }
                        case 3: {
                            if (logger2.logDebug()) {
                                logger2.debug(" <=BE AuthenticationReqPassword");
                                logger2.debug(" FE=> Password(password=<not shown>)");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] encodedPassword = password.getBytes("UTF-8");
                            pgStream.SendChar(112);
                            pgStream.SendInteger4(4 + encodedPassword.length + 1);
                            pgStream.Send(encodedPassword);
                            pgStream.SendChar(0);
                            pgStream.flush();
                            continue block11;
                        }
                        case 7: {
                            MakeGSS.authenticate(pgStream, host, user, password, info.getProperty("jaasApplicationName"), info.getProperty("kerberosServerName"), logger2);
                            continue block11;
                        }
                        case 0: {
                            if (logger2.logDebug()) {
                                logger2.debug(" <=BE AuthenticationOk");
                            }
                            return;
                        }
                    }
                    if (logger2.logDebug()) {
                        logger2.debug(" <=BE AuthenticationReq (unsupported type " + areq + ")");
                    }
                    throw new PSQLException(GT.tr("The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", new Integer(areq)), PSQLState.CONNECTION_REJECTED);
                }
            }
            break;
        }
        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private void readStartupMessages(PGStream pgStream, ProtocolConnectionImpl protoConnection, Logger logger2) throws IOException, SQLException {
        int beresp;
        block12: while (true) {
            beresp = pgStream.ReceiveChar();
            switch (beresp) {
                case 90: {
                    if (pgStream.ReceiveInteger4() != 5) {
                        throw new IOException("unexpected length of ReadyForQuery packet");
                    }
                    char tStatus = (char)pgStream.ReceiveChar();
                    if (logger2.logDebug()) {
                        logger2.debug(" <=BE ReadyForQuery(" + tStatus + ")");
                    }
                    switch (tStatus) {
                        case 'I': {
                            protoConnection.setTransactionState(0);
                            break;
                        }
                        case 'T': {
                            protoConnection.setTransactionState(1);
                            break;
                        }
                        case 'E': {
                            protoConnection.setTransactionState(2);
                            break;
                        }
                    }
                    return;
                }
                case 75: {
                    int l_msgLen = pgStream.ReceiveInteger4();
                    if (l_msgLen != 12) {
                        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    int pid = pgStream.ReceiveInteger4();
                    int ckey = pgStream.ReceiveInteger4();
                    if (logger2.logDebug()) {
                        logger2.debug(" <=BE BackendKeyData(pid=" + pid + ",ckey=" + ckey + ")");
                    }
                    protoConnection.setBackendKeyData(pid, ckey);
                    continue block12;
                }
                case 69: {
                    int l_elen = pgStream.ReceiveInteger4();
                    ServerErrorMessage l_errorMsg = new ServerErrorMessage(pgStream.ReceiveString(l_elen - 4), logger2.getLogLevel());
                    if (logger2.logDebug()) {
                        logger2.debug(" <=BE ErrorMessage(" + l_errorMsg + ")");
                    }
                    throw new PSQLException(l_errorMsg);
                }
                case 78: {
                    int l_nlen = pgStream.ReceiveInteger4();
                    ServerErrorMessage l_warnMsg = new ServerErrorMessage(pgStream.ReceiveString(l_nlen - 4), logger2.getLogLevel());
                    if (logger2.logDebug()) {
                        logger2.debug(" <=BE NoticeResponse(" + l_warnMsg + ")");
                    }
                    protoConnection.addWarning(new PSQLWarning(l_warnMsg));
                    continue block12;
                }
                case 83: {
                    int l_len = pgStream.ReceiveInteger4();
                    String name = pgStream.ReceiveString();
                    String value = pgStream.ReceiveString();
                    if (logger2.logDebug()) {
                        logger2.debug(" <=BE ParameterStatus(" + name + " = " + value + ")");
                    }
                    if (name.equals("server_version")) {
                        protoConnection.setServerVersion(value);
                        continue block12;
                    }
                    if (name.equals("client_encoding")) {
                        if (!value.equals("UNICODE")) {
                            throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                        }
                        pgStream.setEncoding(Encoding.getDatabaseEncoding("UNICODE"));
                        continue block12;
                    }
                    if (!name.equals("standard_conforming_strings")) continue block12;
                    if (value.equals("on")) {
                        protoConnection.setStandardConformingStrings(true);
                        continue block12;
                    }
                    if (value.equals("off")) {
                        protoConnection.setStandardConformingStrings(false);
                        continue block12;
                    }
                    throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                }
            }
            break;
        }
        if (logger2.logDebug()) {
            logger2.debug("invalid message type=" + (char)beresp);
        }
        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private static class UnsupportedProtocolException
    extends IOException {
        private UnsupportedProtocolException() {
        }
    }
}

