/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain.support;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.data.domain.AuditorAware;
import org.springframework.util.StringUtils;

public class AuditingBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    static final String BEAN_CONFIGURER_ASPECT_BEAN_NAME = "org.springframework.context.config.internalBeanConfigurerAspect";
    private static final String JPA_PACKAGE = "org.springframework.orm.jpa.";
    private static final List<String> CLASSES_TO_DEPEND = Arrays.asList("org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean", "org.springframework.orm.jpa.LocalEntityManagerFactoryBean");

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        BeanDefinition definition;
        if (!this.isSpringConfigured(beanFactory)) {
            return;
        }
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            definition = beanFactory.getBeanDefinition(beanName);
            if (!CLASSES_TO_DEPEND.contains(definition.getBeanClassName())) continue;
            definition.setDependsOn(StringUtils.addStringToArray(definition.getDependsOn(), BEAN_CONFIGURER_ASPECT_BEAN_NAME));
        }
        for (String beanName : BeanFactoryUtils.beanNamesForTypeIncludingAncestors(beanFactory, AuditorAware.class, true, false)) {
            definition = beanFactory.getBeanDefinition(beanName);
            definition.setLazyInit(true);
        }
    }

    private boolean isSpringConfigured(BeanFactory factory) {
        try {
            factory.getBean(BEAN_CONFIGURER_ASPECT_BEAN_NAME);
            return true;
        }
        catch (NoSuchBeanDefinitionException e) {
            return false;
        }
    }
}

