/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class StringQuery {
    private final String query;
    private final List<ParameterBinding> bindings;
    private final String alias;

    public StringQuery(String query) {
        Assert.hasText(query, "Query must not be null or empty!");
        this.bindings = new ArrayList<ParameterBinding>();
        this.query = ParameterBindingParser.INSTANCE.parseParameterBindingsOfQueryIntoBindingsAndReturnCleanedQuery(query, this.bindings);
        this.alias = QueryUtils.detectAlias(query);
    }

    public boolean hasParameterBindings() {
        return !this.bindings.isEmpty();
    }

    List<ParameterBinding> getParameterBindings() {
        return this.bindings;
    }

    public String getQueryString() {
        return this.query;
    }

    public String getAlias() {
        return this.alias;
    }

    public ParameterBinding getBindingFor(String name) {
        Assert.hasText(name, "Name must not be null or empty!");
        for (ParameterBinding binding : this.bindings) {
            if (!binding.hasName(name)) continue;
            return binding;
        }
        throw new IllegalArgumentException(String.format("No parameter binding found for name %s!", name));
    }

    public ParameterBinding getBindingFor(int position) {
        for (ParameterBinding binding : this.bindings) {
            if (!binding.hasPosition(position)) continue;
            return binding;
        }
        throw new IllegalArgumentException(String.format("No parameter binding found for position %s!", position));
    }

    static class LikeParameterBinding
    extends ParameterBinding {
        private static final List<Part.Type> SUPPORTED_TYPES = Arrays.asList(Part.Type.CONTAINING, Part.Type.STARTING_WITH, Part.Type.ENDING_WITH, Part.Type.LIKE);
        private final Part.Type type;

        public LikeParameterBinding(String name, Part.Type type) {
            super(name);
            Assert.hasText(name, "Name must not be null or empty!");
            Assert.notNull((Object)type, "Type must not be null!");
            Assert.isTrue(SUPPORTED_TYPES.contains((Object)type), String.format("Type must be one of %s!", StringUtils.collectionToCommaDelimitedString(SUPPORTED_TYPES)));
            this.type = type;
        }

        public LikeParameterBinding(int position, Part.Type type) {
            super(position);
            Assert.isTrue(position > 0, "Position must be greater than zero!");
            Assert.notNull((Object)type, "Type must not be null!");
            Assert.isTrue(SUPPORTED_TYPES.contains((Object)type), String.format("Type must be one of %s!", StringUtils.collectionToCommaDelimitedString(SUPPORTED_TYPES)));
            this.type = type;
        }

        public Part.Type getType() {
            return this.type;
        }

        @Override
        public Object prepare(Object value) {
            if (value == null) {
                return value;
            }
            switch (this.type) {
                case STARTING_WITH: {
                    return String.format("%s%%", value.toString());
                }
                case ENDING_WITH: {
                    return String.format("%%%s", value.toString());
                }
                case CONTAINING: {
                    return String.format("%%%s%%", value.toString());
                }
            }
            return value;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof LikeParameterBinding)) {
                return false;
            }
            LikeParameterBinding that = (LikeParameterBinding)obj;
            return super.equals(obj) && this.type.equals((Object)that.type);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return result += ObjectUtils.nullSafeHashCode((Object)this.type);
        }

        @Override
        public String toString() {
            return String.format("LikeBinding [name: %s, position: %d, type: %s]", new Object[]{this.getName(), this.getPosition(), this.type});
        }

        private static Part.Type getLikeTypeFrom(String expression) {
            Assert.hasText(expression);
            if (expression.matches("%.*%")) {
                return Part.Type.CONTAINING;
            }
            if (expression.startsWith("%")) {
                return Part.Type.ENDING_WITH;
            }
            if (expression.endsWith("%")) {
                return Part.Type.STARTING_WITH;
            }
            return Part.Type.LIKE;
        }
    }

    static class InParameterBinding
    extends ParameterBinding {
        public InParameterBinding(String name) {
            super(name);
        }

        public InParameterBinding(int position) {
            super(position);
        }

        @Override
        public Object prepare(Object value) {
            if (!ObjectUtils.isArray(value)) {
                return value;
            }
            int length = Array.getLength(value);
            ArrayList<Object> result = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                result.add(Array.get(value, i));
            }
            return result;
        }
    }

    static class ParameterBinding {
        private final String name;
        private final Integer position;

        public ParameterBinding(String name) {
            Assert.notNull(name, "Name must not be null!");
            this.name = name;
            this.position = null;
        }

        public ParameterBinding(Integer position) {
            Assert.notNull(position, "Position must not be null!");
            this.name = null;
            this.position = position;
        }

        public boolean hasName(String name) {
            return this.position == null && this.name != null && this.name.equals(name);
        }

        public boolean hasPosition(Integer position) {
            return position != null && this.name == null && this.position == position;
        }

        public String getName() {
            return this.name;
        }

        public Integer getPosition() {
            return this.position;
        }

        public int hashCode() {
            int result = 17;
            result += ObjectUtils.nullSafeHashCode(this.name);
            return result += ObjectUtils.nullSafeHashCode(this.position);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ParameterBinding)) {
                return false;
            }
            ParameterBinding that = (ParameterBinding)obj;
            return ObjectUtils.nullSafeEquals(this.name, that.name) && ObjectUtils.nullSafeEquals(this.position, that.position);
        }

        public String toString() {
            return String.format("ParameterBinding [name: %s, position: %d]", this.getName(), this.getPosition());
        }

        public Object prepare(Object valueToBind) {
            return valueToBind;
        }
    }

    private static enum ParameterBindingParser {
        INSTANCE;

        private static final Pattern PARAMETER_BINDING_PATTERN;
        private static final String MESSAGE = "Already found parameter binding with same index / parameter name but differing binding type! Already have: %s, found %s! If you bind a parameter multiple times make sure they use the same binding.";

        private final String parseParameterBindingsOfQueryIntoBindingsAndReturnCleanedQuery(String query, List<ParameterBinding> bindings) {
            Matcher matcher = PARAMETER_BINDING_PATTERN.matcher(query);
            String result = query;
            block4: while (matcher.find()) {
                String parameterIndexString = matcher.group(4);
                String parameterName = parameterIndexString != null ? null : matcher.group(6);
                Integer parameterIndex = parameterIndexString == null ? null : Integer.valueOf(parameterIndexString);
                String typeSource = matcher.group(1);
                switch (ParameterBindingType.of(typeSource)) {
                    case LIKE: {
                        Part.Type likeType = LikeParameterBinding.getLikeTypeFrom(matcher.group(2));
                        String replacement = matcher.group(3);
                        if (parameterIndex != null) {
                            ParameterBindingParser.checkAndRegister(new LikeParameterBinding(parameterIndex, likeType), bindings);
                        } else {
                            ParameterBindingParser.checkAndRegister(new LikeParameterBinding(parameterName, likeType), bindings);
                            replacement = matcher.group(5);
                        }
                        result = StringUtils.replace(result, matcher.group(2), replacement);
                        continue block4;
                    }
                    case IN: {
                        if (parameterIndex != null) {
                            ParameterBindingParser.checkAndRegister(new InParameterBinding((int)parameterIndex), bindings);
                        } else {
                            ParameterBindingParser.checkAndRegister(new InParameterBinding(parameterName), bindings);
                        }
                        result = query;
                        continue block4;
                    }
                }
                bindings.add(parameterIndex != null ? new ParameterBinding(parameterIndex) : new ParameterBinding(parameterName));
            }
            return result;
        }

        private static void checkAndRegister(ParameterBinding binding, List<ParameterBinding> bindings) {
            for (ParameterBinding existing : bindings) {
                if (!existing.hasName(binding.getName()) && !existing.hasPosition(binding.getPosition())) continue;
                Assert.isTrue(existing.equals(binding), String.format(MESSAGE, existing, binding));
            }
            if (!bindings.contains(binding)) {
                bindings.add(binding);
            }
        }

        static {
            ArrayList<String> keywords = new ArrayList<String>();
            for (ParameterBindingType type : ParameterBindingType.values()) {
                if (type.getKeyword() == null) continue;
                keywords.add(type.getKeyword());
            }
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            builder.append(StringUtils.collectionToDelimitedString(keywords, "|"));
            builder.append(")?");
            builder.append("(?: )?");
            builder.append("\\(?");
            builder.append("(");
            builder.append("%?(\\?(\\d+))%?");
            builder.append("|");
            builder.append("%?(:(\\w+))%?");
            builder.append(")");
            builder.append("\\)?");
            PARAMETER_BINDING_PATTERN = Pattern.compile(builder.toString(), 2);
        }

        private static enum ParameterBindingType {
            LIKE("like "),
            IN("in "),
            AS_IS(null);

            private final String keyword;

            private ParameterBindingType(String keyword) {
                this.keyword = keyword;
            }

            public String getKeyword() {
                return this.keyword;
            }

            static ParameterBindingType of(String typeSource) {
                if (!StringUtils.hasText(typeSource)) {
                    return AS_IS;
                }
                for (ParameterBindingType type : ParameterBindingType.values()) {
                    if (!type.name().equalsIgnoreCase(typeSource.trim())) continue;
                    return type;
                }
                throw new IllegalArgumentException(String.format("Unsupported parameter binding type %s!", typeSource));
            }
        }
    }
}

