/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.lang.reflect.Method;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.SchedulerContext;
import org.quartz.spi.TriggerFiredBundle;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.scheduling.quartz.AdaptableJobFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.scheduling.quartz.SchedulerContextAware;
import org.springframework.util.ReflectionUtils;

public class SpringBeanJobFactory
extends AdaptableJobFactory
implements SchedulerContextAware {
    private String[] ignoredUnknownProperties;
    private SchedulerContext schedulerContext;

    public void setIgnoredUnknownProperties(String[] ignoredUnknownProperties) {
        this.ignoredUnknownProperties = ignoredUnknownProperties;
    }

    public void setSchedulerContext(SchedulerContext schedulerContext) {
        this.schedulerContext = schedulerContext;
    }

    protected Object createJobInstance(TriggerFiredBundle bundle) throws Exception {
        Object job = super.createJobInstance(bundle);
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess(job);
        if (this.isEligibleForPropertyPopulation(bw.getWrappedInstance())) {
            MutablePropertyValues pvs = new MutablePropertyValues();
            if (this.schedulerContext != null) {
                pvs.addPropertyValues((Map<?, ?>)this.schedulerContext);
            }
            pvs.addPropertyValues((Map<?, ?>)this.getJobDetailDataMap(bundle));
            pvs.addPropertyValues((Map<?, ?>)this.getTriggerDataMap(bundle));
            if (this.ignoredUnknownProperties != null) {
                String[] stringArray = this.ignoredUnknownProperties;
                int n = this.ignoredUnknownProperties.length;
                int n2 = 0;
                while (n2 < n) {
                    String propName = stringArray[n2];
                    if (pvs.contains(propName) && !bw.isWritableProperty(propName)) {
                        pvs.removePropertyValue(propName);
                    }
                    ++n2;
                }
                bw.setPropertyValues(pvs);
            } else {
                bw.setPropertyValues(pvs, true);
            }
        }
        return job;
    }

    protected boolean isEligibleForPropertyPopulation(Object jobObject) {
        return !(jobObject instanceof QuartzJobBean);
    }

    private JobDataMap getJobDetailDataMap(TriggerFiredBundle bundle) throws Exception {
        Method getJobDetail = bundle.getClass().getMethod("getJobDetail", new Class[0]);
        Object jobDetail = ReflectionUtils.invokeMethod(getJobDetail, bundle);
        Method getJobDataMap = jobDetail.getClass().getMethod("getJobDataMap", new Class[0]);
        return (JobDataMap)ReflectionUtils.invokeMethod(getJobDataMap, jobDetail);
    }

    private JobDataMap getTriggerDataMap(TriggerFiredBundle bundle) throws Exception {
        Method getTrigger = bundle.getClass().getMethod("getTrigger", new Class[0]);
        Object trigger = ReflectionUtils.invokeMethod(getTrigger, bundle);
        Method getJobDataMap = trigger.getClass().getMethod("getJobDataMap", new Class[0]);
        return (JobDataMap)ReflectionUtils.invokeMethod(getJobDataMap, trigger);
    }
}

